/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.ActionContext;
import docking.ActionToGuiMapper;
import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.PopupActionManager;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingActionIf;
import docking.menu.MenuGroupMap;
import docking.menu.MenuHandler;
import docking.menu.MenuManager;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class DialogComponentProviderPopupActionManager {
    private List<DockingActionIf> popupActions = new ArrayList<DockingActionIf>();
    private DialogComponentProvider provider;

    public DialogComponentProviderPopupActionManager(DialogComponentProvider provider) {
        this.provider = provider;
    }

    void dispose() {
        this.provider = null;
        this.popupActions.clear();
    }

    void addAction(DockingActionIf action) {
        MenuData popupMenuData = action.getPopupMenuData();
        if (popupMenuData == null) {
            return;
        }
        this.popupActions.add(action);
    }

    void popupMenu(ActionContext actionContext, MouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (actionContext == null) {
            actionContext = new ActionContext();
        }
        if (actionContext.getSourceObject() == null) {
            actionContext.setSourceObject(e.getSource());
        }
        PopupMenuHandler popupMenuHandler = new PopupMenuHandler(actionContext);
        DockingWindowManager dwm = DockingWindowManager.getInstance(this.provider.getComponent());
        if (dwm == null) {
            return;
        }
        ActionToGuiMapper actionManager = dwm.getActionToGuiMapper();
        MenuGroupMap menuGroupMap = actionManager.getMenuGroupMap();
        MenuManager menuMgr = new MenuManager("Popup", '\u0000', null, true, popupMenuHandler, menuGroupMap);
        this.populatePopupMenuActions(dwm, menuMgr, actionContext);
        if (menuMgr.isEmpty()) {
            return;
        }
        JPopupMenu popupMenu = menuMgr.getPopupMenu();
        Component c = (Component)e.getSource();
        popupMenu.addPopupMenuListener(popupMenuHandler);
        popupMenu.show(c, e.getX(), e.getY());
    }

    private void populatePopupMenuActions(DockingWindowManager dwm, MenuManager menuMgr, ActionContext actionContext) {
        ActionToGuiMapper actionManager = dwm.getActionToGuiMapper();
        PopupActionManager toolPopupManager = actionManager.getPopupActionManager();
        Iterator<DockingActionIf> localActions = this.popupActions.iterator();
        toolPopupManager.populatePopupMenuActions(localActions, actionContext, menuMgr);
    }

    private class PopupMenuHandler
    extends MenuHandler {
        private final ActionContext actionContext;

        public PopupMenuHandler(ActionContext context) {
            this.actionContext = context;
        }

        @Override
        public void menuItemEntered(DockingActionIf action) {
            DockingWindowManager.setMouseOverAction(action);
        }

        @Override
        public void menuItemExited(DockingActionIf action) {
            DockingWindowManager.clearMouseOverHelp();
        }

        @Override
        public void processMenuAction(DockingActionIf action, ActionEvent event) {
            DockingWindowManager.clearMouseOverHelp();
            this.actionContext.setSourceObject(event.getSource());
            SwingUtilities.invokeLater(() -> {
                if (action.isEnabledForContext(this.actionContext)) {
                    if (action instanceof ToggleDockingActionIf) {
                        ToggleDockingActionIf toggleAction;
                        toggleAction.setSelected(!(toggleAction = (ToggleDockingActionIf)action).isSelected());
                    }
                    action.actionPerformed(this.actionContext);
                }
            });
        }
    }
}

