/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.PriorityJob;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public abstract class GTreeTask
extends PriorityJob {
    protected GTree tree;
    protected final JTree jTree;

    protected GTreeTask(GTree tree) {
        this.tree = tree;
        this.jTree = tree.getJTree();
    }

    protected void setTaskMonitor(TaskMonitor monitor) {
        super.setTaskMonitor(monitor);
        this.tree.setThreadLocalMonitor(monitor);
    }

    public void runOnSwingThread(Runnable runnable) {
        if (this.isCancelled()) {
            return;
        }
        SystemUtilities.runSwingNow((Runnable)new CheckCancelledRunnable(runnable));
    }

    protected TreePath translatePath(TreePath path, TaskMonitor monitor) {
        GTreeNode nodeForPath = (GTreeNode)SystemUtilities.runSwingNow(() -> this.tree.getViewNodeForPath(path));
        if (nodeForPath != null) {
            return nodeForPath.getTreePath();
        }
        return null;
    }

    class CheckCancelledRunnable
    implements Runnable {
        private final Runnable runnable;

        public CheckCancelledRunnable(Runnable runnable) {
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (!GTreeTask.this.isCancelled()) {
                this.runnable.run();
            }
        }
    }
}

