/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import javax.swing.tree.TreePath;

public class GTreeExpandAllTask
extends GTreeTask {
    private static final int MAX = 1000;
    private final GTreeNode node;

    public GTreeExpandAllTask(GTree tree, GTreeNode node) {
        super(tree);
        this.node = node;
    }

    public void run(TaskMonitor monitor) {
        monitor.initialize(1000L);
        monitor.setMessage("Expanding nodes...");
        try {
            this.expandNode(this.node, monitor);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    protected void expandNode(GTreeNode parent, TaskMonitor monitor) throws CancelledException {
        if (monitor.getProgress() >= 1000L) {
            return;
        }
        if (parent.isLeaf()) {
            return;
        }
        monitor.checkCanceled();
        List<GTreeNode> allChildren = parent.getChildren();
        if (allChildren.size() == 0) {
            return;
        }
        TreePath treePath = parent.getTreePath();
        if (!this.jTree.isExpanded(treePath)) {
            this.expandPath(treePath, monitor);
        }
        for (GTreeNode child : allChildren) {
            monitor.checkCanceled();
            this.expandNode(child, monitor);
        }
        monitor.incrementProgress(1L);
    }

    private void expandPath(final TreePath treePath, final TaskMonitor monitor) {
        this.runOnSwingThread(new Runnable(){

            @Override
            public void run() {
                if (monitor.isCancelled()) {
                    return;
                }
                GTreeExpandAllTask.this.jTree.expandPath(treePath);
            }
        });
    }
}

