/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.help.Help;
import docking.help.HelpService;
import docking.widgets.label.GHtmlLabel;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import docking.widgets.table.GTableCellRenderer;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.threaded.GThreadedTablePanel;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import ghidra.framework.main.FrontEndPlugin;
import ghidra.framework.main.datatable.DomainFileInfo;
import ghidra.framework.main.datatable.DomainFileType;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.datatable.ProjectDataTableDnDHandler;
import ghidra.framework.main.datatable.ProjectDataTableModel;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainObject;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.util.DateUtils;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.bean.GGlassPane;
import ghidra.util.bean.GGlassPanePainter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.CellRendererPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;

public class ProjectDataTablePanel
extends JPanel {
    private static final String MAX_FILE_COUNT_PROPERTY = "ProjectDataTable.maxFileCount";
    private static final int MAX_FILE_COUNT_DEFAULT = 2000;
    private static int maxFileCount = ProjectDataTablePanel.loadMaxFileCount();
    private FrontEndPlugin plugin;
    private PluginTool tool;
    private ProjectData projectData;
    private ProjectDataTableModel model;
    private boolean capacityExceeded;
    private GFilterTable<DomainFileInfo> table;
    private GTable gTable;
    private DomainFolderChangeListener changeListener;
    public Set<DomainFile> filesPendingSelection;
    private GHtmlLabel capacityExceededText = new GHtmlLabel("<HTML><CENTER><I>Table view disabled for very large projects, or<BR>if an older project/repository filesystem is in use.<BR>View will remain disabled until project is closed.</I></CENTER></HTML>");
    private GGlassPanePainter painter = new TableGlassPanePainter();

    public ProjectDataTablePanel(FrontEndPlugin plugin) {
        this.plugin = plugin;
        this.tool = plugin.getTool();
        this.buildContent();
        this.changeListener = new ProjectDataTableDomainFolderChangeListener();
    }

    private void buildContent() {
        this.model = new ProjectDataTableModel((ServiceProvider)this.tool);
        this.model.addThreadedTableModelListener(new SelectPendingFilesListener());
        this.table = new GFilterTable<DomainFileInfo>((RowObjectTableModel)this.model){

            protected GThreadedTablePanel<DomainFileInfo> createThreadedTablePanel(ThreadedTableModel<DomainFileInfo, ?> threadedModel) {
                return new GThreadedTablePanel<DomainFileInfo>(threadedModel){

                    protected GTable createTable(ThreadedTableModel<DomainFileInfo, ?> m) {
                        return new ProjectDataTable(m);
                    }
                };
            }
        };
        this.setLayout(new BorderLayout());
        this.add((Component)this.table, "Center");
        this.gTable = this.table.getTable();
        this.gTable.setActionsEnabled(true);
        this.gTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ProjectDataTablePanel.this.checkOpen(e);
            }
        });
        this.gTable.getSelectionModel().addListSelectionListener(e -> this.plugin.getTool().contextChanged(null));
        this.gTable.setDefaultRenderer(Date.class, (TableCellRenderer)((Object)new DateCellRenderer()));
        this.gTable.setDefaultRenderer(DomainFileType.class, (TableCellRenderer)((Object)new TypeCellRenderer()));
        new ProjectDataTableDnDHandler(this.gTable, this.model);
    }

    public void dispose() {
        this.table.dispose();
    }

    public void setHelpLocation(HelpLocation helpLocation) {
        HelpService help = Help.getHelpService();
        help.registerHelp(this.table, helpLocation);
    }

    public void setSelectedDomainFiles(Set<DomainFile> files) {
        if (this.model.isBusy()) {
            this.filesPendingSelection = files;
            return;
        }
        this.doSetSelectedDomainFiles(files);
    }

    private void doSetSelectedDomainFiles(Set<DomainFile> files) {
        ArrayList<Integer> rowList = new ArrayList<Integer>();
        ArrayList<DomainFileInfo> selectedRowObjects = new ArrayList<DomainFileInfo>();
        for (int row = 0; row < this.model.getRowCount(); ++row) {
            DomainFileInfo info = (DomainFileInfo)this.model.getRowObject(row);
            DomainFile domainFile = info.getDomainFile();
            if (!files.contains(domainFile)) continue;
            rowList.add(row);
            selectedRowObjects.add(info);
        }
        this.selectRows(rowList);
    }

    private void selectRows(List<Integer> rowList) {
        ListSelectionModel selectionModel = this.gTable.getSelectionModel();
        selectionModel.setValueIsAdjusting(true);
        selectionModel.clearSelection();
        for (Integer row : rowList) {
            selectionModel.addSelectionInterval(row, row);
        }
        selectionModel.setValueIsAdjusting(false);
    }

    public void setProjectData(String name, ProjectData projectData) {
        if (this.projectData != null) {
            this.projectData.removeDomainFolderChangeListener(this.changeListener);
            this.model.setProjectData(null);
        }
        this.projectData = projectData;
        this.capacityExceeded = false;
        if (projectData != null) {
            this.checkCapacity();
            if (!this.capacityExceeded) {
                this.model.setProjectData(projectData);
                projectData.addDomainFolderChangeListener(this.changeListener);
            }
        }
    }

    private void checkCapacity() {
        if (this.projectData == null) {
            return;
        }
        int fileCount = this.projectData.getFileCount();
        if (fileCount < 0 || fileCount > maxFileCount) {
            this.capacityExceeded = true;
            this.projectData.removeDomainFolderChangeListener(this.changeListener);
            this.model.setProjectData(null);
            SystemUtilities.runSwingLater(() -> {
                GGlassPane glassPane = (GGlassPane)this.gTable.getRootPane().getGlassPane();
                glassPane.removePainter(this.painter);
                glassPane.addPainter(this.painter);
            });
        }
    }

    public ActionContext getActionContext(ComponentProvider provider, MouseEvent e) {
        int[] selectedRows = this.gTable.getSelectedRows();
        if (selectedRows.length == 0) {
            return null;
        }
        ArrayList<DomainFile> list = new ArrayList<DomainFile>();
        for (int i : selectedRows) {
            DomainFileInfo info = (DomainFileInfo)this.model.getRowObject(i);
            list.add(info.getDomainFile());
        }
        return new ProjectDataContext(provider, this.projectData, this.model.getRowObject(selectedRows[0]), null, list, (Component)this.gTable, true);
    }

    private void checkOpen(MouseEvent e) {
        if (this.tool == null) {
            return;
        }
        if (e.getButton() != 1 || e.getClickCount() != 2) {
            return;
        }
        e.consume();
        Point point = e.getPoint();
        int rowAtPoint = this.gTable.rowAtPoint(point);
        if (rowAtPoint < 0) {
            return;
        }
        DomainFileInfo rowObject = (DomainFileInfo)this.model.getRowObject(rowAtPoint);
        DomainFile domainFile = rowObject.getDomainFile();
        this.plugin.openDomainFile(domainFile);
    }

    private void clearInfo(DomainFile file) {
        List modelData = this.model.getModelData();
        for (DomainFileInfo domainFileInfo : modelData) {
            if (!domainFileInfo.getDomainFile().equals(file)) continue;
            domainFileInfo.clearMetaCache();
            break;
        }
    }

    private void reload() {
        this.checkCapacity();
        if (!this.capacityExceeded) {
            this.model.reload();
        }
    }

    private static int loadMaxFileCount() {
        String property = System.getProperty(MAX_FILE_COUNT_PROPERTY, Integer.toString(2000));
        Integer intValue = null;
        try {
            intValue = Integer.parseInt(property);
            if (intValue <= 0) {
                intValue = null;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (intValue == null) {
            Msg.error(ProjectDataTablePanel.class, (Object)("Invalid ProjectDataTable.maxFileCount property value: " + property));
            return 2000;
        }
        return intValue;
    }

    private class TypeCellRenderer
    extends GTableCellRenderer {
        private TypeCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            renderer.setText("");
            if (value != null) {
                DomainFileType type = (DomainFileType)value;
                this.setToolTipText(type.getContentType());
                this.setText("");
                this.setIcon(type.getIcon());
            }
            return renderer;
        }
    }

    private class DateCellRenderer
    extends GTableCellRenderer {
        private DateCellRenderer() {
        }

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            JLabel renderer = (JLabel)super.getTableCellRendererComponent(data);
            Object value = data.getValue();
            if (value != null) {
                renderer.setText(DateUtils.formatDateTimestamp((Date)((Date)value)));
            } else {
                renderer.setText("");
            }
            return renderer;
        }
    }

    private class TableGlassPanePainter
    implements GGlassPanePainter {
        CellRendererPane renderer = new CellRendererPane();

        private TableGlassPanePainter() {
        }

        public void paint(GGlassPane glassPane, Graphics graphics) {
            if (!ProjectDataTablePanel.this.capacityExceeded || !ProjectDataTablePanel.this.gTable.isShowing()) {
                return;
            }
            Container container = ProjectDataTablePanel.this.gTable.getParent();
            Rectangle bounds = container.getBounds();
            bounds = SwingUtilities.convertRectangle(container, bounds, ProjectDataTablePanel.this.getRootPane().getContentPane());
            Dimension preferredSize = ProjectDataTablePanel.this.capacityExceededText.getPreferredSize();
            int width = Math.min(preferredSize.width, bounds.width);
            int height = Math.min(preferredSize.height, bounds.height);
            int x = bounds.x + (bounds.width / 2 - width / 2);
            int y = bounds.y + (bounds.height / 2 - height / 2);
            this.renderer.paintComponent(graphics, (Component)ProjectDataTablePanel.this.capacityExceededText, container, x, y, width, height);
        }
    }

    private class ProjectDataTable
    extends GTable {
        public ProjectDataTable(ThreadedTableModel<DomainFileInfo, ?> m) {
            super(m);
        }

        protected boolean supportsPopupActions() {
            return false;
        }
    }

    private class SelectPendingFilesListener
    implements ThreadedTableModelListener {
        private SelectPendingFilesListener() {
        }

        public void loadingFinished(boolean wasCancelled) {
            if (ProjectDataTablePanel.this.filesPendingSelection != null) {
                ProjectDataTablePanel.this.doSetSelectedDomainFiles(ProjectDataTablePanel.this.filesPendingSelection);
                ProjectDataTablePanel.this.filesPendingSelection = null;
            }
        }

        public void loadPending() {
        }

        public void loadingStarted() {
        }
    }

    private class ProjectDataTableDomainFolderChangeListener
    implements DomainFolderChangeListener {
        private ProjectDataTableDomainFolderChangeListener() {
        }

        private boolean ignoreChanges() {
            return ProjectDataTablePanel.this.model.loadWasCancelled() || ProjectDataTablePanel.this.capacityExceeded;
        }

        @Override
        public void domainFolderAdded(DomainFolder folder) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.reload();
        }

        @Override
        public void domainFileAdded(DomainFile file) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.checkCapacity();
            if (!ProjectDataTablePanel.this.capacityExceeded) {
                ProjectDataTablePanel.this.model.addObject(new DomainFileInfo(file));
            }
        }

        @Override
        public void domainFolderRemoved(DomainFolder parent, String name) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.model.refresh();
        }

        @Override
        public void domainFileRemoved(DomainFolder parent, String name, String fileID) {
            if (this.ignoreChanges()) {
                return;
            }
            String path = parent.getPathname();
            List modelData = ProjectDataTablePanel.this.model.getModelData();
            for (DomainFileInfo domainFileInfo : modelData) {
                if (!name.equals(domainFileInfo.getName()) || !path.equals(domainFileInfo.getPath())) continue;
                ProjectDataTablePanel.this.model.removeObject(domainFileInfo);
                break;
            }
        }

        @Override
        public void domainFolderRenamed(DomainFolder folder, String oldName) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.reload();
        }

        @Override
        public void domainFileRenamed(DomainFile file, String oldName) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.reload();
        }

        @Override
        public void domainFolderMoved(DomainFolder folder, DomainFolder oldParent) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.reload();
        }

        @Override
        public void domainFileMoved(DomainFile file, DomainFolder oldParent, String oldName) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.reload();
        }

        @Override
        public void domainFolderSetActive(DomainFolder folder) {
        }

        @Override
        public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.clearInfo(file);
            ProjectDataTablePanel.this.table.repaint();
            ProjectDataTablePanel.this.plugin.getTool().contextChanged(null);
        }

        @Override
        public void domainFileObjectReplaced(DomainFile file, DomainObject oldObject) {
            if (this.ignoreChanges()) {
                return;
            }
            ProjectDataTablePanel.this.clearInfo(file);
            ProjectDataTablePanel.this.table.repaint();
        }

        @Override
        public void domainFileObjectOpenedForUpdate(DomainFile file, DomainObject object) {
        }

        @Override
        public void domainFileObjectClosed(DomainFile file, DomainObject object) {
        }
    }
}

