/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import ghidra.framework.main.datatable.ProjectDataContext;
import ghidra.framework.main.datatable.ProjectDataContextToggleAction;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.model.DomainFile;
import ghidra.util.Msg;

public class ProjectDataReadOnlyAction
extends ProjectDataContextToggleAction {
    public ProjectDataReadOnlyAction(String owner, String group) {
        super("Read-Only", owner);
        this.setPopupMenuData(new MenuData(new String[]{"Read-Only"}, group));
        this.setSelected(false);
        this.markHelpUnnecessary();
    }

    @Override
    protected void actionPerformed(ProjectDataContext context) {
        DomainFile file = context.getSelectedFiles().get(0);
        this.toggleReadOnly(file);
        Object contextObject = context.getContextObject();
        if (contextObject instanceof DomainFileNode) {
            DomainFileNode node = (DomainFileNode)contextObject;
            node.fireNodeChanged(node.getParent(), node);
        }
    }

    @Override
    public boolean isAddToPopup(ProjectDataContext context) {
        if (!context.isInActiveProject()) {
            return false;
        }
        if (context.getFolderCount() != 0 || context.getFileCount() != 1) {
            return false;
        }
        DomainFile domainFile = context.getSelectedFiles().get(0);
        this.setSelected(domainFile.isReadOnly());
        return true;
    }

    @Override
    protected boolean isEnabledForContext(ProjectDataContext context) {
        if (context.getFolderCount() != 0 || context.getFileCount() != 1) {
            return false;
        }
        DomainFile domainFile = context.getSelectedFiles().get(0);
        return !domainFile.isVersioned();
    }

    private void toggleReadOnly(DomainFile file) {
        try {
            file.setReadOnly(!file.isReadOnly());
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, (String)("Error setting read-only state for " + file.getName()), (Object)e.getMessage(), (Throwable)e);
        }
    }
}

