/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ModificationWatchpointRequest;
import ghidra.dbg.jdi.manager.breakpoint.JdiBreakpointInfo;
import ghidra.dbg.jdi.model.JdiModelTargetAttributesContainer;
import ghidra.dbg.jdi.model.JdiModelTargetObjectImpl;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetType;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="Field", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="Attributes", type=JdiModelTargetAttributesContainer.class), @TargetAttributeType(type=Void.class)})
public class JdiModelTargetField
extends JdiModelTargetObjectImpl {
    protected final Field field;
    private JdiModelTargetType type;
    private JdiModelTargetReferenceType declaringType;
    private JdiModelTargetAttributesContainer addedAttributes;

    public JdiModelTargetField(JdiModelTargetObject fields, Field field, boolean isElement) {
        super(fields, field.toString(), field, isElement);
        this.field = field;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "_type", field.typeName()), "Initialized");
    }

    private void populateAttributes() {
        HashMap<String, Object> attrs;
        block2: {
            this.addedAttributes = new JdiModelTargetAttributesContainer(this, "Attributes");
            attrs = new HashMap<String, Object>();
            attrs.put("isEnumConstant", this.field.isEnumConstant());
            attrs.put("isFinal", this.field.isFinal());
            try {
                attrs.put("isPackagePrivate", this.field.isPackagePrivate());
                attrs.put("isPrivate", this.field.isPrivate());
                attrs.put("isProtected", this.field.isProtected());
                attrs.put("isPublic", this.field.isPublic());
            }
            catch (Exception e) {
                if (!(e instanceof ClassNotLoadedException)) break block2;
                attrs.put("status", "Class not loaded");
            }
        }
        attrs.put("isStatic", this.field.isStatic());
        attrs.put("isSynthetic", this.field.isSynthetic());
        attrs.put("isTransient", this.field.isTransient());
        attrs.put("isVolatile", this.field.isVolatile());
        attrs.put("modifiers", this.field.modifiers());
        this.addedAttributes.addAttributes(attrs);
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        this.declaringType = (JdiModelTargetReferenceType)this.getInstance(this.field.declaringType());
        this.populateAttributes();
        this.changeAttributes(List.of(), List.of(this.addedAttributes), Map.of("Declaring Type", this.declaringType), "Initialized");
        try {
            this.type = (JdiModelTargetType)this.getInstance(this.field.type());
            if (this.type != null) {
                this.changeAttributes(List.of(), List.of(), Map.of("Type", this.type), "Initialized");
            }
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        return this.field == null ? super.getDisplay() : this.field.name();
    }

    public JdiBreakpointInfo addAccessWatchpoint() {
        EventRequestManager eventManager = this.field.virtualMachine().eventRequestManager();
        AccessWatchpointRequest request = eventManager.createAccessWatchpointRequest(this.field);
        request.enable();
        return new JdiBreakpointInfo(request);
    }

    public JdiBreakpointInfo addModificationWatchpoint() {
        EventRequestManager eventManager = this.field.virtualMachine().eventRequestManager();
        ModificationWatchpointRequest request = eventManager.createModificationWatchpointRequest(this.field);
        request.enable();
        return new JdiBreakpointInfo(request);
    }
}

