/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.jdi.model;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import ghidra.dbg.jdi.model.JdiModelTargetObjectReferenceContainer;
import ghidra.dbg.jdi.model.JdiModelTargetReferenceType;
import ghidra.dbg.jdi.model.JdiModelTargetThread;
import ghidra.dbg.jdi.model.JdiModelTargetThreadContainer;
import ghidra.dbg.jdi.model.JdiModelTargetValue;
import ghidra.dbg.jdi.model.iface2.JdiModelTargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@TargetObjectSchemaInfo(name="ObjectReference", elements={@TargetElementType(type=Void.class)}, attributes={@TargetAttributeType(name="UID", type=Long.class, required=true, fixed=true), @TargetAttributeType(type=Object.class)})
public class JdiModelTargetObjectReference
extends JdiModelTargetValue {
    private static final long MAX_REFERRERS = 100L;
    protected final ObjectReference objref;
    protected JdiModelTargetThread owner;
    private JdiModelTargetReferenceType referenceType;

    public JdiModelTargetObjectReference(JdiModelTargetObject object, ObjectReference objref, boolean isElement) {
        this(object, Long.toString(objref.uniqueID()), objref, isElement);
    }

    public JdiModelTargetObjectReference(JdiModelTargetObject object, String id, ObjectReference objref, boolean isElement) {
        super(object, id, objref, isElement);
        this.objref = objref;
        this.changeAttributes(List.of(), List.of(), Map.of("_display", this.getDisplay(), "UID", objref.uniqueID()), "Initialized");
    }

    public CompletableFuture<Void> requestAttributes(boolean refresh) {
        this.referenceType = (JdiModelTargetReferenceType)this.getInstance(this.objref.referenceType());
        this.changeAttributes(List.of(), List.of(), Map.of(this.referenceType.getName(), this.referenceType), "Initialized");
        try {
            ThreadReference owningThread = this.objref.owningThread();
            if (owningThread != null) {
                this.owner = (JdiModelTargetThread)this.getInstance(owningThread);
                this.changeAttributes(List.of(), List.of(), Map.of("Owner", this.owner), "Initialized");
            }
        }
        catch (IncompatibleThreadStateException owningThread) {
            // empty catch block
        }
        try {
            List<ThreadReference> waitingThreads = this.objref.waitingThreads();
            if (waitingThreads != null) {
                JdiModelTargetThreadContainer targetWaitingThreads = new JdiModelTargetThreadContainer(this, "Waiting Threads", waitingThreads);
                this.changeAttributes(List.of(), List.of(targetWaitingThreads), Map.of(), "Initialized");
            }
        }
        catch (IncompatibleThreadStateException waitingThreads) {
            // empty catch block
        }
        try {
            JdiModelTargetObjectReferenceContainer referringObjects = new JdiModelTargetObjectReferenceContainer(this, "Referring Objects", this.objref.referringObjects(100L));
            this.changeAttributes(List.of(), List.of(referringObjects), Map.of(), "Initialized");
        }
        catch (UnsupportedOperationException referringObjects) {
        }
        catch (IllegalArgumentException referringObjects) {
            // empty catch block
        }
        try {
            int entryCount = this.objref.entryCount();
            this.changeAttributes(List.of(), List.of(), Map.of("Entry Count", entryCount), "Initialized");
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> init() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public String getDisplay() {
        return this.objref == null ? super.getDisplay() : this.objref.toString();
    }
}

