/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import com.google.common.collect.Range;
import docking.widgets.table.GTableHeaderRenderer;
import docking.widgets.table.RangeTableCellRenderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class RangeCursorTableHeaderRenderer<N extends Number>
extends GTableHeaderRenderer {
    protected static final int ARROW_SIZE = 10;
    protected static final Polygon ARROW = new Polygon(new int[]{0, -10, -10}, new int[]{0, 10, -10}, 3);
    protected Range<Double> fullRange = Range.closed((Comparable)Double.valueOf(0.0), (Comparable)Double.valueOf(1.0));
    protected double span = 1.0;
    protected N pos;
    protected double doublePos;

    public void setFullRange(Range<N> fullRange) {
        this.fullRange = RangeTableCellRenderer.validateViewRange(fullRange);
        this.span = (Double)this.fullRange.upperEndpoint() - (Double)this.fullRange.lowerEndpoint();
    }

    public void setCursorPosition(N pos) {
        this.pos = pos;
        this.doublePos = ((Number)pos).doubleValue();
    }

    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        this.paintCursor(g);
    }

    protected void paintCursor(Graphics parentG) {
        Graphics2D g = (Graphics2D)parentG.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        double x = (this.doublePos - (Double)this.fullRange.lowerEndpoint()) / this.span * (double)this.getWidth();
        g.translate(x, (double)this.getHeight());
        g.rotate(1.5707963267948966);
        g.setColor(this.getForeground());
        g.fillPolygon(ARROW);
    }

    public void addSeekListener(final JTable table, final int modelColumn, final Consumer<Double> listener) {
        final TableColumnModel colModel = table.getColumnModel();
        final JTableHeader header = table.getTableHeader();
        final TableColumn col = colModel.getColumn(modelColumn);
        MouseAdapter l = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiersEx() & 0x40) != 0) {
                    return;
                }
                if (e.getButton() != 1) {
                    return;
                }
                this.doSeek(e);
                e.consume();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int onmask = 1024;
                int offmask = 64;
                if ((e.getModifiersEx() & (onmask | offmask)) != onmask) {
                    return;
                }
                this.doSeek(e);
                e.consume();
            }

            protected void doSeek(MouseEvent e) {
                if (header.getResizingColumn() != null) {
                    return;
                }
                int viewColIdx = colModel.getColumnIndexAtX(e.getX());
                int modelColIdx = table.convertColumnIndexToModel(viewColIdx);
                if (modelColIdx != modelColumn) {
                    return;
                }
                TableColumn draggedCol = header.getDraggedColumn();
                if (draggedCol == col) {
                    header.setDraggedColumn(null);
                } else if (draggedCol != null) {
                    return;
                }
                int colX = 0;
                for (int i = 0; i < viewColIdx; ++i) {
                    colX += colModel.getColumn(i).getWidth();
                }
                TableColumn col2 = colModel.getColumn(viewColIdx);
                double pos = RangeCursorTableHeaderRenderer.this.span * (double)(e.getX() - colX) / (double)col2.getWidth() + (Double)RangeCursorTableHeaderRenderer.this.fullRange.lowerEndpoint();
                listener.accept(pos);
            }
        };
        header.addMouseListener(l);
        header.addMouseMotionListener(l);
    }

    public N getCursorPosition() {
        return this.pos;
    }
}

