/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import ghidra.util.Msg;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RowWrappedEnumeratedColumnTableModel<C extends Enum<C>, K, R, T>
extends DefaultEnumeratedColumnTableModel<C, R> {
    private final Function<T, K> keyFunc;
    private final Function<T, R> wrapper;
    private final Map<K, R> map = new HashMap<K, R>();

    public RowWrappedEnumeratedColumnTableModel(String name, Class<C> colType, Function<T, K> keyFunc, Function<T, R> wrapper) {
        super(name, colType);
        this.keyFunc = keyFunc;
        this.wrapper = wrapper;
    }

    protected synchronized R addRowFor(T t) {
        R row = this.wrapper.apply(t);
        R exists = this.map.put(this.keyFunc.apply(t), row);
        if (exists != null) {
            Msg.warn((Object)this, (Object)("Replaced existing row! row=" + exists));
        }
        return row;
    }

    protected synchronized R delRowFor(T t) {
        return this.delKey(this.keyFunc.apply(t));
    }

    protected synchronized R delKey(K k) {
        return this.map.remove(k);
    }

    protected synchronized List<R> addRowsFor(Stream<? extends T> s) {
        return s.map(this::addRowFor).collect(Collectors.toList());
    }

    protected synchronized List<R> addRowsFor(Collection<? extends T> c) {
        return this.addRowsFor(c.stream());
    }

    public synchronized R getRow(T t) {
        return this.map.get(this.keyFunc.apply(t));
    }

    protected synchronized List<R> getRows(Stream<? extends T> s) {
        return s.map(this::getRow).filter(r -> r != null).collect(Collectors.toList());
    }

    protected synchronized List<R> getRows(Collection<? extends T> c) {
        return this.getRows(c.stream());
    }

    public synchronized void addItem(T t) {
        if (this.map.containsKey(this.keyFunc.apply(t))) {
            return;
        }
        this.add(this.addRowFor(t));
    }

    public synchronized void addAllItems(Collection<? extends T> c) {
        Stream<Object> s = c.stream().filter(t -> {
            K k = this.keyFunc.apply(t);
            return !this.map.containsKey(k);
        });
        this.addAll(this.addRowsFor(s));
    }

    public void updateItem(T t) {
        R row = this.getRow(t);
        if (row == null) {
            return;
        }
        this.notifyUpdated(row);
    }

    public void updateAllItems(Collection<T> c) {
        this.notifyUpdatedWith(this.getRows(c)::contains);
    }

    public void deleteItem(T t) {
        R row = this.delRowFor(t);
        if (row == null) {
            return;
        }
        this.delete(row);
    }

    public R deleteKey(K k) {
        R r = this.delKey(k);
        if (r == null) {
            return null;
        }
        this.delete(r);
        return r;
    }

    public synchronized void deleteAllItems(Collection<T> c) {
        this.deleteWith(this.getRows(c)::contains);
        this.map.keySet().removeAll(c.stream().map(this.keyFunc).collect(Collectors.toList()));
    }

    public synchronized Map<K, R> getMap() {
        return Map.copyOf(this.map);
    }

    @Override
    public synchronized void clear() {
        this.map.clear();
        super.clear();
    }
}

