/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.emu.AbstractPcodeMachine;
import ghidra.pcode.emu.DefaultPcodeThread;
import ghidra.pcode.emulate.BreakTable;
import ghidra.pcode.emulate.BreakTableCallBack;
import ghidra.pcode.emulate.Emulate;
import ghidra.pcode.emulate.EmulateInstructionStateModifier;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeFrame;
import ghidra.pcode.exec.SleighLinkException;
import ghidra.pcode.exec.SleighUseropLibrary;
import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.Msg;
import java.lang.reflect.Constructor;

public abstract class AbstractModifiedPcodeThread<T>
extends DefaultPcodeThread<T> {
    protected final EmulateInstructionStateModifier modifier;
    protected final Emulate emulate;
    protected Address savedCounter;

    public AbstractModifiedPcodeThread(String name, AbstractPcodeMachine<T> machine) {
        super(name, machine);
        this.emulate = new GlueEmulate(this.language, new GlueMemoryState((Language)this.language), (BreakTable)new BreakTableCallBack(this.language));
        this.modifier = this.createModifier();
    }

    protected EmulateInstructionStateModifier createModifier() {
        String classname = this.language.getProperty("emulateInstructionStateModifierClass");
        if (classname == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName(classname);
            if (!EmulateInstructionStateModifier.class.isAssignableFrom(c)) {
                Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid emulateInstructionStateModifierClass"));
                throw new RuntimeException(classname + " does not implement interface " + EmulateInstructionStateModifier.class.getName());
            }
            Constructor<?> constructor = c.getConstructor(Emulate.class);
            return (EmulateInstructionStateModifier)constructor.newInstance(this.emulate);
        }
        catch (Exception e) {
            Msg.error((Object)this, (Object)("Language " + this.language.getLanguageID() + " does not specify a valid emulateInstructionStateModifierClass"));
            throw new RuntimeException("Failed to instantiate " + classname + " for language " + this.language.getLanguageID(), e);
        }
    }

    @Override
    protected DefaultPcodeThread.PcodeThreadExecutor createExecutor() {
        return new GluePcodeThreadExecutor(this.language, this.arithmetic, this.state);
    }

    protected abstract int getBytesChunk(byte[] var1, AddressSpace var2, long var3, int var5, boolean var6);

    protected abstract void setBytesChunk(byte[] var1, AddressSpace var2, long var3, int var5);

    @Override
    protected void preExecuteInstruction() {
        if (this.modifier != null) {
            this.savedCounter = this.getCounter();
            this.modifier.initialExecuteCallback(this.emulate, this.savedCounter, this.getContext());
        }
    }

    @Override
    protected void postExecuteInstruction() {
        if (this.modifier != null) {
            this.modifier.postExecuteCallback(this.emulate, this.savedCounter, this.frame.copyCode(), this.frame.getBranched(), this.getCounter());
        }
    }

    protected class GluePcodeThreadExecutor
    extends DefaultPcodeThread.PcodeThreadExecutor {
        public GluePcodeThreadExecutor(SleighLanguage language, PcodeArithmetic<T> arithmetic, PcodeExecutorStatePiece<T, T> state) {
            super(AbstractModifiedPcodeThread.this, language, arithmetic, state);
        }

        @Override
        public void executeCallother(PcodeOp op, PcodeFrame frame, SleighUseropLibrary<T> library) {
            block2: {
                try {
                    super.executeCallother(op, frame, library);
                }
                catch (SleighLinkException e) {
                    if (AbstractModifiedPcodeThread.this.modifier != null && AbstractModifiedPcodeThread.this.modifier.executeCallOther(op)) break block2;
                    throw e;
                }
            }
        }
    }

    protected class GlueMemoryState
    extends MemoryState {
        public GlueMemoryState(Language language) {
            super(language);
        }

        public int getChunk(byte[] res, AddressSpace spc, long off, int size, boolean stopOnUnintialized) {
            return AbstractModifiedPcodeThread.this.getBytesChunk(res, spc, off, size, stopOnUnintialized);
        }

        public void setChunk(byte[] val, AddressSpace spc, long off, int size) {
            AbstractModifiedPcodeThread.this.setBytesChunk(val, spc, off, size);
        }

        public void setInitialized(boolean initialized, AddressSpace spc, long off, int size) {
        }
    }

    protected class GlueEmulate
    extends Emulate {
        public GlueEmulate(SleighLanguage lang, MemoryState s, BreakTable b) {
            super(lang, s, b);
        }

        public Language getLanguage() {
            return AbstractModifiedPcodeThread.this.language;
        }

        public void setExecuteAddress(Address addr) {
            AbstractModifiedPcodeThread.this.overrideCounter(addr);
        }

        public Address getExecuteAddress() {
            return AbstractModifiedPcodeThread.this.getCounter();
        }

        public void setContextRegisterValue(RegisterValue regValue) {
            AbstractModifiedPcodeThread.this.overrideContext(regValue);
        }

        public RegisterValue getContextRegisterValue() {
            return AbstractModifiedPcodeThread.this.getContext();
        }
    }
}

