/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu;

import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.mem.MemBuffer;

public class ThreadPcodeExecutorState<T>
implements PcodeExecutorState<T> {
    protected final PcodeExecutorState<T> sharedState;
    protected final PcodeExecutorState<T> localState;

    public ThreadPcodeExecutorState(PcodeExecutorState<T> sharedState, PcodeExecutorState<T> localState) {
        this.sharedState = sharedState;
        this.localState = localState;
    }

    protected boolean isThreadLocalSpace(AddressSpace space) {
        return space.isRegisterSpace() || space.isUniqueSpace();
    }

    @Override
    public T longToOffset(AddressSpace space, long l) {
        if (this.isThreadLocalSpace(space)) {
            return (T)this.localState.longToOffset(space, l);
        }
        return (T)this.sharedState.longToOffset(space, l);
    }

    @Override
    public void setVar(AddressSpace space, T offset, int size, boolean truncateAddressableUnit, T val) {
        if (this.isThreadLocalSpace(space)) {
            this.localState.setVar(space, offset, size, truncateAddressableUnit, val);
        } else {
            this.sharedState.setVar(space, offset, size, truncateAddressableUnit, val);
        }
    }

    @Override
    public T getVar(AddressSpace space, T offset, int size, boolean truncateAddressableUnit) {
        if (this.isThreadLocalSpace(space)) {
            return this.localState.getVar(space, offset, size, truncateAddressableUnit);
        }
        return this.sharedState.getVar(space, offset, size, truncateAddressableUnit);
    }

    @Override
    public MemBuffer getConcreteBuffer(Address address) {
        assert (!this.isThreadLocalSpace(address.getAddressSpace()));
        return this.sharedState.getConcreteBuffer(address);
    }

    public PcodeExecutorState<T> getSharedState() {
        return this.sharedState;
    }

    public PcodeExecutorState<T> getLocalState() {
        return this.localState;
    }
}

