/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database;

import db.DBRecord;
import ghidra.program.database.DatabaseObject;
import ghidra.util.LockHold;
import ghidra.util.database.DBCachedDomainObjectAdapter;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.ObjectKey;
import java.io.IOException;
import java.util.List;

public class DBAnnotatedObject
extends DatabaseObject {
    private final DBCachedObjectStore<?> store;
    private final DBCachedDomainObjectAdapter adapter;
    private final List<DBCachedObjectStoreFactory.DBFieldCodec<?, ?, ?>> codecs;
    DBRecord record;

    public DBAnnotatedObject(DBCachedObjectStore<?> store, DBRecord record) {
        super(store == null ? null : store.cache, record == null ? -1L : record.getKey());
        this.store = store;
        this.record = record;
        if (store != null) {
            this.adapter = store.adapter;
            this.codecs = store.codecs;
        } else {
            this.adapter = null;
            this.codecs = null;
        }
    }

    public ObjectKey getObjectKey() {
        return new ObjectKey(this.store.adapter, this.store.table.getName(), this.key);
    }

    protected void write(DBObjectColumn column) {
        DBCachedObjectStoreFactory.DBFieldCodec<?, ?, ?> codec = this.codecs.get(column.columnNumber);
        codec.store(this, this.record);
    }

    protected void update(DBObjectColumn column) {
        this.write(column);
        try (LockHold hold = LockHold.lock(this.store.writeLock());){
            this.updated();
        }
        catch (IOException e) {
            this.store.dbError(e);
        }
    }

    protected void update(DBObjectColumn col1, DBObjectColumn col2) {
        this.write(col1);
        this.write(col2);
        try (LockHold hold = LockHold.lock(this.store.writeLock());){
            this.updated();
        }
        catch (IOException e) {
            this.store.dbError(e);
        }
    }

    protected void update(DBObjectColumn col1, DBObjectColumn col2, DBObjectColumn col3) {
        this.write(col1);
        this.write(col2);
        this.write(col3);
        try (LockHold hold = LockHold.lock(this.store.writeLock());){
            this.updated();
        }
        catch (IOException e) {
            this.store.dbError(e);
        }
    }

    protected void update(DBObjectColumn ... columns) {
        for (DBObjectColumn c : columns) {
            this.write(c);
        }
        try (LockHold hold = LockHold.lock(this.store.writeLock());){
            this.updated();
        }
        catch (IOException e) {
            this.store.dbError(e);
        }
    }

    protected void doUpdateAll() throws IOException {
        for (DBCachedObjectStoreFactory.DBFieldCodec<?, ?, ?> codec : this.codecs) {
            codec.store(this, this.record);
        }
        this.updated();
    }

    protected void updated() throws IOException {
        this.store.table.putRecord(this.record);
    }

    protected void fresh(boolean created) throws IOException {
    }

    private DBRecord getFreshRecord(DBRecord rec) throws IOException {
        if (rec != null) {
            return rec;
        }
        if (this.store == null) {
            return null;
        }
        if (this.store.table == null) {
            return null;
        }
        return this.store.table.getRecord(this.key);
    }

    protected boolean refresh() {
        LockHold hold = LockHold.lock(this.store.readLock());
        try {
            boolean bl = this.doRefresh(null);
            if (hold != null) {
                hold.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (hold != null) {
                    try {
                        hold.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                this.adapter.dbError(e);
                return false;
            }
        }
    }

    protected boolean refresh(DBRecord rec) {
        LockHold hold = LockHold.lock(this.store.readLock());
        try {
            boolean bl = this.doRefresh(rec);
            if (hold != null) {
                hold.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (hold != null) {
                    try {
                        hold.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException e) {
                this.store.dbError(e);
                return false;
            }
        }
    }

    protected boolean doRefresh(DBRecord rec) throws IOException {
        if ((rec = this.getFreshRecord(rec)) == null) {
            return false;
        }
        for (DBCachedObjectStoreFactory.DBFieldCodec<?, ?, ?> c : this.codecs) {
            c.load(this, rec);
        }
        this.record = rec;
        this.fresh(false);
        return true;
    }

    public boolean isDeleted() {
        return super.isDeleted(this.adapter.getLock());
    }
}

