/*
 * Decompiled with CFR 0.152.
 */
package utilities.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;

public enum ProxyUtilities {


    public static boolean areSameMethod(Method m1, Method m2) {
        if (!m1.getName().equals(m2.getName())) {
            return false;
        }
        if (!m1.getReturnType().equals(m2.getReturnType())) {
            return false;
        }
        return Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    public static MethodHandle getSuperMethodHandle(Method method) throws IllegalAccessException {
        return ProxyUtilities.getSuperMethodHandle(method, MethodHandles.lookup());
    }

    public static MethodHandle getSuperMethodHandle(Method method, MethodHandles.Lookup lookup) throws IllegalAccessException {
        Class<?> dCls = method.getDeclaringClass();
        return MethodHandles.privateLookupIn(dCls, lookup).unreflectSpecial(method, dCls);
    }

    public static <T, U> T composeOnDelegate(Class<T> iface, T delegate, List<Class<? extends U>> mixins, MethodHandles.Lookup lookup) {
        Class[] allIface = new Class[1 + mixins.size()];
        allIface = mixins.toArray(allIface);
        allIface[allIface.length - 1] = iface;
        ComposedHandler handler = new ComposedHandler(delegate, lookup);
        return (T)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), allIface, (InvocationHandler)handler);
    }

    private static class ComposedHandler
    implements InvocationHandler {
        private final Object delegate;
        private final MethodHandles.Lookup lookup;

        ComposedHandler(Object delegate, MethodHandles.Lookup lookup) {
            this.delegate = delegate;
            this.lookup = lookup;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Object result;
            if (method.getDeclaringClass().isAssignableFrom(this.delegate.getClass())) {
                MethodHandle handle = this.lookup.unreflect(method);
                result = handle.bindTo(this.delegate).invokeWithArguments(args);
            } else {
                if (!method.isDefault()) {
                    throw new IllegalStateException("Delegate must implement abstract methods from all mixins. Missed: " + method);
                }
                MethodHandle mh = ProxyUtilities.getSuperMethodHandle(method, this.lookup);
                result = mh.bindTo(proxy).invokeWithArguments(args);
            }
            return result;
        }
    }
}

