/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.assembler.sleigh.sem;

import ghidra.app.plugin.assembler.sleigh.expr.MaskedLong;
import ghidra.app.plugin.assembler.sleigh.expr.RecursiveDescentSolver;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyConstructorSemantic;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyPatternBlock;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolution;
import ghidra.app.plugin.assembler.sleigh.sem.AssemblyResolvedBackfill;
import ghidra.app.plugin.processors.sleigh.ContextOp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.lang3.StringUtils;

public class AssemblyResolvedConstructor
extends AssemblyResolution {
    protected static final String INS = "ins:";
    protected static final String CTX = "ctx:";
    protected static final String SEP = ",";
    protected final AssemblyPatternBlock ins;
    protected final AssemblyPatternBlock ctx;
    protected final Set<AssemblyResolvedBackfill> backfills;
    protected final Set<AssemblyResolvedConstructor> forbids;
    protected static final Pattern pat = Pattern.compile("line(\\d*)");

    @Override
    protected int computeHash() {
        int result = 0;
        result += this.ins.hashCode();
        result *= 31;
        result += this.ctx.hashCode();
        result *= 31;
        result += this.backfills.hashCode();
        result *= 31;
        return result += this.forbids.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AssemblyResolvedConstructor)) {
            return false;
        }
        AssemblyResolvedConstructor that = (AssemblyResolvedConstructor)obj;
        if (!this.ins.equals(that.ins)) {
            return false;
        }
        if (!this.ctx.equals(that.ctx)) {
            return false;
        }
        if (!this.backfills.equals(that.backfills)) {
            return false;
        }
        return this.forbids.equals(that.forbids);
    }

    AssemblyResolvedConstructor(String description, List<? extends AssemblyResolution> children, AssemblyPatternBlock ins, AssemblyPatternBlock ctx, Set<AssemblyResolvedBackfill> backfills, Set<AssemblyResolvedConstructor> forbids) {
        super(description, children);
        this.ins = ins;
        this.ctx = ctx;
        this.backfills = backfills == null ? Set.of() : backfills;
        this.forbids = forbids == null ? Set.of() : forbids;
    }

    public static AssemblyResolvedConstructor fromString(String str, String description, List<AssemblyResolution> children) {
        AssemblyPatternBlock ins = null;
        if (str.startsWith(INS)) {
            int end = str.indexOf(SEP);
            if (end == -1) {
                end = str.length();
            }
            ins = AssemblyPatternBlock.fromString(str.substring(INS.length(), end));
            if ((str = str.substring(end)).startsWith(SEP)) {
                str = str.substring(1);
            }
        }
        AssemblyPatternBlock ctx = null;
        if (str.startsWith(CTX)) {
            int end = str.length();
            ctx = AssemblyPatternBlock.fromString(str.substring(CTX.length(), end));
            str = str.substring(end);
        }
        if (str.length() != 0) {
            throw new IllegalArgumentException(str);
        }
        return AssemblyResolution.resolved(ins == null ? AssemblyPatternBlock.nop() : ins, ctx == null ? AssemblyPatternBlock.nop() : ctx, description, children);
    }

    public AssemblyResolvedConstructor shift(int amt) {
        if (amt == 0) {
            return this;
        }
        AssemblyPatternBlock newIns = this.ins.shift(amt);
        HashSet<AssemblyResolvedBackfill> newBackfills = new HashSet<AssemblyResolvedBackfill>();
        for (AssemblyResolvedBackfill bf : this.backfills) {
            newBackfills.add(bf.shift(amt));
        }
        HashSet<AssemblyResolvedConstructor> newForbids = new HashSet<AssemblyResolvedConstructor>();
        for (AssemblyResolvedConstructor f : this.forbids) {
            newForbids.add(f.shift(amt));
        }
        return new AssemblyResolvedConstructor(this.description, this.children, newIns, this.ctx, Collections.unmodifiableSet(newBackfills), Collections.unmodifiableSet(newForbids));
    }

    public AssemblyResolvedConstructor truncate(int amt) {
        if (amt == 0) {
            return this;
        }
        AssemblyPatternBlock newIns = this.ins.truncate(amt);
        return new AssemblyResolvedConstructor("Truncated: " + this.description, null, newIns, this.ctx, null, null);
    }

    public AssemblyResolution checkNotForbidden() {
        HashSet<AssemblyResolvedConstructor> newForbids = new HashSet<AssemblyResolvedConstructor>();
        for (AssemblyResolvedConstructor f : this.forbids) {
            AssemblyResolvedConstructor check = this.combine(f);
            if (null == check) continue;
            newForbids.add(f);
            if (!check.bitsEqual(this)) continue;
            return AssemblyResolution.error("The result is forbidden by " + f, this);
        }
        return new AssemblyResolvedConstructor(this.description, this.children, this.ins, this.ctx, this.backfills, Collections.unmodifiableSet(newForbids));
    }

    protected boolean bitsEqual(AssemblyResolvedConstructor that) {
        return this.ins.equals(that.ins) && this.ctx.equals(that.ctx);
    }

    public AssemblyResolvedConstructor combine(AssemblyResolvedConstructor that) {
        return this.combineLessBackfill(that, null);
    }

    protected AssemblyResolvedConstructor combineLessBackfill(AssemblyResolvedConstructor that, AssemblyResolvedBackfill bf) {
        AssemblyPatternBlock newIns = this.ins.combine(that.ins);
        if (newIns == null) {
            return null;
        }
        AssemblyPatternBlock newCtx = this.ctx.combine(that.ctx);
        if (newCtx == null) {
            return null;
        }
        HashSet<AssemblyResolvedBackfill> newBackfills = new HashSet<AssemblyResolvedBackfill>(this.backfills);
        newBackfills.addAll(that.backfills);
        if (bf != null) {
            newBackfills.remove(bf);
        }
        HashSet<AssemblyResolvedConstructor> newForbids = new HashSet<AssemblyResolvedConstructor>(this.forbids);
        newForbids.addAll(that.forbids);
        return new AssemblyResolvedConstructor(this.description, this.children, newIns, newCtx, Collections.unmodifiableSet(newBackfills), Collections.unmodifiableSet(newForbids));
    }

    public AssemblyResolvedConstructor combine(AssemblyResolvedBackfill bf) {
        HashSet<AssemblyResolvedBackfill> newBackfills = new HashSet<AssemblyResolvedBackfill>(this.backfills);
        newBackfills.add(bf);
        return new AssemblyResolvedConstructor(this.description, this.children, this.ins, this.ctx, Collections.unmodifiableSet(newBackfills), this.forbids);
    }

    public AssemblyResolvedConstructor withForbids(Set<AssemblyResolvedConstructor> more) {
        HashSet<AssemblyResolvedConstructor> combForbids = new HashSet<AssemblyResolvedConstructor>(this.forbids);
        combForbids.addAll(more);
        return new AssemblyResolvedConstructor(this.description, this.children, this.ins, this.ctx, this.backfills, Collections.unmodifiableSet(more));
    }

    public AssemblyResolvedConstructor withDescription(String desc) {
        return new AssemblyResolvedConstructor(desc, this.children, this.ins, this.ctx, this.backfills, this.forbids);
    }

    public AssemblyResolvedConstructor writeContextOp(ContextOp cop, MaskedLong val) {
        AssemblyPatternBlock newCtx = this.ctx.writeContextOp(cop, val);
        return new AssemblyResolvedConstructor(this.description, this.children, this.ins, newCtx, this.backfills, this.forbids);
    }

    public MaskedLong readContextOp(ContextOp cop) {
        return this.ctx.readContextOp(cop);
    }

    public AssemblyResolvedConstructor copyAppendDescription(String append) {
        AssemblyResolvedConstructor cp = new AssemblyResolvedConstructor(this.description + ": " + append, this.children, this.ins.copy(), this.ctx.copy(), this.backfills, this.forbids);
        return cp;
    }

    public AssemblyResolvedConstructor maskOut(ContextOp cop) {
        AssemblyPatternBlock newCtx = this.ctx.maskOut(cop);
        return new AssemblyResolvedConstructor(this.description, this.children, this.ins, newCtx, this.backfills, this.forbids);
    }

    public AssemblyResolution backfill(RecursiveDescentSolver solver, Map<String, Long> vals) {
        if (!this.hasBackfills()) {
            return this;
        }
        AssemblyResolvedConstructor res = this;
        block0: while (true) {
            for (AssemblyResolvedBackfill bf : res.backfills) {
                AssemblyResolution ar = bf.solve(solver, vals, this);
                if (ar.isError()) continue;
                AssemblyResolvedConstructor rc = (AssemblyResolvedConstructor)ar;
                AssemblyResolvedConstructor check = res.combineLessBackfill(rc, bf);
                if (check == null) {
                    return AssemblyResolution.error("Conflict: Backfill " + bf.description, res);
                }
                res = check;
                continue block0;
            }
            break;
        }
        return res;
    }

    @Override
    public String lineToString() {
        return this.dumpConstructorTree() + ":ins:" + this.ins + ",ctx:" + this.ctx + " (" + this.description + ")";
    }

    public boolean hasBackfills() {
        return !this.backfills.isEmpty();
    }

    private boolean hasForbids() {
        return !this.forbids.isEmpty();
    }

    public AssemblyResolvedConstructor solveContextChangesForForbids(AssemblyConstructorSemantic sem, Map<String, Long> vals, Map<Integer, Object> opvals) {
        if (!this.hasForbids()) {
            return this;
        }
        HashSet<AssemblyResolvedConstructor> newForbids = new HashSet<AssemblyResolvedConstructor>();
        for (AssemblyResolvedConstructor f : this.forbids) {
            AssemblyResolution t = sem.solveContextChanges(f, vals, opvals);
            if (!(t instanceof AssemblyResolvedConstructor)) continue;
            newForbids.add((AssemblyResolvedConstructor)t);
        }
        return new AssemblyResolvedConstructor(this.description, this.children, this.ins, this.ctx, this.backfills, Collections.unmodifiableSet(newForbids));
    }

    public int getInstructionLength() {
        int inslen = this.ins.length();
        for (AssemblyResolvedBackfill bf : this.backfills) {
            inslen = Math.max(inslen, bf.getInstructionLength());
        }
        return inslen;
    }

    public int getDefinedInstructionLength() {
        int i;
        byte[] imsk = this.ins.getMask();
        for (i = imsk.length - 1; i >= 0 && imsk[i] == 0; --i) {
        }
        return this.ins.getOffset() + i + 1;
    }

    public AssemblyPatternBlock getInstruction() {
        return this.ins;
    }

    public AssemblyPatternBlock getContext() {
        return this.ctx;
    }

    public MaskedLong readInstruction(int start, int len) {
        return this.ins.readBytes(start, len);
    }

    public MaskedLong readContext(int start, int len) {
        return this.ctx.readBytes(start, len);
    }

    @Override
    public boolean isError() {
        return false;
    }

    @Override
    public boolean isBackfill() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return super.hasChildren() || this.hasBackfills() || this.hasForbids();
    }

    @Override
    protected String childrenToString(String indent) {
        StringBuilder sb = new StringBuilder();
        if (super.hasChildren()) {
            sb.append(super.childrenToString(indent) + "\n");
        }
        for (AssemblyResolvedBackfill bf : this.backfills) {
            sb.append(indent);
            sb.append("backfill: " + bf + "\n");
        }
        for (AssemblyResolvedConstructor f : this.forbids) {
            sb.append(indent);
            sb.append("forbidden: " + f + "\n");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public String dumpConstructorTree() {
        StringBuilder sb = new StringBuilder();
        Matcher mat = pat.matcher(this.description);
        if (!mat.find()) {
            return null;
        }
        sb.append(mat.group(1));
        if (this.children == null) {
            return sb.toString();
        }
        ArrayList<String> subs = new ArrayList<String>();
        for (AssemblyResolution c : this.children) {
            AssemblyResolvedConstructor rc;
            String s;
            if (!(c instanceof AssemblyResolvedConstructor) || (s = (rc = (AssemblyResolvedConstructor)c).dumpConstructorTree()) == null) continue;
            subs.add(s);
        }
        if (subs.isEmpty()) {
            return sb.toString();
        }
        sb.append('[');
        sb.append(StringUtils.join(subs, (String)SEP));
        sb.append(']');
        return sb.toString();
    }

    public int getSpecificity() {
        return this.ins.getSpecificity() + this.ctx.getSpecificity();
    }

    public Iterable<byte[]> possibleInsVals(AssemblyPatternBlock forCtx) {
        final Predicate removeForbidden = val -> {
            for (AssemblyResolvedConstructor f : this.forbids) {
                AssemblyPatternBlock vi;
                AssemblyPatternBlock i;
                if (f.getDefinedInstructionLength() > ((byte[])val).length || null == f.getContext().combine(forCtx) || null == (i = f.getInstruction()).combine(vi = AssemblyPatternBlock.fromBytes(this.ins.length() - ((byte[])val).length, val))) continue;
                return false;
            }
            return true;
        };
        return new Iterable<byte[]>(){

            @Override
            public Iterator<byte[]> iterator() {
                return IteratorUtils.filteredIterator(AssemblyResolvedConstructor.this.ins.possibleVals().iterator(), (Predicate)removeForbidden);
            }
        };
    }
}

