/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.template;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ConstTpl {
    public static final int REAL = 0;
    public static final int HANDLE = 1;
    public static final int J_START = 2;
    public static final int J_NEXT = 3;
    public static final int J_CURSPACE = 4;
    public static final int J_CURSPACE_SIZE = 5;
    public static final int SPACEID = 6;
    public static final int J_RELATIVE = 7;
    public static final int J_FLOWREF = 8;
    public static final int J_FLOWREF_SIZE = 9;
    public static final int J_FLOWDEST = 10;
    public static final int J_FLOWDEST_SIZE = 11;
    public static final int V_SPACE = 0;
    public static final int V_OFFSET = 1;
    public static final int V_SIZE = 2;
    public static final int V_OFFSET_PLUS = 3;
    public static final long[] calc_mask = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL, -1L};
    private int type;
    private long value_real;
    private AddressSpace value_spaceid;
    private short handle_index;
    private short select;

    protected ConstTpl() {
        this.type = 0;
        this.value_real = 0L;
    }

    public ConstTpl(ConstTpl op2) {
        this.type = op2.type;
        this.value_real = op2.value_real;
        this.value_spaceid = op2.value_spaceid;
        this.handle_index = op2.handle_index;
        this.select = op2.select;
    }

    public ConstTpl(int tp, long val) {
        this.type = tp;
        this.value_real = val;
    }

    public ConstTpl(int tp) {
        this.type = tp;
    }

    public ConstTpl(AddressSpace spc) {
        this.type = 6;
        this.value_spaceid = spc;
    }

    public ConstTpl(int tp, int ht, int vf) {
        this.type = 1;
        this.handle_index = (short)ht;
        this.select = (short)vf;
    }

    public boolean isConstSpace() {
        if (this.type == 6) {
            return this.value_spaceid.getType() == 0;
        }
        return false;
    }

    public boolean isUniqueSpace() {
        if (this.type == 6) {
            return this.value_spaceid.getType() == 3;
        }
        return false;
    }

    public long getReal() {
        return this.value_real;
    }

    public AddressSpace getSpaceId() {
        return this.value_spaceid;
    }

    public int getHandleIndex() {
        return this.handle_index;
    }

    public int getType() {
        return this.type;
    }

    public long fix(ParserWalker walker) {
        switch (this.type) {
            case 2: {
                return walker.getAddr().getOffset();
            }
            case 3: {
                return walker.getNaddr().getOffset();
            }
            case 8: {
                return walker.getFlowRefAddr().getOffset();
            }
            case 9: {
                return walker.getFlowRefAddr().getAddressSpace().getPointerSize();
            }
            case 10: {
                return walker.getFlowDestAddr().getOffset();
            }
            case 11: {
                return walker.getFlowDestAddr().getAddressSpace().getPointerSize();
            }
            case 5: {
                return walker.getCurSpace().getPointerSize();
            }
            case 4: {
                return walker.getCurSpace().getSpaceID();
            }
            case 1: {
                FixedHandle hand = walker.getFixedHandle(this.handle_index);
                switch (this.select) {
                    case 0: {
                        if (hand.offset_space == null) {
                            return hand.space.getSpaceID();
                        }
                        return hand.temp_space.getSpaceID();
                    }
                    case 1: {
                        if (hand.offset_space == null) {
                            return hand.offset_offset;
                        }
                        return hand.temp_offset;
                    }
                    case 2: {
                        return hand.size;
                    }
                    case 3: {
                        if (hand.space.getType() != 0) {
                            if (hand.offset_space == null) {
                                return hand.offset_offset + (this.value_real & 0xFFFFL);
                            }
                            return hand.temp_offset + (this.value_real & 0xFFFFL);
                        }
                        long val = hand.offset_space == null ? hand.offset_offset : hand.temp_offset;
                        return val >>= (int)(8L * (this.value_real >> 16));
                    }
                }
                break;
            }
            case 0: 
            case 7: {
                return this.value_real;
            }
            case 6: {
                return this.value_spaceid.getSpaceID();
            }
        }
        return 0L;
    }

    public AddressSpace fixSpace(ParserWalker walker) throws SleighException {
        switch (this.type) {
            case 4: {
                return walker.getCurSpace();
            }
            case 1: {
                FixedHandle hand = walker.getFixedHandle(this.handle_index);
                switch (this.select) {
                    case 0: {
                        if (hand.offset_space == null) {
                            return hand.space;
                        }
                        return hand.temp_space;
                    }
                }
                break;
            }
            case 6: {
                return this.value_spaceid;
            }
            case 8: {
                return walker.getFlowRefAddr().getAddressSpace();
            }
        }
        throw new SleighException("ConstTpl is not a spaceid as expected");
    }

    public void fillinSpace(FixedHandle hand, ParserWalker walker) {
        switch (this.type) {
            case 4: {
                hand.space = walker.getCurSpace();
                return;
            }
            case 1: {
                FixedHandle otherhand = walker.getFixedHandle(this.handle_index);
                switch (this.select) {
                    case 0: {
                        hand.space = otherhand.space;
                        return;
                    }
                }
            }
            case 6: {
                hand.space = this.value_spaceid;
                return;
            }
        }
        throw new SleighException("ConstTpl is not a spaceid as expected");
    }

    public void fillinOffset(FixedHandle hand, ParserWalker walker) {
        if (this.type == 1) {
            FixedHandle otherhand = walker.getFixedHandle(this.handle_index);
            hand.offset_space = otherhand.offset_space;
            hand.offset_offset = otherhand.offset_offset;
            hand.offset_size = otherhand.offset_size;
            hand.temp_space = otherhand.temp_space;
            hand.temp_offset = otherhand.temp_offset;
        } else {
            hand.offset_space = null;
            hand.offset_offset = this.fix(walker);
            hand.offset_offset = hand.space.truncateOffset(hand.offset_offset);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void restoreXml(XmlPullParser parser, AddressFactory factory) {
        XmlElement el = parser.start(new String[]{"const_tpl"});
        String typestr = el.getAttribute("type");
        if (typestr.equals("real")) {
            this.type = 0;
            this.value_real = SpecXmlUtils.decodeLong((String)el.getAttribute("val"));
        } else if (typestr.equals("handle")) {
            this.type = 1;
            this.handle_index = (short)SpecXmlUtils.decodeInt((String)el.getAttribute("val"));
            String selstr = el.getAttribute("s");
            if (selstr.equals("space")) {
                this.select = 0;
            } else if (selstr.equals("offset")) {
                this.select = 1;
            } else if (selstr.equals("size")) {
                this.select = (short)2;
            } else {
                if (!selstr.equals("offset_plus")) throw new SleighException("Bad handle selector");
                this.select = (short)3;
                this.value_real = SpecXmlUtils.decodeLong((String)el.getAttribute("plus"));
            }
        } else if (typestr.equals("start")) {
            this.type = 2;
        } else if (typestr.equals("next")) {
            this.type = 3;
        } else if (typestr.equals("curspace")) {
            this.type = 4;
        } else if (typestr.equals("curspace_size")) {
            this.type = 5;
        } else if (typestr.equals("spaceid")) {
            this.type = 6;
            this.value_spaceid = factory.getAddressSpace(el.getAttribute("name"));
        } else if (typestr.equals("relative")) {
            this.type = 7;
            this.value_real = SpecXmlUtils.decodeLong((String)el.getAttribute("val"));
        } else if (typestr.equals("flowref")) {
            this.type = 8;
        } else if (typestr.equals("flowref_size")) {
            this.type = 9;
        } else if (typestr.equals("flowdest")) {
            this.type = 10;
        } else {
            if (!typestr.equals("flowdest_size")) throw new SleighException("Bad xml for ConstTpl");
            this.type = 11;
        }
        parser.end(el);
    }

    public String toString() {
        switch (this.type) {
            case 6: {
                return this.value_spaceid.getName();
            }
            case 0: {
                return Long.toHexString(this.value_real);
            }
            case 1: {
                switch (this.select) {
                    case 0: {
                        return "[handle:space]";
                    }
                    case 2: {
                        return "[handle:size]";
                    }
                    case 1: {
                        return "[handle:offset]";
                    }
                    case 3: {
                        return "[handle:offset+" + Long.toHexString(this.value_real) + "]";
                    }
                }
            }
            case 4: {
                return "[curspace]";
            }
            case 5: {
                return "[curspace_size]";
            }
            case 10: {
                return "[flowdest]";
            }
            case 11: {
                return "[flowdest_size]";
            }
            case 8: {
                return "[flowref]";
            }
            case 9: {
                return "[flowref_size]";
            }
            case 3: {
                return "[next]";
            }
            case 2: {
                return "[start]";
            }
            case 7: {
                return "[rel:" + Long.toHexString(this.value_real) + "]";
            }
        }
        throw new RuntimeException("This should be unreachable");
    }
}

