/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.ProgramAddressFactory;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.program.util.LanguageTranslator;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.HashMap;

class OverlaySpaceAdapterDB {
    private static String TABLE_NAME = "Overlay Spaces";
    static final Schema SCHEMA = new Schema(0, "ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, LongField.INSTANCE}, new String[]{"Overlay Space", "Template Space", "Minimum Offset", "Maximum Offset"});
    private static final int OV_SPACE_NAME_COL = 0;
    private static final int OV_SPACE_BASE_COL = 1;
    private static final int OV_MIN_OFFSET_COL = 2;
    private static final int OV_MAX_OFFSET_COL = 3;
    DBHandle db;

    OverlaySpaceAdapterDB(DBHandle dbHandle) {
        this.db = dbHandle;
    }

    void initializeOverlaySpaces(ProgramAddressFactory factory) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table != null) {
            for (DBRecord rec : table) {
                String spaceName = rec.getString(0);
                String templateSpaceName = rec.getString(1);
                long minOffset = rec.getLongValue(2);
                long maxOffset = rec.getLongValue(3);
                AddressSpace space = factory.getAddressSpace(templateSpaceName);
                try {
                    OverlayAddressSpace sp = factory.addOverlayAddressSpace(spaceName, true, space, minOffset, maxOffset);
                    sp.setDatabaseKey(rec.getKey());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Unexpected error initializing overlay address spaces", e);
                }
            }
        }
    }

    void addOverlaySpace(OverlayAddressSpace ovSpace) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table == null) {
            table = this.db.createTable(TABLE_NAME, SCHEMA);
        }
        DBRecord rec = SCHEMA.createRecord(table.getKey());
        rec.setString(0, ovSpace.getName());
        rec.setString(1, ovSpace.getOverlayedSpace().getName());
        rec.setLongValue(2, ovSpace.getMinOffset());
        rec.setLongValue(3, ovSpace.getMaxOffset());
        table.putRecord(rec);
        ovSpace.setDatabaseKey(rec.getKey());
    }

    void removeOverlaySpace(String name) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table != null) {
            RecordIterator it = table.iterator();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                String spaceName = rec.getString(0);
                if (!name.equals(spaceName)) continue;
                it.delete();
                return;
            }
        }
    }

    void updateOverlaySpaces(ProgramAddressFactory factory) throws IOException {
        HashMap<Long, OverlayAddressSpace> map = new HashMap<Long, OverlayAddressSpace>();
        for (AddressSpace space : factory.getAllAddressSpaces()) {
            if (!(space instanceof OverlayAddressSpace)) continue;
            OverlayAddressSpace os = (OverlayAddressSpace)space;
            map.put(os.getDatabaseKey(), os);
        }
        Table table = this.db.getTable(TABLE_NAME);
        if (table != null) {
            for (DBRecord rec : table) {
                String spaceName;
                AddressSpace space;
                space = (OverlayAddressSpace)map.remove(rec.getKey());
                if (space != null) {
                    spaceName = rec.getString(0);
                    if (spaceName.equals(((OverlayAddressSpace)space).getName())) continue;
                    factory.removeOverlaySpace(((OverlayAddressSpace)space).getName());
                    ((OverlayAddressSpace)space).setName(rec.getString(0));
                    try {
                        factory.addOverlayAddressSpace((OverlayAddressSpace)space);
                        continue;
                    }
                    catch (DuplicateNameException e) {
                        throw new RuntimeException("Unexpected error updating overlay address spaces", e);
                    }
                }
                spaceName = rec.getString(0);
                long minOffset = rec.getLongValue(2);
                long maxOffset = rec.getLongValue(3);
                AddressSpace origSpace = factory.getAddressSpace(rec.getString(1));
                try {
                    space = factory.addOverlayAddressSpace(spaceName, true, origSpace, minOffset, maxOffset);
                    ((OverlayAddressSpace)space).setDatabaseKey(rec.getKey());
                }
                catch (IllegalArgumentException e) {
                    throw new RuntimeException("Unexpected error updating overlay address spaces", e);
                }
            }
        }
        for (OverlayAddressSpace space : map.values()) {
            factory.removeOverlaySpace(space.getName());
        }
    }

    public void renameOverlaySpace(String oldName, String newName) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table != null) {
            RecordIterator it = table.iterator();
            while (it.hasNext()) {
                DBRecord rec = it.next();
                String spaceName = rec.getString(0);
                if (!oldName.equals(spaceName)) continue;
                it.delete();
                rec.setString(0, newName);
                table.putRecord(rec);
                return;
            }
        }
    }

    void setLanguage(Language newLanguage, ProgramAddressFactory addrFactory, LanguageTranslator translator) throws IOException {
        Table table = this.db.getTable(TABLE_NAME);
        if (table != null) {
            for (DBRecord rec : table) {
                String oldUnderlyingSpaceName = rec.getString(1);
                AddressSpace space = addrFactory.getAddressSpace(oldUnderlyingSpaceName);
                if (space != null && space.isNonLoadedMemorySpace()) continue;
                AddressSpace newSpace = translator.getNewAddressSpace(oldUnderlyingSpaceName);
                if (newSpace == null) {
                    throw new IOException("Failed to map old address space: " + oldUnderlyingSpaceName);
                }
                rec.setString(1, newSpace.getName());
                table.putRecord(rec);
            }
        }
        this.initializeOverlaySpaces(addrFactory);
    }
}

