/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BooleanField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.IntField;
import db.LongField;
import db.RecordIterator;
import db.RecordTranslator;
import db.Schema;
import db.StringField;
import db.Table;
import db.TranslatedRecordIterator;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.util.UniversalID;
import ghidra.util.UniversalIdGenerator;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class CompositeDBAdapterV0
extends CompositeDBAdapter
implements RecordTranslator {
    static final int VERSION = 0;
    static final int V0_COMPOSITE_NAME_COL = 0;
    static final int V0_COMPOSITE_COMMENT_COL = 1;
    static final int V0_COMPOSITE_IS_UNION_COL = 2;
    static final int V0_COMPOSITE_CAT_COL = 3;
    static final int V0_COMPOSITE_LENGTH_COL = 4;
    static final int V0_COMPOSITE_NUM_COMPONENTS_COL = 5;
    static final Schema V0_COMPOSITE_SCHEMA = new Schema(0, "Data Type ID", new Field[]{StringField.INSTANCE, StringField.INSTANCE, BooleanField.INSTANCE, LongField.INSTANCE, IntField.INSTANCE, IntField.INSTANCE}, new String[]{"Name", "Comment", "Is Union", "Category ID", "Length", "Number Of Components"});
    private Table compositeTable;

    public CompositeDBAdapterV0(DBHandle handle) throws VersionException {
        this.compositeTable = handle.getTable("Composite Data Types");
        if (this.compositeTable == null) {
            throw new VersionException("Missing Table: Composite Data Types");
        }
        int version = this.compositeTable.getSchema().getVersion();
        if (version != 0) {
            String msg = "Expected version 0 for table Composite Data Types but got " + this.compositeTable.getSchema().getVersion();
            if (version < 0) {
                throw new VersionException(msg, 1, true);
            }
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    int getVersion() {
        return this.compositeTable.getSchema().getVersion();
    }

    @Override
    int getRecordCount() {
        return this.compositeTable.getRecordCount();
    }

    @Override
    public DBRecord createRecord(String name, String comments, boolean isUnion, long categoryID, int length, int computedAlignment, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime, int packValue, int minAlignment) throws IOException {
        throw new UnsupportedOperationException("Not allowed to update prior version #0 of Composite Data Types table.");
    }

    @Override
    public DBRecord getRecord(long dataTypeID) throws IOException {
        return this.translateRecord(this.compositeTable.getRecord(dataTypeID));
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Composite Data Types");
    }

    @Override
    public void updateRecord(DBRecord record, boolean setLastChangeTime) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeRecord(long compositeID) throws IOException {
        throw new UnsupportedOperationException("Not allowed to update prior version #0 of Composite Data Types table.");
    }

    @Override
    public Field[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(categoryID), 3);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return new TranslatedRecordIterator(this.compositeTable.iterator(), (RecordTranslator)this);
    }

    @Override
    Field[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return Field.EMPTY_ARRAY;
    }

    public DBRecord translateRecord(DBRecord oldRec) {
        if (oldRec == null) {
            return null;
        }
        DBRecord rec = CompositeDBAdapter.COMPOSITE_SCHEMA.createRecord(oldRec.getKey());
        rec.setString(0, oldRec.getString(0));
        rec.setString(1, oldRec.getString(1));
        rec.setBooleanValue(2, oldRec.getBooleanValue(2));
        rec.setLongValue(3, oldRec.getLongValue(3));
        rec.setIntValue(4, oldRec.getIntValue(4));
        rec.setIntValue(6, oldRec.getIntValue(5));
        rec.setLongValue(7, 0L);
        rec.setLongValue(8, UniversalIdGenerator.nextID().getValue());
        rec.setLongValue(9, 0L);
        rec.setLongValue(10, 0L);
        rec.setIntValue(11, -1);
        rec.setIntValue(12, 0);
        return rec;
    }

    @Override
    DBRecord getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        return null;
    }
}

