/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BinaryField;
import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.SettingsDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class SettingsDBAdapterV0
extends SettingsDBAdapter {
    static final int V0_SETTINGS_DT_ID_COL = 0;
    static final int V0_SETTINGS_NAME_COL = 1;
    static final int V0_SETTINGS_LONG_VALUE_COL = 2;
    static final int V0_SETTINGS_STRING_VALUE_COL = 3;
    static final int V0_SETTINGS_BYTE_VALUE_COL = 4;
    static final Schema V0_SETTINGS_SCHEMA = new Schema(0, "DT Settings ID", new Field[]{LongField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, StringField.INSTANCE, BinaryField.INSTANCE}, new String[]{"Data Type ID", "Settings Name", "Long Value", "String Value", "Byte Value"});
    private Table settingsTable;

    SettingsDBAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.settingsTable = handle.createTable("Default Settings", V0_SETTINGS_SCHEMA, new int[]{0});
        } else {
            this.settingsTable = handle.getTable("Default Settings");
            if (this.settingsTable == null) {
                throw new VersionException("Missing Table: Default Settings");
            }
            if (this.settingsTable.getSchema().getVersion() != 0) {
                throw new VersionException("Expected version 0 for table Default Settings but got " + this.settingsTable.getSchema().getVersion());
            }
        }
    }

    @Override
    public DBRecord createSettingsRecord(long dataTypeID, String name, String strValue, long longValue, byte[] byteValue) throws IOException {
        DBRecord record = V0_SETTINGS_SCHEMA.createRecord(this.settingsTable.getKey());
        record.setLongValue(0, dataTypeID);
        record.setString(1, name);
        record.setString(3, strValue);
        record.setLongValue(2, longValue);
        record.setBinaryData(4, byteValue);
        this.settingsTable.putRecord(record);
        return record;
    }

    @Override
    public Field[] getSettingsKeys(long dataTypeID) throws IOException {
        return this.settingsTable.findRecords((Field)new LongField(dataTypeID), 0);
    }

    @Override
    public boolean removeSettingsRecord(long settingsID) throws IOException {
        return this.settingsTable.deleteRecord(settingsID);
    }

    @Override
    public DBRecord getSettingsRecord(long settingsID) throws IOException {
        return this.settingsTable.getRecord(settingsID);
    }

    @Override
    public void updateSettingsRecord(DBRecord record) throws IOException {
        this.settingsTable.putRecord(record);
    }

    @Override
    int getRecordCount() {
        return this.settingsTable.getRecordCount();
    }
}

