/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;

abstract class AbstractImageBaseOffsetDataType
extends BuiltIn {
    AbstractImageBaseOffsetDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    abstract DataType getScalarDataType();

    static String generateName(DataType dt) {
        return "ImageBaseOffset" + dt.getLength() * 8;
    }

    static String generateMnemonic(DataType dt) {
        return "ibo" + dt.getLength() * 8;
    }

    static String generateDescription(DataType dt) {
        return dt.getLength() * 8 + "-bit Image Base Offset";
    }

    @Override
    public String getDescription() {
        DataType dt = this.getScalarDataType();
        return AbstractImageBaseOffsetDataType.generateDescription(dt);
    }

    @Override
    public String getMnemonic(Settings settings) {
        DataType dt = this.getScalarDataType();
        return AbstractImageBaseOffsetDataType.generateMnemonic(dt);
    }

    @Override
    public int getLength() {
        return this.getScalarDataType().getLength();
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        Address addr = (Address)this.getValue(buf, settings, length);
        if (addr == null) {
            return "NaP";
        }
        return addr.toString();
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        DataType dt = this.getScalarDataType();
        Address imageBase = buf.getMemory().getProgram().getImageBase();
        Scalar value = (Scalar)dt.getValue(buf, settings, length);
        if (value != null && value.getUnsignedValue() != 0L) {
            try {
                return imageBase.add(value.getUnsignedValue());
            }
            catch (AddressOutOfBoundsException addressOutOfBoundsException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public boolean isEncodable() {
        return this.getScalarDataType().isEncodable();
    }

    @Override
    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        long offset;
        if (!(value instanceof Address)) {
            throw new DataTypeEncodeException("Requires Address", value, this);
        }
        Address addressValue = (Address)value;
        Address imageBase = buf.getMemory().getProgram().getImageBase();
        try {
            offset = addressValue.subtract(imageBase);
        }
        catch (IllegalArgumentException e) {
            throw new DataTypeEncodeException(value, this, e);
        }
        Scalar scalarOffset = new Scalar(imageBase.getSize(), offset, false);
        DataType dt = this.getScalarDataType();
        return dt.encodeValue(scalarOffset, buf, settings, length);
    }

    @Override
    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        Address address = buf.getMemory().getProgram().getAddressFactory().getAddress(repr);
        if (address == null) {
            throw new DataTypeEncodeException("Cannot parse address", repr, this);
        }
        return this.encodeValue(address, buf, settings, length);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return Address.class;
    }
}

