/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.Msg;
import ghidra.util.classfinder.ClassTranslator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class MacintoshTimeStampDataType
extends BuiltIn {
    private static final SimpleDateFormat formatter;
    private static Date macStartDate;

    public MacintoshTimeStampDataType() {
        this(null);
    }

    public MacintoshTimeStampDataType(DataTypeManager dtm) {
        super(null, "MacTime", dtm);
    }

    @Override
    public String getDescription() {
        return "The stamp follows the Macintosh time-measurement scheme (that is, the number of seconds measured from January 1, 1904).";
    }

    @Override
    public int getLength() {
        return 4;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "MacTime";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        if (macStartDate == null) {
            return "unparsed date";
        }
        try {
            long dateInSeconds = (long)buf.getInt(0) & 0xFFFFFFFFL;
            long dateInMilliSeconds = dateInSeconds * 1000L;
            long start = 0L - macStartDate.getTime();
            Date date = new Date(dateInMilliSeconds - start);
            return formatter.format(date);
        }
        catch (Exception exception) {
            return "";
        }
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.getRepresentation(buf, settings, length);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new MacintoshTimeStampDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.program.model.data.MacintoshTimeStamp", (String)MacintoshTimeStampDataType.class.getName());
        formatter = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        try {
            formatter.setTimeZone(TimeZone.getTimeZone("GMT"));
            macStartDate = formatter.parse("01-Jan-1904 00:00:00");
        }
        catch (Exception e) {
            Msg.error(MacintoshTimeStampDataType.class, (Object)("Unexpected Exception: " + e.getMessage()), (Throwable)e);
        }
    }
}

