/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public interface ReferenceManager {
    public static final int MNEMONIC = -1;

    public Reference addReference(Reference var1);

    public Reference addStackReference(Address var1, int var2, int var3, RefType var4, SourceType var5);

    public Reference addRegisterReference(Address var1, int var2, Register var3, RefType var4, SourceType var5);

    public Reference addMemoryReference(Address var1, Address var2, RefType var3, SourceType var4, int var5);

    public Reference addOffsetMemReference(Address var1, Address var2, long var3, RefType var5, SourceType var6, int var7);

    public Reference addShiftedMemReference(Address var1, Address var2, int var3, RefType var4, SourceType var5, int var6);

    public Reference addExternalReference(Address var1, String var2, String var3, Address var4, SourceType var5, int var6, RefType var7) throws InvalidInputException, DuplicateNameException;

    public Reference addExternalReference(Address var1, Namespace var2, String var3, Address var4, SourceType var5, int var6, RefType var7) throws InvalidInputException, DuplicateNameException;

    public Reference addExternalReference(Address var1, int var2, ExternalLocation var3, SourceType var4, RefType var5) throws InvalidInputException;

    public void removeAllReferencesFrom(Address var1, Address var2);

    public void removeAllReferencesFrom(Address var1);

    public void removeAllReferencesTo(Address var1);

    public Reference[] getReferencesTo(Variable var1);

    public Variable getReferencedVariable(Reference var1);

    public void setPrimary(Reference var1, boolean var2);

    public boolean hasFlowReferencesFrom(Address var1);

    public Reference[] getFlowReferencesFrom(Address var1);

    public ReferenceIterator getExternalReferences();

    public ReferenceIterator getReferencesTo(Address var1);

    public ReferenceIterator getReferenceIterator(Address var1);

    public Reference getReference(Address var1, Address var2, int var3);

    public Reference[] getReferencesFrom(Address var1);

    public Reference[] getReferencesFrom(Address var1, int var2);

    public boolean hasReferencesFrom(Address var1, int var2);

    public boolean hasReferencesFrom(Address var1);

    public Reference getPrimaryReferenceFrom(Address var1, int var2);

    public AddressIterator getReferenceSourceIterator(Address var1, boolean var2);

    public AddressIterator getReferenceSourceIterator(AddressSetView var1, boolean var2);

    public AddressIterator getReferenceDestinationIterator(Address var1, boolean var2);

    public AddressIterator getReferenceDestinationIterator(AddressSetView var1, boolean var2);

    public int getReferenceCountTo(Address var1);

    public int getReferenceCountFrom(Address var1);

    public int getReferenceDestinationCount();

    public int getReferenceSourceCount();

    public boolean hasReferencesTo(Address var1);

    public Reference updateRefType(Reference var1, RefType var2);

    public void setAssociation(Symbol var1, Reference var2);

    public void removeAssociation(Reference var1);

    public void delete(Reference var1);

    public byte getReferenceLevel(Address var1);
}

