/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.dbg.attributes.TargetStringList;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressSpace;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.stream.Collectors;

public enum ConversionUtils {


    public static byte[] bigIntegerToBytes(int length, BigInteger value) {
        byte[] bytes = value.toByteArray();
        if (length == bytes.length) {
            return bytes;
        }
        byte[] result = new byte[length];
        if (value.signum() < 0) {
            Arrays.fill(result, (byte)-1);
        }
        if (length < bytes.length) {
            System.arraycopy(bytes, bytes.length - length, result, 0, length);
        } else {
            System.arraycopy(bytes, 0, result, length - bytes.length, bytes.length);
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public static TargetStringList addressFactoryToSpaceNameSet(AddressFactory factory) {
        return Arrays.asList(factory.getAddressSpaces()).stream().map(AddressSpace::getName).collect(Collectors.toCollection(TargetStringList.MutableTargetStringList::new));
    }
}

