/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import ghidra.graph.job.AbstractAnimator;
import ghidra.graph.job.GraphJob;
import ghidra.graph.job.GraphJobListener;
import ghidra.util.Msg;
import ghidra.util.task.BusyListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.TimingTargetAdapter;

public abstract class AbstractAnimatorJob
implements GraphJob {
    public static final int TOO_BIG_TO_ANIMATE = 125;
    protected Logger log = LogManager.getLogger(AbstractAnimator.class);
    private boolean isFinished;
    private BusyListener busyListener;
    protected Animator animator;
    protected boolean isShortcut;
    private GraphJobListener finishedListener;

    protected abstract Animator createAnimator();

    protected abstract void finished();

    public void setBusyListener(BusyListener listener) {
        this.busyListener = listener;
    }

    @Override
    public boolean canShortcut() {
        return true;
    }

    @Override
    public void shortcut() {
        this.trace("shortcut(): " + this);
        this.isShortcut = true;
        this.stop();
    }

    @Override
    public void execute(GraphJobListener listener) {
        this.finishedListener = listener;
        this.start();
    }

    @Override
    public boolean isFinished() {
        return this.isFinished;
    }

    @Override
    public void dispose() {
        this.trace("dispose(): " + this);
        this.stop();
    }

    protected void trace(String message) {
        this.log.trace(message + " " + this.getClass().getSimpleName() + " (" + System.identityHashCode(this) + ")\t");
    }

    void start() {
        this.trace("start() - " + this.getClass().getSimpleName());
        try {
            this.animator = this.createAnimator();
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)"Unexepected exception creating animator", (Throwable)t);
            this.emergencyFinish();
            return;
        }
        this.trace("\tcreated animator - " + this.animator);
        if (this.animator == null) {
            this.callFinish();
            return;
        }
        if (this.busyListener != null) {
            this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

                public void begin() {
                    AbstractAnimatorJob.this.busyListener.setBusy(true);
                }
            });
        }
        this.animator.addTarget((TimingTarget)new TimingTargetAdapter(){

            public void end() {
                AbstractAnimatorJob.this.callFinish();
            }
        });
        this.animator.start();
    }

    private void callFinish() {
        this.trace("callFinish()");
        if (this.isFinished) {
            this.trace("\talready finished");
            return;
        }
        try {
            this.finished();
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)"Unexpected error in AbstractAnimator: ", (Throwable)t);
        }
        this.isFinished = true;
        this.trace("\tmaybe notify finished...");
        if (this.finishedListener != null) {
            this.trace("\tlistener is not null--calling");
            this.finishedListener.jobFinished(this);
        }
        if (this.busyListener != null) {
            this.busyListener.setBusy(false);
        }
    }

    private void emergencyFinish() {
        this.trace("emergencyFinish()");
        if (this.isFinished) {
            this.trace("\talready finished");
            return;
        }
        this.isFinished = true;
        this.trace("\tmaybe notify finished...");
        if (this.finishedListener != null) {
            this.trace("\tlistener is not null--calling");
            this.finishedListener.jobFinished(this);
        }
        if (this.busyListener != null) {
            this.busyListener.setBusy(false);
        }
    }

    protected void stop() {
        this.trace("stop()");
        if (this.animator == null) {
            this.callFinish();
            return;
        }
        this.animator.stop();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

