/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.export;

import ghidra.app.util.DomainObjectService;
import ghidra.app.util.Option;
import ghidra.app.util.OptionException;
import ghidra.app.util.exporter.XmlExporter;
import ghidra.framework.model.DomainObject;
import ghidra.trace.model.Trace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class TraceViewXmlExporter
extends XmlExporter {
    private final Map<String, Object> hideOpts = Map.of("Properties", false, "Relocation Table", false, "External Libraries", false);

    public boolean canExportDomainObject(Class<? extends DomainObject> domainObjectClass) {
        return Trace.class.isAssignableFrom(domainObjectClass);
    }

    public List<Option> getOptions(DomainObjectService domainObjectService) {
        List options = super.getOptions(domainObjectService);
        return options.stream().filter(o -> !this.hideOpts.keySet().contains(o.getName())).collect(Collectors.toList());
    }

    public void setOptions(List<Option> options) throws OptionException {
        ArrayList<Option> opts = new ArrayList<Option>(options);
        options.stream().filter(o -> !this.hideOpts.keySet().contains(o.getName())).forEach(opts::add);
        for (Map.Entry<String, Object> ent : this.hideOpts.entrySet()) {
            opts.add(new Option(ent.getKey(), ent.getValue()));
        }
        super.setOptions(opts);
    }
}

