/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.builder.ActionBuilder;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.DebuggerGoToDialog;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.pcode.exec.AsyncPcodeExecutor;
import ghidra.pcode.exec.SleighExpression;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.TracePcodeUtils;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.program.TraceProgramView;
import java.util.concurrent.CompletableFuture;

public abstract class DebuggerGoToTrait {
    protected DockingAction action;
    protected final PluginTool tool;
    protected final Plugin plugin;
    protected final ComponentProvider provider;
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected final DebuggerGoToDialog goToDialog;

    public DebuggerGoToTrait(PluginTool tool, Plugin plugin, ComponentProvider provider) {
        this.tool = tool;
        this.plugin = plugin;
        this.provider = provider;
        this.goToDialog = new DebuggerGoToDialog(this);
    }

    protected abstract boolean goToAddress(Address var1);

    public void goToCoordinates(DebuggerCoordinates coordinates) {
        this.current = coordinates;
    }

    public DockingAction installAction() {
        this.action = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.GoToAction.builder(this.plugin).enabledWhen(ctx -> this.current.getView() != null)).onAction(this::activatedGoTo)).buildAndInstallLocal(this.provider);
        this.action.setEnabled(false);
        return this.action;
    }

    private void activatedGoTo(ActionContext context) {
        TraceProgramView view = this.current.getView();
        if (view == null) {
            return;
        }
        Language language = view.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            return;
        }
        this.goToDialog.show((SleighLanguage)language);
    }

    public CompletableFuture<Boolean> goToSleigh(String spaceName, String expression) {
        Language language = this.current.getView().getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalStateException("Current trace does not use Sleigh");
        }
        SleighLanguage slang = (SleighLanguage)language;
        AddressSpace space = language.getAddressFactory().getAddressSpace(spaceName);
        if (space == null) {
            throw new IllegalArgumentException("No such address space: " + spaceName);
        }
        SleighExpression expr = SleighProgramCompiler.compileExpression((SleighLanguage)slang, (String)expression);
        return this.goToSleigh(space, expr);
    }

    public CompletableFuture<Boolean> goToSleigh(AddressSpace space, SleighExpression expression) {
        AsyncPcodeExecutor<byte[]> executor = TracePcodeUtils.executorForCoordinates(this.current);
        CompletableFuture result = (CompletableFuture)expression.evaluate(executor);
        return result.thenApply(offset -> {
            Address address = space.getAddress(Utils.bytesToLong((byte[])offset, (int)((byte[])offset).length, (boolean)expression.getLanguage().isBigEndian()));
            return this.goToAddress(address);
        });
    }
}

