/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.app.services.TraceRecorder;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.util.task.TaskMonitor;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public class VisibleROOnceAutoReadMemorySpec
implements AutoReadMemorySpec {
    public static final String CONFIG_NAME = "READ_VIS_RO_ONCE";

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Read Visible Memory, RO Once";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.AutoReadMemoryAction.ICON_VIS_RO_ONCE;
    }

    @Override
    public CompletableFuture<?> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
        TraceMemoryManager mm;
        AddressSetView alreadyKnown;
        if (!coordinates.isAliveAndReadsPresent()) {
            return AsyncUtils.NIL;
        }
        TraceRecorder recorder = coordinates.getRecorder();
        AddressSet visibleAccessible = recorder.getAccessibleProcessMemory().intersect(visible);
        AddressSet toRead = visibleAccessible.subtract(alreadyKnown = (mm = coordinates.getTrace().getMemoryManager()).getAddressesWithState(coordinates.getSnap().longValue(), (AddressSetView)visibleAccessible, s -> s == TraceMemoryState.KNOWN));
        if (toRead.isEmpty()) {
            return AsyncUtils.NIL;
        }
        AddressSet everKnown = new AddressSet();
        for (AddressRange range : visible) {
            for (Map.Entry ent : mm.getMostRecentStates(coordinates.getSnap().longValue(), range)) {
                everKnown.add(((TraceAddressSnapRange)ent.getKey()).getRange());
            }
        }
        AddressSet readOnly = new AddressSet();
        for (AddressRange range : visible) {
            for (TraceMemoryRegion region : mm.getRegionsIntersecting(Range.singleton((Comparable)coordinates.getSnap()), range)) {
                if (region.isWrite()) continue;
                readOnly.add(region.getRange());
            }
        }
        toRead.delete((AddressSetView)everKnown.intersect((AddressSetView)readOnly));
        if (toRead.isEmpty()) {
            return AsyncUtils.NIL;
        }
        return recorder.captureProcessMemory((AddressSetView)toRead, TaskMonitor.DUMMY, false);
    }
}

