/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import com.google.common.collect.Range;
import ghidra.program.model.address.Address;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceStaticMapping;
import java.math.BigInteger;
import java.net.URL;

public class StaticMappingRow {
    private static final BigInteger BIT64 = BigInteger.ONE.shiftLeft(64);
    private final TraceStaticMapping mapping;

    public StaticMappingRow(TraceStaticMapping mapping) {
        this.mapping = mapping;
    }

    public TraceStaticMapping getMapping() {
        return this.mapping;
    }

    public Trace getTrace() {
        return this.mapping.getTrace();
    }

    public Address getTraceAddress() {
        return this.mapping.getMinTraceAddress();
    }

    public URL getStaticProgramURL() {
        return this.mapping.getStaticProgramURL();
    }

    public String getStaticAddress() {
        return this.mapping.getStaticAddress();
    }

    public long getLength() {
        return this.mapping.getLength();
    }

    public BigInteger getBigLength() {
        long length = this.mapping.getLength();
        if (length == 0L) {
            return BIT64;
        }
        if (length < 0L) {
            return BigInteger.valueOf(length).add(BIT64);
        }
        return BigInteger.valueOf(length);
    }

    public long getShift() {
        return this.mapping.getShift();
    }

    public Range<Long> getLifespan() {
        return this.mapping.getLifespan();
    }
}

