/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import com.google.common.collect.Range;
import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedMemoryRecorder;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.async.loop.AsyncLoopHandlerForSecond;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetMemoryRegion;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeChunker;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.UsrException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;

public class DefaultMemoryRecorder
implements ManagedMemoryRecorder {
    private static final int BLOCK_SIZE = 4096;
    private static final long BLOCK_MASK = -4096L;
    private final DefaultTraceRecorder recorder;
    private final Trace trace;
    private final TraceMemoryManager memoryManager;

    protected static AddressSetView expandToBlocks(AddressSetView asv) {
        AddressSet result = new AddressSet();
        for (AddressRange range : asv) {
            AddressSpace space = range.getAddressSpace();
            Address min = space.getAddress(range.getMinAddress().getOffset() & 0xFFFFFFFFFFFFF000L);
            Address max = space.getAddress(range.getMaxAddress().getOffset() | 0xFFFL);
            result.add((AddressRange)new AddressRangeImpl(min, max));
        }
        return result;
    }

    public DefaultMemoryRecorder(DefaultTraceRecorder recorder) {
        this.recorder = recorder;
        this.trace = recorder.getTrace();
        this.memoryManager = this.trace.getMemoryManager();
    }

    public CompletableFuture<NavigableMap<Address, byte[]>> captureProcessMemory(AddressSetView set, TaskMonitor monitor, boolean toMap) {
        int total = 0;
        AddressSet expSet = DefaultMemoryRecorder.expandToBlocks(set).intersect(this.trace.getMemoryManager().getRegionsAddressSet(this.recorder.getSnap()));
        for (AddressRange r2 : expSet) {
            total = (int)((long)total + Long.divideUnsigned(r2.getLength() + 4096L - 1L, 4096L));
        }
        monitor.initialize((long)total);
        monitor.setMessage("Capturing memory");
        TreeMap result = toMap ? new TreeMap() : null;
        return AsyncUtils.each((TypeSpec)TypeSpec.VOID, (Iterator)expSet.iterator(), (r, loop) -> {
            AddressRangeChunker blocks = new AddressRangeChunker(r, 4096);
            ((CompletableFuture)AsyncUtils.each((TypeSpec)TypeSpec.VOID, (Iterator)blocks.iterator(), (vBlk, inner) -> {
                monitor.incrementProgress(1L);
                AddressRange tBlk = this.recorder.getMemoryMapper().traceToTarget((AddressRange)vBlk);
                ((CompletableFuture)((CompletableFuture)((CompletableFuture)this.recorder.getProcessMemory().readMemory(tBlk.getMinAddress(), (int)tBlk.getLength()).thenAccept(data -> {
                    if (toMap) {
                        result.put(tBlk.getMinAddress(), data);
                    }
                })).exceptionally(e -> {
                    Msg.error((Object)this, (Object)("Error reading block " + tBlk + ": " + e));
                    return null;
                })).thenApply(__ -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)inner).repeatWhile(arg_0, arg_1));
            }).thenApply(v -> !monitor.isCancelled())).handle((arg_0, arg_1) -> ((AsyncLoopHandlerForSecond)loop).repeatWhile(arg_0, arg_1));
        }).thenApply(__ -> result);
    }

    @Override
    public void offerProcessRegion(TargetMemoryRegion region) {
        TargetMemory mem = region.getMemory();
        this.recorder.getProcessMemory().addRegion(region, mem);
        String path = region.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Memory region " + path + " added", () -> {
            try {
                TraceMemoryRegion traceRegion = this.memoryManager.getLiveRegionByPath(snap, path);
                if (traceRegion != null) {
                    Msg.warn((Object)this, (Object)("Region " + path + " already recorded"));
                    return;
                }
                traceRegion = this.memoryManager.addRegion(path, Range.atLeast((Comparable)Long.valueOf(snap)), this.recorder.getMemoryMapper().targetToTrace(region.getRange()), this.getTraceFlags(region));
                traceRegion.setName(region.getDisplay());
            }
            catch (TraceOverlappedRegionException e) {
                Msg.error((Object)this, (Object)("Failed to create region due to overlap: " + e));
            }
            catch (DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Failed to create region due to duplicate: " + e));
            }
        }, path);
    }

    @Override
    public void removeProcessRegion(TargetMemoryRegion region) {
        String path = region.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Memory region " + path + " removed", () -> {
            try {
                TraceMemoryRegion traceRegion = this.memoryManager.getLiveRegionByPath(snap, path);
                if (traceRegion == null) {
                    Msg.warn((Object)this, (Object)("Could not find region " + path + " in trace to remove"));
                    return;
                }
                traceRegion.setDestructionSnap(snap - 1L);
            }
            catch (TraceOverlappedRegionException | DuplicateNameException e) {
                Msg.error((Object)this, (Object)("Failed to record region removal: " + (UsrException)e));
            }
        }, path);
    }

    @Override
    public TraceMemoryRegion getTraceMemoryRegion(TargetMemoryRegion region) {
        String path = region.getJoinedPath(".");
        return this.memoryManager.getLiveRegionByPath(this.recorder.getSnap(), path);
    }

    public Collection<TraceMemoryFlag> getTraceFlags(TargetMemoryRegion region) {
        HashSet<TraceMemoryFlag> flags = new HashSet<TraceMemoryFlag>();
        if (region.isReadable()) {
            flags.add(TraceMemoryFlag.READ);
        }
        if (region.isWritable()) {
            flags.add(TraceMemoryFlag.WRITE);
        }
        if (region.isExecutable()) {
            flags.add(TraceMemoryFlag.EXECUTE);
        }
        return flags;
    }

    public void regionChanged(TargetMemoryRegion region, String display) {
        String path = region.getJoinedPath(".");
        long snap = this.recorder.getSnap();
        this.recorder.parTx.execute("Memory region " + path + " changed display", () -> {
            TraceMemoryRegion traceRegion = this.memoryManager.getLiveRegionByPath(snap, path);
            if (traceRegion == null) {
                Msg.warn((Object)this, (Object)("Could not find region " + path + " in trace to rename"));
                return;
            }
            traceRegion.setName(display);
        }, path);
    }
}

