/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.mapping.DebuggerMemoryMapper;
import ghidra.app.plugin.core.debug.service.model.DefaultBreakpointRecorder;
import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.RecorderSimpleMemory;
import ghidra.app.plugin.core.debug.service.model.interfaces.AbstractRecorderMemory;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedBreakpointRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedProcessRecorder;
import ghidra.app.services.TraceRecorderListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Trace;
import ghidra.util.TriConsumer;
import java.util.concurrent.CompletableFuture;

public class DefaultProcessRecorder
implements ManagedProcessRecorder {
    private final AbstractRecorderMemory processMemory;
    protected final TriConsumer<Boolean, Boolean, Void> listenerProcMemAccChanged = this::processMemoryAccessibilityChanged;
    private DefaultBreakpointRecorder breakpointRecorder;
    private DefaultTraceRecorder recorder;

    public DefaultProcessRecorder(DefaultTraceRecorder recorder) {
        this.recorder = recorder;
        this.processMemory = new RecorderSimpleMemory();
        this.breakpointRecorder = new DefaultBreakpointRecorder(recorder);
    }

    protected void processMemoryAccessibilityChanged(boolean old, boolean acc, Void __) {
        ((TraceRecorderListener)this.recorder.getListeners().fire).processMemoryAccessibilityChanged(this.recorder);
    }

    public CompletableFuture<byte[]> readProcessMemory(Address start, int length) {
        Address tStart = this.recorder.getMemoryMapper().traceToTarget(start);
        return this.getProcessMemory().readMemory(tStart, length);
    }

    public CompletableFuture<Void> writeProcessMemory(Address start, byte[] data) {
        Address tStart = this.recorder.getMemoryMapper().traceToTarget(start);
        return this.getProcessMemory().writeMemory(tStart, data);
    }

    public AddressSetView getAccessibleProcessMemory() {
        return this.getProcessMemory().getAccessibleMemory(mem -> true, this.recorder.getMemoryMapper());
    }

    @Override
    public AbstractRecorderMemory getProcessMemory() {
        return this.processMemory;
    }

    @Override
    public ManagedBreakpointRecorder getBreakpointRecorder() {
        return this.breakpointRecorder;
    }

    @Override
    public Trace getTrace() {
        return this.recorder.trace;
    }

    @Override
    public long getSnap() {
        return this.recorder.getSnap();
    }

    @Override
    public DebuggerMemoryMapper getMemoryMapper() {
        return this.recorder.getMemoryMapper();
    }
}

