/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.service.model;

import ghidra.app.plugin.core.debug.service.model.DefaultTraceRecorder;
import ghidra.app.plugin.core.debug.service.model.RecorderThreadMap;
import ghidra.app.plugin.core.debug.service.model.TraceObjectManager;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedStackRecorder;
import ghidra.app.plugin.core.debug.service.model.interfaces.ManagedThreadRecorder;
import ghidra.async.AsyncUtils;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.error.DebuggerMemoryAccessException;
import ghidra.dbg.target.TargetEventScope;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetMemory;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetRegisterBank;
import ghidra.dbg.target.TargetStack;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.DebuggerCallbackReorderer;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.modules.TraceModule;
import ghidra.util.Msg;
import ghidra.util.TimedMsg;
import ghidra.util.datastruct.PrivatelyQueuedListener;
import ghidra.util.exception.DuplicateNameException;
import java.lang.invoke.MethodHandles;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class TraceEventListener
extends AnnotatedDebuggerAttributeListener {
    private final DefaultTraceRecorder recorder;
    private final TargetObject target;
    private final Trace trace;
    private final TraceMemoryManager memoryManager;
    private boolean valid = true;
    protected final DebuggerCallbackReorderer reorderer = new DebuggerCallbackReorderer((DebuggerModelListener)this);
    protected final PrivatelyQueuedListener<DebuggerModelListener> queue;
    private boolean ignoreInvalidation = false;

    public TraceEventListener(TraceObjectManager collection) {
        super(MethodHandles.lookup());
        this.recorder = collection.getRecorder();
        this.queue = new PrivatelyQueuedListener(DebuggerModelListener.class, this.recorder.privateQueue, (Object)this.reorderer);
        this.target = this.recorder.getTarget();
        this.trace = this.recorder.getTrace();
        this.memoryManager = this.trace.getMemoryManager();
    }

    public CompletableFuture<Void> init() {
        DebuggerObjectModel model = this.target.getModel();
        model.addModelListener((DebuggerModelListener)this.queue.in, true);
        return AsyncUtils.NIL;
    }

    private boolean successor(TargetObject ref) {
        return PathUtils.isAncestor((List)this.target.getPath(), (List)ref.getPath());
    }

    private boolean anyRef(Collection<Object> parameters) {
        for (Object p : parameters) {
            if (!(p instanceof TargetObject)) continue;
            return true;
        }
        return false;
    }

    private boolean anySuccessor(Collection<Object> parameters) {
        for (Object p : parameters) {
            TargetObject ref;
            if (!(p instanceof TargetObject) || !this.successor(ref = (TargetObject)p)) continue;
            return true;
        }
        return false;
    }

    private boolean eventApplies(TargetObject eventThread, TargetEventScope.TargetEventType type, List<Object> parameters) {
        if (eventThread != null) {
            return this.successor(eventThread);
        }
        if (this.anyRef(parameters)) {
            return this.anySuccessor(parameters);
        }
        return true;
    }

    public void event(TargetObject object, TargetThread eventThread, TargetEventScope.TargetEventType type, String description, List<Object> parameters) {
        if (!this.valid) {
            return;
        }
        TimedMsg.debug((Object)((Object)this), (String)("Event: " + type + " thread=" + eventThread + " description=" + description + " params=" + parameters));
        if (eventThread == null) {
            if (!type.equals((Object)TargetEventScope.TargetEventType.PROCESS_CREATED)) {
                Msg.error((Object)((Object)this), (Object)("Null eventThread for " + type));
            }
            return;
        }
        if (!this.eventApplies((TargetObject)eventThread, type, parameters)) {
            return;
        }
        if (type == TargetEventScope.TargetEventType.RUNNING) {
            this.ignoreInvalidation = true;
            return;
        }
        ManagedThreadRecorder rec = this.recorder.getThreadRecorder(eventThread);
        this.recorder.createSnapshot(description, rec == null ? null : rec.getTraceThread(), null);
        this.ignoreInvalidation = false;
        if (type == TargetEventScope.TargetEventType.MODULE_LOADED) {
            long snap = this.recorder.getSnap();
            Object p0 = parameters.get(0);
            if (!(p0 instanceof TargetModule)) {
                return;
            }
            TargetModule mod = (TargetModule)p0;
            String modPath = mod.getJoinedPath(".");
            this.recorder.parTx.execute("Adjust module load: " + modPath, () -> {
                TraceModule traceModule = this.recorder.getTraceModule(mod);
                if (traceModule == null) {
                    return;
                }
                try {
                    traceModule.setLoadedSnap(snap);
                }
                catch (DuplicateNameException e) {
                    Msg.error((Object)((Object)this), (Object)"Could not set module loaded snap", (Throwable)e);
                }
            }, modPath);
        }
    }

    @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_state")
    public void executionStateChanged(TargetObject stateful, TargetExecutionStateful.TargetExecutionState state) {
        if (!this.valid) {
            return;
        }
        TimedMsg.debug((Object)((Object)this), (String)("State " + state + " for " + stateful));
        TargetObject x = this.recorder.objectManager.findThreadOrProcess(stateful);
        if (x != null) {
            if (x == this.target && state == TargetExecutionStateful.TargetExecutionState.TERMINATED) {
                this.recorder.stopRecording();
                return;
            }
            ManagedThreadRecorder rec = null;
            if (x instanceof TargetThread) {
                rec = this.recorder.getThreadRecorder((TargetThread)x);
            }
            if (rec != null) {
                rec.stateChanged(state);
            }
        }
    }

    public void invalidateCacheRequested(TargetObject object) {
        ManagedThreadRecorder rec;
        if (!this.valid) {
            return;
        }
        if (this.ignoreInvalidation) {
            return;
        }
        if (object instanceof TargetRegisterBank && (rec = this.recorder.getThreadRecorderForSuccessor(object)) != null) {
            rec.invalidateRegisterValues((TargetRegisterBank)object);
        }
        if (object instanceof TargetMemory) {
            long snap = this.recorder.getSnap();
            String path = object.getJoinedPath(".");
            this.recorder.parTx.execute("Memory invalidated: " + path, () -> {
                AddressSet set = this.trace.getBaseLanguage().getAddressFactory().getAddressSet();
                this.memoryManager.setState(snap, (AddressSetView)set, TraceMemoryState.UNKNOWN);
            }, path);
        }
    }

    public void registersUpdated(TargetObject bank, Map<String, byte[]> updates) {
        if (!this.valid) {
            return;
        }
        ManagedThreadRecorder rec = this.recorder.getThreadRecorderForSuccessor(bank);
        if (rec != null) {
            rec.recordRegisterValues((TargetRegisterBank)bank, updates);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void memoryUpdated(TargetObject memory, Address address, byte[] data) {
        if (!this.valid) {
            return;
        }
        DefaultTraceRecorder defaultTraceRecorder = this.recorder;
        synchronized (defaultTraceRecorder) {
            if (this.recorder.getMemoryMapper() == null) {
                Msg.warn((Object)((Object)this), (Object)"Received memory write before a region has been added");
                return;
            }
        }
        Address traceAddr = this.recorder.getMemoryMapper().targetToTrace(address);
        long snap = this.recorder.getSnap();
        TimedMsg.debug((Object)((Object)this), (String)("Memory updated: " + address + " (" + data.length + ")"));
        String path = memory.getJoinedPath(".");
        this.recorder.parTx.execute("Memory observed: " + path, () -> this.memoryManager.putBytes(snap, traceAddr, ByteBuffer.wrap(data)), path);
    }

    public void memoryReadError(TargetObject memory, AddressRange range, DebuggerMemoryAccessException e) {
        if (!this.valid) {
            return;
        }
        Msg.error((Object)((Object)this), (Object)("Error reading range " + range), (Throwable)e);
        Address traceMin = this.recorder.getMemoryMapper().targetToTrace(range.getMinAddress());
        long snap = this.recorder.getSnap();
        String path = memory.getJoinedPath(".");
        this.recorder.parTx.execute("Memory read error: " + path, () -> this.memoryManager.setState(snap, traceMin, TraceMemoryState.ERROR), path);
    }

    protected void stackUpdated(TargetStack stack) {
        ManagedStackRecorder rec = this.recorder.getThreadRecorderForSuccessor((TargetObject)stack).getStackRecorder();
        rec.recordStack();
    }

    @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_focus")
    public void focusChanged(TargetObject scope, TargetObject focused) {
        if (!this.valid) {
            return;
        }
        if (PathUtils.isAncestor((List)this.target.getPath(), (List)focused.getPath())) {
            this.recorder.setCurrentFocus(focused);
        }
    }

    public RecorderThreadMap getThreadMap() {
        return this.recorder.getThreadMap();
    }

    public void dispose() {
        this.target.getModel().removeModelListener((DebuggerModelListener)this.reorderer);
        this.reorderer.dispose();
    }
}

