/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.utils;

import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Trace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.program.TraceVariableSnapProgramView;

public enum ProgramLocationUtils {


    public static ProgramLocation replaceAddress(ProgramLocation loc, Program program, Address address) {
        if (loc instanceof BytesFieldLocation) {
            return new BytesFieldLocation(program, address);
        }
        return new ProgramLocation(program, address);
    }

    public static ProgramLocation fixLocation(ProgramLocation loc, boolean matchSnap) {
        Program program = loc.getProgram();
        if (!(program instanceof TraceProgramView)) {
            return loc;
        }
        TraceProgramView itsView = (TraceProgramView)program;
        Trace trace = itsView.getTrace();
        TraceVariableSnapProgramView canonicalView = trace.getProgramView();
        if (canonicalView == itsView || matchSnap && canonicalView.getSnap() != itsView.getSnap()) {
            return loc;
        }
        return ProgramLocationUtils.replaceProgram(loc, (Program)canonicalView);
    }

    public static ProgramLocation replaceProgram(ProgramLocation loc, Program program) {
        SaveState state = new SaveState("LOC");
        loc.saveState(state);
        return ProgramLocation.getLocation((Program)program, (SaveState)state);
    }
}

