/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec;

import ghidra.app.plugin.core.debug.DebuggerCoordinates;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.AsyncPcodeExecutor;
import ghidra.pcode.exec.AsyncWrappedPcodeArithmetic;
import ghidra.pcode.exec.AsyncWrappedPcodeExecutorState;
import ghidra.pcode.exec.TraceRecorderAsyncPcodeExecutorState;
import ghidra.pcode.exec.trace.TraceBytesPcodeExecutorState;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;

public enum TracePcodeUtils {


    public static AsyncPcodeExecutor<byte[]> executorForCoordinates(DebuggerCoordinates coordinates) {
        Trace trace = coordinates.getTrace();
        if (trace == null) {
            throw new IllegalArgumentException("Coordinates have no trace");
        }
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Given trace does not use a Sleigh language");
        }
        SleighLanguage slang = (SleighLanguage)language;
        AsyncWrappedPcodeExecutorState state = coordinates.getRecorder() == null ? new AsyncWrappedPcodeExecutorState(new TraceBytesPcodeExecutorState(trace, coordinates.getViewSnap(), coordinates.getThread(), coordinates.getFrame().intValue())) : new TraceRecorderAsyncPcodeExecutorState(coordinates.getRecorder(), coordinates.getSnap(), coordinates.getThread(), coordinates.getFrame());
        return new AsyncPcodeExecutor<byte[]>(slang, AsyncWrappedPcodeArithmetic.forLanguage((Language)slang), state);
    }
}

