/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.byteviewer;

import ghidra.app.plugin.core.byteviewer.ProgramByteBlockSet;
import ghidra.app.plugin.core.format.ByteBlock;
import ghidra.app.plugin.core.format.ByteEditInfo;
import ghidra.framework.options.SaveState;
import ghidra.program.model.address.Address;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class ByteBlockChangeManager {
    private ProgramByteBlockSet blockSet;
    private List<ByteEditInfo> changeList;
    private static final String NUMBER_OF_CHANGES = "NumberOfByteBlockChanges";
    private static String BLOCK_NUMBER = "BlockNumber";
    private static String BLOCK_OFFSET = "BlockOffset";
    private static String OLD_VALUE = "OldValue";
    private static String NEW_VALUE = "NewValue";
    private int dummy = 4;

    ByteBlockChangeManager(ProgramByteBlockSet blockSet) {
        this.blockSet = blockSet;
        this.changeList = new ArrayList<ByteEditInfo>(3);
    }

    ByteBlockChangeManager(ProgramByteBlockSet blockSet, ByteBlockChangeManager bbcm) {
        this.blockSet = blockSet;
        this.changeList = bbcm.changeList;
    }

    void add(ByteEditInfo edit) {
        byte[] oldValue = edit.getOldValue();
        byte[] newValue = edit.getNewValue();
        Address blockAddr = edit.getBlockAddress();
        BigInteger offset = edit.getOffset();
        for (int i = 0; i < oldValue.length; ++i) {
            if (oldValue[i] == newValue[i]) continue;
            ByteEditInfo newedit = new ByteEditInfo(blockAddr, offset.add(BigInteger.valueOf(i)), oldValue, newValue);
            this.changeList.add(newedit);
        }
    }

    SaveState getUndoRedoState() {
        SaveState saveState = new SaveState();
        int changeCount = this.changeList.size();
        for (int i = 0; i < this.changeList.size(); ++i) {
            ByteEditInfo edit = this.changeList.get(i);
            int blockNumber = this.blockSet.getByteBlockNumber(edit.getBlockAddress());
            if (blockNumber < 0) continue;
            ++changeCount;
            saveState.putInt(BLOCK_NUMBER + i, blockNumber);
            saveState.putString(BLOCK_OFFSET + i, edit.getOffset().toString());
            saveState.putBytes(OLD_VALUE + i, edit.getOldValue());
            saveState.putBytes(NEW_VALUE + i, edit.getNewValue());
        }
        saveState.putInt(NUMBER_OF_CHANGES, changeCount);
        return saveState;
    }

    void restoreUndoRedoState(SaveState saveState) {
        this.changeList.clear();
        int numberOfChanges = saveState.getInt(NUMBER_OF_CHANGES, 0);
        for (int i = 0; i < numberOfChanges; ++i) {
            int blockNumber = saveState.getInt(BLOCK_NUMBER + i, 0);
            BigInteger blockOffset = new BigInteger(saveState.getString(BLOCK_OFFSET + i, "0"));
            byte[] oldValue = saveState.getBytes(OLD_VALUE + i, null);
            byte[] newValue = saveState.getBytes(NEW_VALUE + i, null);
            if (oldValue == null || newValue == null) continue;
            this.changeList.add(new ByteEditInfo(this.blockSet.getBlockStart(blockNumber), blockOffset, oldValue, newValue));
        }
    }

    boolean isChanged(ByteBlock block, BigInteger offset, int unitByteSize) {
        Address blockAddr = this.blockSet.getBlockStart(block);
        for (int i = 0; i < unitByteSize; ++i) {
            if (!this.contains(blockAddr, offset.add(BigInteger.valueOf(i)))) continue;
            return true;
        }
        return false;
    }

    private boolean contains(Address blockAddr, BigInteger offset) {
        for (int i = 0; i < this.changeList.size(); ++i) {
            ByteEditInfo edit = this.changeList.get(i);
            if (edit.getBlockAddress().compareTo((Object)blockAddr) != 0 || !edit.getOffset().equals(offset)) continue;
            return true;
        }
        return false;
    }
}

