/*
 * Decompiled with CFR 0.152.
 */
package agent.dbgmodel.jna.cmd;

import agent.dbgeng.dbgeng.DebugValue;
import agent.dbgeng.manager.cmd.AbstractDbgCommand;
import agent.dbgeng.manager.cmd.DbgPendingCommand;
import agent.dbgeng.manager.impl.DbgManagerImpl;
import agent.dbgeng.manager.impl.DbgRegister;
import agent.dbgmodel.dbgmodel.main.ModelObject;
import agent.dbgmodel.gadp.impl.WrappedDbgModel;
import agent.dbgmodel.manager.DbgManager2Impl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbgGetRegisterMapCommand
extends AbstractDbgCommand<Map<String, ?>> {
    private Map<String, DbgRegister> map = new HashMap<String, DbgRegister>();
    private WrappedDbgModel access;
    private List<String> path;

    public DbgGetRegisterMapCommand(DbgManager2Impl manager, List<String> path) {
        super((DbgManagerImpl)manager);
        this.access = manager.getAccess();
        this.path = path;
    }

    public Map<String, ?> complete(DbgPendingCommand<?> pending) {
        return this.map;
    }

    public void invoke() {
        ArrayList<String> npath = new ArrayList<String>();
        npath.add("Debugger");
        npath.addAll(this.path);
        Map<String, ModelObject> attributes = this.access.getAttributes(npath);
        int i = 0;
        for (String key : attributes.keySet()) {
            ModelObject modelObject = attributes.get(key);
            DebugValue debugValue = this.access.getDebugValue(modelObject);
            if (debugValue == null) continue;
            DbgRegister register = new DbgRegister(key, i++, debugValue.getValueType().byteLength);
            this.map.put(key, register);
        }
    }
}

