/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.lldb;

import SWIG.SBEvent;
import SWIG.SBFileSpec;
import SWIG.SBModule;
import SWIG.SBProcess;
import SWIG.SBTarget;
import agent.lldb.lldb.DebugClient;
import java.util.HashMap;
import java.util.Map;

public class DebugModuleInfo {
    public SBEvent event;
    private SBProcess process;
    private long numModules;
    private Map<Integer, SBModule> modules = new HashMap<Integer, SBModule>();

    public DebugModuleInfo(SBEvent event) {
        this.event = event;
        this.numModules = SBTarget.GetNumModulesFromEvent((SBEvent)event);
        int i = 0;
        while ((long)i < this.numModules) {
            SBModule module = SBTarget.GetModuleAtIndexFromEvent((long)i, (SBEvent)event);
            this.modules.put(i, module);
            ++i;
        }
    }

    public DebugModuleInfo(SBProcess process, SBModule module) {
        this.process = process;
        this.event = null;
        this.numModules = 1L;
        this.modules.put(0, module);
    }

    public Long getNumberOfModules() {
        return this.numModules;
    }

    public SBModule getModule(int index) {
        return this.modules.get(index);
    }

    public String toString(int index) {
        SBModule module = this.modules.get(index);
        return module.toString();
    }

    public String getModuleName(int index) {
        SBModule module = this.modules.get(index);
        return DebugClient.getId(module);
    }

    public void setModuleName(int index, String moduleName) {
        SBModule module = this.modules.get(index);
        SBFileSpec filespec = module.GetFileSpec();
        filespec.SetFilename(moduleName);
    }

    public String getImageName(int index) {
        SBModule module = this.modules.get(index);
        SBFileSpec filespec = module.GetFileSpec();
        return filespec.GetDirectory() + ":" + filespec.GetFilename();
    }

    public void setImageName(int index, String dirName, String imageName) {
        SBModule module = this.modules.get(index);
        SBFileSpec filespec = module.GetFileSpec();
        filespec.SetDirectory(dirName);
        filespec.SetFilename(imageName);
    }

    public SBProcess getProcess() {
        return this.event != null ? SBProcess.GetProcessFromEvent((SBEvent)this.event) : this.process;
    }
}

