/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.manager.impl;

import SWIG.SBBreakpoint;
import SWIG.SBBreakpointLocation;
import SWIG.SBEvent;
import SWIG.SBFrame;
import SWIG.SBMemoryRegionInfo;
import SWIG.SBModule;
import SWIG.SBProcess;
import SWIG.SBSection;
import SWIG.SBSymbol;
import SWIG.SBTarget;
import SWIG.SBThread;
import SWIG.SBValue;
import SWIG.SBWatchpoint;
import SWIG.StateType;
import SWIG.StopReason;
import agent.lldb.gadp.impl.AbstractClientThreadExecutor;
import agent.lldb.gadp.impl.LldbClientThreadExecutor;
import agent.lldb.lldb.DebugBreakpointInfo;
import agent.lldb.lldb.DebugClient;
import agent.lldb.lldb.DebugClientImpl;
import agent.lldb.lldb.DebugClientReentrant;
import agent.lldb.lldb.DebugModuleInfo;
import agent.lldb.lldb.DebugProcessInfo;
import agent.lldb.lldb.DebugSessionInfo;
import agent.lldb.lldb.DebugThreadInfo;
import agent.lldb.manager.LldbCause;
import agent.lldb.manager.LldbCommand;
import agent.lldb.manager.LldbEvent;
import agent.lldb.manager.LldbEventsListener;
import agent.lldb.manager.LldbManager;
import agent.lldb.manager.LldbStateListener;
import agent.lldb.manager.breakpoint.LldbBreakpointInfo;
import agent.lldb.manager.breakpoint.LldbBreakpointType;
import agent.lldb.manager.cmd.LldbAddProcessCommand;
import agent.lldb.manager.cmd.LldbAddSessionCommand;
import agent.lldb.manager.cmd.LldbAttachCommand;
import agent.lldb.manager.cmd.LldbAttachKernelCommand;
import agent.lldb.manager.cmd.LldbCommandError;
import agent.lldb.manager.cmd.LldbConsoleExecCommand;
import agent.lldb.manager.cmd.LldbDeleteBreakpointsCommand;
import agent.lldb.manager.cmd.LldbDisableBreakpointsCommand;
import agent.lldb.manager.cmd.LldbEnableBreakpointsCommand;
import agent.lldb.manager.cmd.LldbInsertBreakpointCommand;
import agent.lldb.manager.cmd.LldbLaunchProcessCommand;
import agent.lldb.manager.cmd.LldbLaunchProcessWithOptionsCommand;
import agent.lldb.manager.cmd.LldbListAvailableProcessesCommand;
import agent.lldb.manager.cmd.LldbListBreakpointLocationsCommand;
import agent.lldb.manager.cmd.LldbListBreakpointsCommand;
import agent.lldb.manager.cmd.LldbListEnvironmentCommand;
import agent.lldb.manager.cmd.LldbListMemoryRegionsCommand;
import agent.lldb.manager.cmd.LldbListModuleSectionsCommand;
import agent.lldb.manager.cmd.LldbListModuleSymbolsCommand;
import agent.lldb.manager.cmd.LldbListModulesCommand;
import agent.lldb.manager.cmd.LldbListProcessesCommand;
import agent.lldb.manager.cmd.LldbListSessionsCommand;
import agent.lldb.manager.cmd.LldbListStackFrameRegisterBanksCommand;
import agent.lldb.manager.cmd.LldbListStackFrameRegistersCommand;
import agent.lldb.manager.cmd.LldbListStackFramesCommand;
import agent.lldb.manager.cmd.LldbListThreadsCommand;
import agent.lldb.manager.cmd.LldbOpenDumpCommand;
import agent.lldb.manager.cmd.LldbPendingCommand;
import agent.lldb.manager.cmd.LldbRemoveProcessCommand;
import agent.lldb.manager.cmd.LldbRequestActivationCommand;
import agent.lldb.manager.cmd.LldbRequestFocusCommand;
import agent.lldb.manager.cmd.LldbSetActiveProcessCommand;
import agent.lldb.manager.cmd.LldbSetActiveSessionCommand;
import agent.lldb.manager.cmd.LldbSetActiveThreadCommand;
import agent.lldb.manager.evt.AbstractLldbEvent;
import agent.lldb.manager.evt.LldbBreakpointAutoContinueChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointCommandChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointConditionChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointCreatedEvent;
import agent.lldb.manager.evt.LldbBreakpointDeletedEvent;
import agent.lldb.manager.evt.LldbBreakpointDisabledEvent;
import agent.lldb.manager.evt.LldbBreakpointEnabledEvent;
import agent.lldb.manager.evt.LldbBreakpointHitEvent;
import agent.lldb.manager.evt.LldbBreakpointIgnoreChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointInvalidatedEvent;
import agent.lldb.manager.evt.LldbBreakpointLocationsAddedEvent;
import agent.lldb.manager.evt.LldbBreakpointLocationsRemovedEvent;
import agent.lldb.manager.evt.LldbBreakpointLocationsResolvedEvent;
import agent.lldb.manager.evt.LldbBreakpointModifiedEvent;
import agent.lldb.manager.evt.LldbBreakpointThreadChangedEvent;
import agent.lldb.manager.evt.LldbBreakpointTypeChangedEvent;
import agent.lldb.manager.evt.LldbCommandDoneEvent;
import agent.lldb.manager.evt.LldbConsoleOutputEvent;
import agent.lldb.manager.evt.LldbExceptionEvent;
import agent.lldb.manager.evt.LldbInterruptEvent;
import agent.lldb.manager.evt.LldbModuleLoadedEvent;
import agent.lldb.manager.evt.LldbModuleUnloadedEvent;
import agent.lldb.manager.evt.LldbProcessCreatedEvent;
import agent.lldb.manager.evt.LldbProcessExitedEvent;
import agent.lldb.manager.evt.LldbProcessReplacedEvent;
import agent.lldb.manager.evt.LldbProcessSelectedEvent;
import agent.lldb.manager.evt.LldbProfileDataEvent;
import agent.lldb.manager.evt.LldbRunningEvent;
import agent.lldb.manager.evt.LldbSelectedFrameChangedEvent;
import agent.lldb.manager.evt.LldbSessionCreatedEvent;
import agent.lldb.manager.evt.LldbSessionExitedEvent;
import agent.lldb.manager.evt.LldbSessionReplacedEvent;
import agent.lldb.manager.evt.LldbSessionSelectedEvent;
import agent.lldb.manager.evt.LldbStateChangedEvent;
import agent.lldb.manager.evt.LldbStoppedEvent;
import agent.lldb.manager.evt.LldbStructuredDataEvent;
import agent.lldb.manager.evt.LldbSymbolsLoadedEvent;
import agent.lldb.manager.evt.LldbSystemsEvent;
import agent.lldb.manager.evt.LldbThreadCreatedEvent;
import agent.lldb.manager.evt.LldbThreadExitedEvent;
import agent.lldb.manager.evt.LldbThreadReplacedEvent;
import agent.lldb.manager.evt.LldbThreadSelectedEvent;
import agent.lldb.manager.evt.LldbWatchpointHitEvent;
import agent.lldb.manager.impl.LldbDebugOutputCallbacks;
import agent.lldb.model.iface1.LldbModelTargetActiveScope;
import agent.lldb.model.iface1.LldbModelTargetFocusScope;
import ghidra.async.AsyncReference;
import ghidra.async.AsyncUtils;
import ghidra.async.TypeSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.HandlerMap;
import ghidra.framework.OperatingSystem;
import ghidra.framework.Platform;
import ghidra.lifecycle.Internal;
import ghidra.util.Msg;
import ghidra.util.TriConsumer;
import ghidra.util.datastruct.ListenerSet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;

public class LldbManagerImpl
implements LldbManager {
    public DebugClient.DebugStatus status;
    protected AbstractClientThreadExecutor executor;
    protected DebugClientReentrant reentrantClient;
    private List<LldbPendingCommand<?>> activeCmds = new ArrayList();
    protected final Map<String, SBTarget> sessions = new LinkedHashMap<String, SBTarget>();
    protected SBTarget curSession = null;
    private final Map<String, SBTarget> unmodifiableSessions = Collections.unmodifiableMap(this.sessions);
    protected final Map<String, Map<String, SBProcess>> processes = new LinkedHashMap<String, Map<String, SBProcess>>();
    protected final Map<String, Map<String, SBThread>> threads = new LinkedHashMap<String, Map<String, SBThread>>();
    protected final Map<String, Map<String, SBModule>> modules = new LinkedHashMap<String, Map<String, SBModule>>();
    private final Map<String, Map<String, Object>> breakpoints = new LinkedHashMap<String, Map<String, Object>>();
    protected final AsyncReference<StateType, LldbCause> state = new AsyncReference(null);
    private final HandlerMap<LldbEvent<?>, Void, DebugClient.DebugStatus> handlerMap = new HandlerMap();
    private final Map<Class<?>, DebugClient.DebugStatus> statusMap = new LinkedHashMap();
    private final ListenerSet<LldbEventsListener> listenersEvent = new ListenerSet(LldbEventsListener.class);
    private SBEvent currentEvent;
    private SBTarget currentSession;
    private SBProcess currentProcess;
    private SBThread currentThread;
    private SBTarget eventSession;
    private SBProcess eventProcess;
    private SBThread eventThread;
    private volatile boolean waiting = false;
    private boolean kernelMode = false;
    private CompletableFuture<String> continuation;

    public LldbManagerImpl() {
        this.defaultHandlers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeThread(String processId, String id) {
        Map<String, Map<String, SBThread>> map = this.threads;
        synchronized (map) {
            if (this.threads.get(processId).remove(id) == null) {
                throw new IllegalArgumentException("There is no thread with id " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBThread getThread(SBProcess process, String tid) {
        Map<String, Map<String, SBThread>> map = this.threads;
        synchronized (map) {
            return this.threads.get(DebugClient.getId(process)).get(tid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThreadIfAbsent(SBProcess process, SBThread thread) {
        Map<String, Map<String, SBThread>> map = this.threads;
        synchronized (map) {
            if (!process.IsValid()) {
                return;
            }
            Map<String, SBThread> map2 = this.threads.get(DebugClient.getId(process));
            if (map2 == null) {
                map2 = new HashMap<String, SBThread>();
                this.threads.put(DebugClient.getId(process), map2);
            }
            if (thread == null) {
                return;
            }
            String id = DebugClient.getId(thread);
            SBThread pred = map2.get(id);
            if (!(map2.containsKey(id) && thread.equals(pred) || !thread.IsValid())) {
                DebugThreadInfo info = new DebugThreadInfo(thread);
                if (!map2.containsKey(id)) {
                    this.getClient().processEvent(new LldbThreadCreatedEvent(info));
                } else {
                    this.getClient().processEvent(new LldbThreadReplacedEvent(info));
                }
                map2.put(id, thread);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void removeProcess(String sessionId, String id, LldbCause cause) {
        Map<String, Map<String, SBProcess>> map = this.processes;
        synchronized (map) {
            SBProcess proc = this.processes.get(sessionId).remove(id);
            if (proc == null) {
                throw new IllegalArgumentException("There is no process with id " + id);
            }
            HashSet<String> toRemove = new HashSet<String>();
            String processId = DebugClient.getId(proc);
            for (String tid : this.threads.get(processId).keySet()) {
                SBThread thread = this.threads.get(processId).get(tid);
                String pid = DebugClient.getId(thread.GetProcess());
                if (!pid.equals(id)) continue;
                toRemove.add(tid);
            }
            for (String tid : toRemove) {
                this.removeThread(processId, tid);
            }
            ((LldbEventsListener)this.getEventListeners().fire).processRemoved(id, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBProcess getProcess(SBTarget session, String id) {
        Map<String, Map<String, SBProcess>> map = this.processes;
        synchronized (map) {
            String sessionId = DebugClient.getId(session);
            SBProcess result = this.processes.get(sessionId).get(id);
            if (result == null) {
                throw new IllegalArgumentException("There is no process with id " + id);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessIfAbsent(SBTarget session, SBProcess process) {
        Map<String, Map<String, SBProcess>> map = this.processes;
        synchronized (map) {
            if (!session.IsValid()) {
                return;
            }
            String sessionId = DebugClient.getId(session);
            Map<String, SBProcess> map2 = this.processes.get(sessionId);
            if (map2 == null) {
                map2 = new HashMap<String, SBProcess>();
                this.processes.put(sessionId, map2);
            }
            String id = DebugClient.getId(process);
            SBProcess pred = map2.get(id);
            if (!(map2.containsKey(id) && process.equals(pred) || !process.IsValid())) {
                DebugProcessInfo info = new DebugProcessInfo(process);
                if (!map2.containsKey(id)) {
                    this.getClient().processEvent(new LldbProcessCreatedEvent(info));
                } else {
                    this.getClient().processEvent(new LldbProcessReplacedEvent(info));
                }
                map2.put(id, process);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    public void removeSession(String id, LldbCause cause) {
        Map<String, SBTarget> map = this.sessions;
        synchronized (map) {
            if (this.sessions.remove(id) == null) {
                throw new IllegalArgumentException("There is no session with id " + id);
            }
            ((LldbEventsListener)this.getEventListeners().fire).sessionRemoved(id, cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBTarget getSession(String id) {
        Map<String, SBTarget> map = this.sessions;
        synchronized (map) {
            SBTarget result = this.sessions.get(id);
            if (result == null) {
                throw new IllegalArgumentException("There is no session with id " + id);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionIfAbsent(SBTarget session) {
        Map<String, SBTarget> map = this.sessions;
        synchronized (map) {
            String id = DebugClient.getId(session);
            SBTarget pred = this.sessions.get(id);
            if (!(this.sessions.containsKey(id) && session.equals(pred) || !session.IsValid())) {
                DebugSessionInfo info = new DebugSessionInfo(session);
                if (this.sessions.containsKey(id)) {
                    this.getClient().processEvent(new LldbSessionReplacedEvent(info));
                } else {
                    this.getClient().processEvent(new LldbSessionCreatedEvent(info));
                }
                this.sessions.put(id, session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModule(SBTarget session, String id) {
        Map<String, Map<String, SBModule>> map = this.modules;
        synchronized (map) {
            if (this.modules.get(DebugClient.getId(session)).remove(id) == null) {
                throw new IllegalArgumentException("There is no module with id " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SBModule getModule(SBTarget session, String id) {
        Map<String, Map<String, SBModule>> map = this.modules;
        synchronized (map) {
            return this.modules.get(DebugClient.getId(session)).get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModuleIfAbsent(SBTarget session, SBModule module) {
        Map<String, Map<String, SBModule>> map = this.modules;
        synchronized (map) {
            String id;
            if (!session.IsValid()) {
                return;
            }
            String sessionId = DebugClient.getId(session);
            Map<String, SBModule> map2 = this.modules.get(sessionId);
            if (map2 == null) {
                map2 = new HashMap<String, SBModule>();
                this.modules.put(sessionId, map2);
            }
            if (!map2.containsKey(id = DebugClient.getId(module))) {
                map2.put(id, module);
                this.getClient().processEvent(new LldbModuleLoadedEvent(new DebugModuleInfo(this.eventProcess, module)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBreakpoint(SBTarget session, String id) {
        Map<String, Map<String, Object>> map = this.breakpoints;
        synchronized (map) {
            String sessionId = DebugClient.getId(session);
            if (this.breakpoints.get(sessionId).remove(id) == null) {
                throw new IllegalArgumentException("There is no module with id " + id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getBreakpoint(SBTarget session, String id) {
        Map<String, Map<String, Object>> map = this.breakpoints;
        synchronized (map) {
            return this.getKnownBreakpoints(session).get(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBreakpointIfAbsent(SBTarget session, Object bpt) {
        Map<String, Map<String, Object>> map = this.breakpoints;
        synchronized (map) {
            String id;
            if (!session.IsValid()) {
                return;
            }
            String sessionId = DebugClient.getId(session);
            Map<String, Object> map2 = this.breakpoints.get(sessionId);
            if (map2 == null) {
                map2 = new HashMap<String, Object>();
                this.breakpoints.put(sessionId, map2);
            }
            if (!map2.containsKey(id = DebugClient.getId(bpt))) {
                map2.put(id, bpt);
                this.getClient().processEvent(new LldbBreakpointCreatedEvent(new DebugBreakpointInfo(null, bpt)));
            }
        }
    }

    @Override
    public Map<String, SBThread> getKnownThreads(SBProcess process) {
        String processId = DebugClient.getId(process);
        Map<String, SBThread> map = this.threads.get(processId);
        if (map == null) {
            map = new HashMap<String, SBThread>();
            this.threads.put(DebugClient.getId(process), map);
        }
        return map;
    }

    @Override
    public Map<String, SBProcess> getKnownProcesses(SBTarget session) {
        String sessionId = DebugClient.getId(session);
        Map<String, SBProcess> map = this.processes.get(sessionId);
        if (map == null) {
            map = new HashMap<String, SBProcess>();
            this.processes.put(sessionId, map);
        }
        return map;
    }

    @Override
    public Map<String, SBTarget> getKnownSessions() {
        return this.unmodifiableSessions;
    }

    @Override
    public Map<String, SBModule> getKnownModules(SBTarget session) {
        String sessionId = DebugClient.getId(session);
        Map<String, SBModule> map = this.modules.get(sessionId);
        if (map == null) {
            map = new HashMap<String, SBModule>();
            this.modules.put(sessionId, map);
        }
        return map;
    }

    @Override
    public Map<String, Object> getKnownBreakpoints(SBTarget session) {
        String sessionId = DebugClient.getId(session);
        Map<String, Object> map = this.breakpoints.get(sessionId);
        if (map == null) {
            map = new HashMap<String, Object>();
            this.breakpoints.put(sessionId, map);
        }
        return map;
    }

    private Object addKnownBreakpoint(SBTarget session, Object info, boolean expectExisting) {
        String bptId = DebugClient.getId(info);
        Object old = this.getKnownBreakpoints(session).put(bptId, info);
        if (expectExisting && old == null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + bptId + " is not known"));
        } else if (!expectExisting && old != null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + bptId + " is already known"));
        }
        return old;
    }

    private Object getKnownBreakpoint(SBTarget session, String id) {
        Object info = this.getKnownBreakpoints(session).get(id);
        if (info == null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + id + " is not known"));
        }
        return info;
    }

    private Object removeKnownBreakpoint(SBTarget session, String id) {
        Object del = this.getKnownBreakpoints(session).remove(id);
        if (del == null) {
            Msg.warn((Object)this, (Object)("Breakpoint " + id + " is not known"));
        }
        return del;
    }

    @Override
    public CompletableFuture<LldbBreakpointInfo> insertBreakpoint(String loc, LldbBreakpointType type) {
        return this.execute(new LldbInsertBreakpointCommand(this, loc, type));
    }

    @Override
    public CompletableFuture<LldbBreakpointInfo> insertBreakpoint(long loc, int len, LldbBreakpointType type) {
        return this.execute(new LldbInsertBreakpointCommand(this, loc, len, type));
    }

    @Override
    public CompletableFuture<Void> disableBreakpoints(String ... ids) {
        return this.execute(new LldbDisableBreakpointsCommand(this, ids));
    }

    @Override
    public CompletableFuture<Void> enableBreakpoints(String ... ids) {
        return this.execute(new LldbEnableBreakpointsCommand(this, ids));
    }

    @Override
    public CompletableFuture<Void> deleteBreakpoints(String ... ids) {
        return this.execute(new LldbDeleteBreakpointsCommand(this, ids));
    }

    @Override
    public CompletableFuture<Map<String, Object>> listBreakpoints(SBTarget session) {
        return this.execute(new LldbListBreakpointsCommand(this, session));
    }

    @Override
    public CompletableFuture<Map<String, SBBreakpointLocation>> listBreakpointLocations(SBBreakpoint spec) {
        return this.execute(new LldbListBreakpointLocationsCommand(this, spec));
    }

    @Override
    public CompletableFuture<Void> start(String[] args) {
        this.state.set(null, (Object)LldbCause.Causes.UNCLAIMED);
        boolean create = true;
        if (args.length == 0) {
            this.executor = new LldbClientThreadExecutor(() -> DebugClient.debugCreate().createClient());
        } else {
            this.executor = new LldbClientThreadExecutor(() -> DebugClient.debugCreate().createClient());
            create = false;
        }
        this.executor.setManager(this);
        AtomicReference<Boolean> creat = new AtomicReference<Boolean>(create);
        return AsyncUtils.sequence((TypeSpec)TypeSpec.VOID).then((Executor)this.executor, seq -> {
            this.doExecute((Boolean)creat.get());
            seq.exit();
        }).finish().exceptionally(exc -> {
            Msg.error((Object)this, (Object)"start failed");
            return null;
        });
    }

    protected void doExecute(Boolean create) {
        DebugClient client = this.executor.getClient();
        this.reentrantClient = client;
        this.status = client.getExecutionStatus();
        client.setOutputCallbacks(new LldbDebugOutputCallbacks(this));
    }

    @Override
    public boolean isRunning() {
        return !this.executor.isShutdown() && !this.executor.isTerminated();
    }

    @Override
    public void terminate() {
        this.executor.execute(100, client -> {
            Msg.debug((Object)this, (Object)"Disconnecting DebugClient from session");
            client.endSession(DebugClient.DebugEndSessionFlags.DEBUG_END_DISCONNECT);
        });
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws Exception {
        this.terminate();
    }

    @Override
    public <T> CompletableFuture<T> execute(LldbCommand<? extends T> cmd) {
        assert (cmd != null);
        LldbPendingCommand pcmd = new LldbPendingCommand(cmd);
        if (this.executor.isCurrentThread()) {
            try {
                this.addCommand(cmd, pcmd);
            }
            catch (Throwable exc2) {
                pcmd.completeExceptionally(exc2);
            }
        } else {
            CompletableFuture.runAsync(() -> this.addCommand(cmd, pcmd), this.executor).exceptionally(exc -> {
                pcmd.completeExceptionally((Throwable)exc);
                return null;
            });
        }
        return pcmd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void addCommand(LldbCommand<? extends T> cmd, LldbPendingCommand<T> pcmd) {
        LldbManagerImpl lldbManagerImpl = this;
        synchronized (lldbManagerImpl) {
            if (!cmd.validInState((StateType)this.state.get())) {
                throw new LldbCommandError("Command " + cmd + " is not valid while " + this.state.get());
            }
            this.activeCmds.add(pcmd);
        }
        cmd.invoke();
        this.processEvent(new LldbCommandDoneEvent(cmd));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DebugClient.DebugStatus processEvent(LldbEvent<?> evt) {
        StateType newState;
        if (this.state == null) {
            this.state.set((Object)StateType.eStateStopped, (Object)LldbCause.Causes.UNCLAIMED);
        }
        if ((newState = evt.newState()) != null && !(evt instanceof LldbCommandDoneEvent)) {
            Msg.debug((Object)this, (Object)(evt + " transitions state to " + newState));
            this.state.set((Object)newState, (Object)evt.getCause());
        }
        boolean cmdFinished = false;
        ArrayList toRemove = new ArrayList();
        for (LldbPendingCommand<?> lldbPendingCommand : this.activeCmds) {
            cmdFinished = lldbPendingCommand.handle(evt);
            if (!cmdFinished) continue;
            lldbPendingCommand.finish();
            toRemove.add(lldbPendingCommand);
        }
        for (LldbPendingCommand<Object> lldbPendingCommand : toRemove) {
            this.activeCmds.remove(lldbPendingCommand);
        }
        LldbManagerImpl lldbManagerImpl = this;
        synchronized (lldbManagerImpl) {
            DebugClient.DebugStatus ret;
            boolean bl = this.isWaiting();
            this.waiting = false;
            DebugClient.DebugStatus debugStatus = ret = evt.isStolen() ? null : (DebugClient.DebugStatus)((Object)this.handlerMap.handle(evt, null));
            if (ret == null) {
                ret = DebugClient.DebugStatus.NO_CHANGE;
            }
            this.waiting = ret.equals((Object)DebugClient.DebugStatus.NO_DEBUGGEE) ? false : bl;
            return ret;
        }
    }

    @Override
    public void addStateListener(LldbStateListener listener) {
        this.state.addChangeListener((TriConsumer)listener);
    }

    @Override
    public void removeStateListener(LldbStateListener listener) {
        this.state.removeChangeListener((TriConsumer)listener);
    }

    public ListenerSet<LldbEventsListener> getEventListeners() {
        return this.listenersEvent;
    }

    @Override
    public void addEventsListener(LldbEventsListener listener) {
        this.getEventListeners().add((Object)listener);
    }

    @Override
    public void removeEventsListener(LldbEventsListener listener) {
        this.getEventListeners().remove((Object)listener);
    }

    private void defaultHandlers() {
        this.handlerMap.put(LldbBreakpointHitEvent.class, this::processBreakpoint);
        this.handlerMap.put(LldbExceptionEvent.class, this::processException);
        this.handlerMap.put(LldbInterruptEvent.class, this::processInterrupt);
        this.handlerMap.put(LldbThreadCreatedEvent.class, this::processThreadCreated);
        this.handlerMap.put(LldbThreadReplacedEvent.class, this::processThreadReplaced);
        this.handlerMap.put(LldbThreadExitedEvent.class, this::processThreadExited);
        this.handlerMap.put(LldbThreadSelectedEvent.class, this::processThreadSelected);
        this.handlerMap.put(LldbProcessCreatedEvent.class, this::processProcessCreated);
        this.handlerMap.put(LldbProcessReplacedEvent.class, this::processProcessReplaced);
        this.handlerMap.put(LldbProcessExitedEvent.class, this::processProcessExited);
        this.handlerMap.put(LldbSessionCreatedEvent.class, this::processSessionCreated);
        this.handlerMap.put(LldbSessionReplacedEvent.class, this::processSessionReplaced);
        this.handlerMap.put(LldbSessionExitedEvent.class, this::processSessionExited);
        this.handlerMap.put(LldbProcessSelectedEvent.class, this::processProcessSelected);
        this.handlerMap.put(LldbSelectedFrameChangedEvent.class, this::processFrameSelected);
        this.handlerMap.put(LldbModuleLoadedEvent.class, this::processModuleLoaded);
        this.handlerMap.put(LldbModuleUnloadedEvent.class, this::processModuleUnloaded);
        this.handlerMap.put(LldbStateChangedEvent.class, this::processStateChanged);
        this.handlerMap.put(LldbSystemsEvent.class, this::processSystemsEvent);
        this.handlerMap.putVoid(LldbCommandDoneEvent.class, this::processDefault);
        this.handlerMap.putVoid(LldbStoppedEvent.class, this::processDefault);
        this.handlerMap.putVoid(LldbRunningEvent.class, this::processDefault);
        this.handlerMap.putVoid(LldbConsoleOutputEvent.class, this::processConsoleOutput);
        this.handlerMap.putVoid(LldbBreakpointCreatedEvent.class, this::processBreakpointCreated);
        this.handlerMap.putVoid(LldbBreakpointModifiedEvent.class, this::processBreakpointModified);
        this.handlerMap.putVoid(LldbBreakpointDeletedEvent.class, this::processBreakpointDeleted);
        this.handlerMap.putVoid(LldbBreakpointEnabledEvent.class, this::processBreakpointEnabled);
        this.handlerMap.putVoid(LldbBreakpointDisabledEvent.class, this::processBreakpointDisabled);
        this.handlerMap.putVoid(LldbBreakpointInvalidatedEvent.class, this::processBreakpointInvalidated);
        this.handlerMap.putVoid(LldbBreakpointLocationsAddedEvent.class, this::processBreakpointLocationsAdded);
        this.handlerMap.putVoid(LldbBreakpointLocationsResolvedEvent.class, this::processBreakpointLocationsResolved);
        this.handlerMap.putVoid(LldbBreakpointLocationsRemovedEvent.class, this::processBreakpointLocationsRemoved);
        this.handlerMap.putVoid(LldbBreakpointAutoContinueChangedEvent.class, this::processBreakpointAutoContinueChanged);
        this.handlerMap.putVoid(LldbBreakpointCommandChangedEvent.class, this::processBreakpointCommandChanged);
        this.handlerMap.putVoid(LldbBreakpointConditionChangedEvent.class, this::processBreakpointConditionChanged);
        this.handlerMap.putVoid(LldbBreakpointConditionChangedEvent.class, this::processBreakpointConditionChanged);
        this.handlerMap.putVoid(LldbBreakpointIgnoreChangedEvent.class, this::processBreakpointIgnoreChanged);
        this.handlerMap.putVoid(LldbBreakpointThreadChangedEvent.class, this::processBreakpointThreadChanged);
        this.handlerMap.putVoid(LldbBreakpointTypeChangedEvent.class, this::processBreakpointTypeChanged);
        this.handlerMap.putVoid(LldbProfileDataEvent.class, this::processDefault);
        this.handlerMap.putVoid(LldbStructuredDataEvent.class, this::processDefault);
        this.handlerMap.putVoid(LldbSymbolsLoadedEvent.class, this::processDefault);
        this.statusMap.put(LldbBreakpointHitEvent.class, DebugClient.DebugStatus.BREAK);
        this.statusMap.put(LldbExceptionEvent.class, DebugClient.DebugStatus.BREAK);
        this.statusMap.put(LldbProcessCreatedEvent.class, DebugClient.DebugStatus.BREAK);
        this.statusMap.put(LldbProcessExitedEvent.class, DebugClient.DebugStatus.NO_DEBUGGEE);
        this.statusMap.put(LldbStateChangedEvent.class, DebugClient.DebugStatus.NO_CHANGE);
        this.statusMap.put(LldbStoppedEvent.class, DebugClient.DebugStatus.BREAK);
        this.statusMap.put(LldbInterruptEvent.class, DebugClient.DebugStatus.BREAK);
    }

    public void updateState(SBEvent event) {
        DebugClientImpl client = (DebugClientImpl)this.executor.getClient();
        this.currentProcess = this.eventProcess = SBProcess.GetProcessFromEvent((SBEvent)event);
        SBTarget candidateSession = SBTarget.GetTargetFromEvent((SBEvent)event);
        if (candidateSession != null && candidateSession.IsValid()) {
            this.currentSession = this.eventSession = candidateSession;
        } else {
            candidateSession = this.currentProcess.GetTarget();
            if (candidateSession != null && candidateSession.IsValid()) {
                this.currentSession = this.eventSession = candidateSession;
            }
        }
        SBThread candidateThread = SBThread.GetThreadFromEvent((SBEvent)event);
        if (candidateThread != null && candidateThread.IsValid()) {
            this.currentThread = this.eventThread = candidateThread;
        } else {
            candidateThread = this.currentProcess.GetSelectedThread();
            if (candidateThread != null && candidateThread.IsValid()) {
                this.currentThread = this.eventThread = candidateThread;
            }
        }
        this.addSessionIfAbsent(this.eventSession);
        this.addProcessIfAbsent(this.eventSession, this.eventProcess);
        this.addThreadIfAbsent(this.eventProcess, this.eventThread);
        client.translateAndFireEvent(event);
    }

    @Override
    public void updateState(SBProcess process) {
        SBThread candidateThread;
        SBTarget candidateSession;
        this.currentProcess = this.eventProcess = process;
        if (!(this.currentSession != null && this.currentSession.IsValid() && this.currentSession.equals(process.GetTarget()) || (candidateSession = this.currentProcess.GetTarget()) == null || !candidateSession.IsValid())) {
            this.currentSession = this.eventSession = candidateSession;
        }
        if (!(this.currentThread != null && this.currentThread.IsValid() && this.currentThread.equals(process.GetSelectedThread()) || (candidateThread = this.currentProcess.GetSelectedThread()) == null || !candidateThread.IsValid())) {
            this.currentThread = this.eventThread = candidateThread;
        }
        this.addSessionIfAbsent(this.eventSession);
        this.addProcessIfAbsent(this.eventSession, this.eventProcess);
        this.addThreadIfAbsent(this.eventProcess, this.eventThread);
    }

    protected <T> DebugClient.DebugStatus processDefault(AbstractLldbEvent<T> evt, Void v) {
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processBreakpoint(LldbBreakpointHitEvent evt, Void v) {
        BigInteger id = this.eventThread.GetStopReasonDataAtIndex(0L);
        int i = 0;
        while ((long)i < this.currentSession.GetNumBreakpoints()) {
            SBBreakpoint bpt = this.currentSession.GetBreakpointAtIndex((long)i);
            if (bpt.IsValid() && bpt.GetID() == id.intValue()) {
                ((LldbEventsListener)this.getEventListeners().fire).breakpointHit(bpt, evt.getCause());
            }
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processException(LldbExceptionEvent evt, Void v) {
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processInterrupt(LldbInterruptEvent evt, Void v) {
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processThreadCreated(LldbThreadCreatedEvent evt, Void v) {
        SBThread thread = ((DebugThreadInfo)evt.getInfo()).thread;
        ((LldbEventsListener)this.getEventListeners().fire).threadCreated(thread, LldbCause.Causes.UNCLAIMED);
        ((LldbEventsListener)this.getEventListeners().fire).threadSelected(thread, null, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processThreadReplaced(LldbThreadReplacedEvent evt, Void v) {
        SBThread thread = ((DebugThreadInfo)evt.getInfo()).thread;
        ((LldbEventsListener)this.getEventListeners().fire).threadSelected(thread, null, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processThreadExited(LldbThreadExitedEvent evt, Void v) {
        ((LldbEventsListener)this.getEventListeners().fire).threadExited(this.eventThread, this.eventProcess, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processThreadSelected(LldbThreadSelectedEvent evt, Void v) {
        this.currentThread = evt.getThread();
        ((LldbEventsListener)this.getEventListeners().fire).threadSelected(this.currentThread, evt.getFrame(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processFrameSelected(LldbSelectedFrameChangedEvent evt, Void v) {
        this.currentThread = evt.getThread();
        ((LldbEventsListener)this.getEventListeners().fire).threadSelected(this.currentThread, evt.getFrame(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processProcessCreated(LldbProcessCreatedEvent evt, Void v) {
        DebugProcessInfo info = (DebugProcessInfo)evt.getInfo();
        SBProcess proc = info.process;
        ((LldbEventsListener)this.getEventListeners().fire).processAdded(proc, LldbCause.Causes.UNCLAIMED);
        ((LldbEventsListener)this.getEventListeners().fire).processSelected(proc, evt.getCause());
        SBThread thread = proc.GetSelectedThread();
        ((LldbEventsListener)this.getEventListeners().fire).threadSelected(thread, null, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processProcessReplaced(LldbProcessReplacedEvent evt, Void v) {
        DebugProcessInfo info = (DebugProcessInfo)evt.getInfo();
        SBProcess proc = info.process;
        ((LldbEventsListener)this.getEventListeners().fire).processReplaced(proc, LldbCause.Causes.UNCLAIMED);
        ((LldbEventsListener)this.getEventListeners().fire).processSelected(proc, evt.getCause());
        SBThread thread = proc.GetSelectedThread();
        ((LldbEventsListener)this.getEventListeners().fire).threadSelected(thread, null, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processProcessExited(LldbProcessExitedEvent evt, Void v) {
        SBThread thread = this.getCurrentThread();
        SBProcess process = this.getCurrentProcess();
        ((LldbEventsListener)this.getEventListeners().fire).threadExited(thread, process, evt.getCause());
        ((LldbEventsListener)this.getEventListeners().fire).processExited(process, evt.getCause());
        ((LldbEventsListener)this.getEventListeners().fire).processRemoved(process.GetProcessID().toString(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processProcessSelected(LldbProcessSelectedEvent evt, Void v) {
        this.currentProcess = evt.getProcess();
        ((LldbEventsListener)this.getEventListeners().fire).processSelected(this.currentProcess, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processSessionCreated(LldbSessionCreatedEvent evt, Void v) {
        DebugSessionInfo info = (DebugSessionInfo)evt.getInfo();
        ((LldbEventsListener)this.getEventListeners().fire).sessionAdded(info.session, LldbCause.Causes.UNCLAIMED);
        ((LldbEventsListener)this.getEventListeners().fire).sessionSelected(info.session, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processSessionReplaced(LldbSessionReplacedEvent evt, Void v) {
        DebugSessionInfo info = (DebugSessionInfo)evt.getInfo();
        ((LldbEventsListener)this.getEventListeners().fire).sessionReplaced(info.session, LldbCause.Causes.UNCLAIMED);
        ((LldbEventsListener)this.getEventListeners().fire).sessionSelected(info.session, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processSessionExited(LldbSessionExitedEvent evt, Void v) {
        this.removeSession(evt.sessionId, LldbCause.Causes.UNCLAIMED);
        ((LldbEventsListener)this.getEventListeners().fire).sessionRemoved(evt.sessionId, evt.getCause());
        ((LldbEventsListener)this.getEventListeners().fire).threadExited(this.eventThread, this.eventProcess, evt.getCause());
        ((LldbEventsListener)this.getEventListeners().fire).processExited(this.eventProcess, evt.getCause());
        ((LldbEventsListener)this.getEventListeners().fire).processRemoved(this.eventProcess.GetProcessID().toString(), evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processModuleLoaded(LldbModuleLoadedEvent evt, Void v) {
        DebugModuleInfo info = (DebugModuleInfo)evt.getInfo();
        long n = info.getNumberOfModules();
        SBProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((LldbEventsListener)this.getEventListeners().fire).moduleLoaded(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processModuleUnloaded(LldbModuleUnloadedEvent evt, Void v) {
        DebugModuleInfo info = (DebugModuleInfo)evt.getInfo();
        long n = info.getNumberOfModules();
        SBProcess process = info.getProcess();
        int i = 0;
        while ((long)i < n) {
            ((LldbEventsListener)this.getEventListeners().fire).moduleUnloaded(process, info, i, evt.getCause());
            ++i;
        }
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processStateChanged(LldbStateChangedEvent evt, Void v) {
        StateType state = ((DebugProcessInfo)evt.getInfo()).state;
        this.status = DebugClient.DebugStatus.fromArgument(state);
        if (this.status.equals((Object)DebugClient.DebugStatus.NO_DEBUGGEE)) {
            this.waiting = false;
            if (state.equals(StateType.eStateExited)) {
                if (this.eventThread != null) {
                    this.processEvent(new LldbRunningEvent(DebugClient.getId(this.eventThread)));
                }
                this.processEvent(new LldbProcessExitedEvent(0));
                this.processEvent(new LldbSessionExitedEvent(DebugClient.getId(this.currentSession), 0));
            }
            return DebugClient.DebugStatus.NO_DEBUGGEE;
        }
        if (this.status.equals((Object)DebugClient.DebugStatus.BREAK)) {
            Object info;
            this.waiting = false;
            SBProcess process = this.getCurrentProcess();
            if (process != null) {
                this.processEvent(new LldbProcessSelectedEvent(process));
                info = (DebugProcessInfo)evt.getInfo();
                StopReason stopReason = this.eventThread.GetStopReason();
                if (stopReason.equals(StopReason.eStopReasonThreadExiting)) {
                    this.processEvent(new LldbThreadExitedEvent(0));
                }
                if (stopReason.equals(StopReason.eStopReasonBreakpoint)) {
                    this.processEvent(new LldbBreakpointHitEvent((DebugProcessInfo)info));
                }
                if (stopReason.equals(StopReason.eStopReasonWatchpoint)) {
                    this.processEvent(new LldbWatchpointHitEvent((DebugProcessInfo)info));
                }
                if (stopReason.equals(StopReason.eStopReasonException)) {
                    this.processEvent(new LldbExceptionEvent((DebugProcessInfo)info));
                }
            }
            info = new DebugThreadInfo(this.eventThread);
            this.processEvent(new LldbThreadSelectedEvent((DebugThreadInfo)info));
            this.processEvent(new LldbStoppedEvent(DebugClient.getId(this.eventThread)));
            return DebugClient.DebugStatus.BREAK;
        }
        if (this.status.equals((Object)DebugClient.DebugStatus.GO)) {
            this.waiting = true;
            this.processEvent(new LldbRunningEvent(DebugClient.getId(this.eventThread)));
            return DebugClient.DebugStatus.GO;
        }
        this.waiting = false;
        return DebugClient.DebugStatus.NO_CHANGE;
    }

    protected DebugClient.DebugStatus processSessionSelected(LldbSessionSelectedEvent evt, Void v) {
        SBTarget session = evt.getSession();
        ((LldbEventsListener)this.getEventListeners().fire).sessionSelected(session, evt.getCause());
        return this.statusMap.get(evt.getClass());
    }

    protected DebugClient.DebugStatus processSystemsEvent(LldbSystemsEvent evt, Void v) {
        return this.statusMap.get(evt.getClass());
    }

    protected void processConsoleOutput(LldbConsoleOutputEvent evt, Void v) {
        if (evt.getOutput() != null) {
            ((LldbEventsListener)this.getEventListeners().fire).consoleOutput(evt.getOutput(), evt.getMask());
        }
    }

    protected void processBreakpointCreated(LldbBreakpointCreatedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointCreated(session, info, evt.getCause());
    }

    protected void processBreakpointModified(LldbBreakpointModifiedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        DebugBreakpointInfo info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointDeleted(LldbBreakpointDeletedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        this.doBreakpointDeleted(session, ((DebugBreakpointInfo)evt.getInfo()).id, evt.getCause());
    }

    protected void processBreakpointEnabled(LldbBreakpointEnabledEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        this.doBreakpointEnabled(session, ((DebugBreakpointInfo)evt.getInfo()).id, evt.getCause());
    }

    protected void processBreakpointDisabled(LldbBreakpointDisabledEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        this.doBreakpointDisabled(session, ((DebugBreakpointInfo)evt.getInfo()).id, evt.getCause());
    }

    protected void processBreakpointInvalidated(LldbBreakpointInvalidatedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        this.doBreakpointDisabled(session, ((DebugBreakpointInfo)evt.getInfo()).id, evt.getCause());
    }

    protected void processBreakpointLocationsResolved(LldbBreakpointLocationsResolvedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointLocationsAdded(LldbBreakpointLocationsAddedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointLocationsRemoved(LldbBreakpointLocationsRemovedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointAutoContinueChanged(LldbBreakpointAutoContinueChangedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointCommandChanged(LldbBreakpointCommandChangedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointConditionChanged(LldbBreakpointConditionChangedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointIgnoreChanged(LldbBreakpointIgnoreChangedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointThreadChanged(LldbBreakpointThreadChangedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    protected void processBreakpointTypeChanged(LldbBreakpointTypeChangedEvent evt, Void v) {
        SBTarget session = this.getCurrentSession();
        Object info = evt.getBreakpointInfo();
        this.doBreakpointModified(session, info, evt.getCause());
    }

    @Internal
    public void doBreakpointCreated(SBTarget session, Object info, LldbCause cause) {
        this.addKnownBreakpoint(session, info, false);
        ((LldbEventsListener)this.getEventListeners().fire).breakpointCreated(info, cause);
    }

    @Internal
    public void doBreakpointModified(SBTarget session, Object info, LldbCause cause) {
        this.addKnownBreakpoint(session, info, true);
        ((LldbEventsListener)this.getEventListeners().fire).breakpointModified(info, cause);
    }

    @Internal
    public void doBreakpointDeleted(SBTarget session, String id, LldbCause cause) {
        Object oldInfo = this.removeKnownBreakpoint(session, id);
        if (oldInfo == null) {
            return;
        }
        ((LldbEventsListener)this.getEventListeners().fire).breakpointDeleted(oldInfo, cause);
    }

    protected void doBreakpointModifiedSameLocations(SBTarget session, Object info, LldbCause cause) {
        this.addKnownBreakpoint(session, info, true);
        ((LldbEventsListener)this.getEventListeners().fire).breakpointModified(info, cause);
    }

    @Internal
    public void doBreakpointDisabled(SBTarget session, String id, LldbCause cause) {
        Object info = this.getKnownBreakpoint(session, id);
        if (info == null) {
            return;
        }
        if (info instanceof SBBreakpoint) {
            ((SBBreakpoint)info).SetEnabled(false);
        }
        if (info instanceof SBWatchpoint) {
            ((SBWatchpoint)info).SetEnabled(false);
        }
        this.doBreakpointModifiedSameLocations(session, info, cause);
    }

    @Internal
    public void doBreakpointEnabled(SBTarget session, String id, LldbCause cause) {
        Object info = this.getKnownBreakpoint(session, id);
        if (info == null) {
            return;
        }
        if (info instanceof SBBreakpoint) {
            ((SBBreakpoint)info).SetEnabled(true);
        }
        if (info instanceof SBWatchpoint) {
            ((SBWatchpoint)info).SetEnabled(true);
        }
        this.doBreakpointModifiedSameLocations(session, info, cause);
    }

    @Override
    public CompletableFuture<Map<String, SBThread>> listThreads(SBProcess process) {
        return this.execute(new LldbListThreadsCommand(this, process));
    }

    @Override
    public CompletableFuture<Map<String, SBProcess>> listProcesses(SBTarget session) {
        return this.execute(new LldbListProcessesCommand(this, session));
    }

    @Override
    public CompletableFuture<List<Pair<String, String>>> listAvailableProcesses() {
        return this.execute(new LldbListAvailableProcessesCommand(this));
    }

    @Override
    public CompletableFuture<Map<String, SBTarget>> listSessions() {
        return this.execute(new LldbListSessionsCommand(this));
    }

    @Override
    public CompletableFuture<Map<String, SBFrame>> listStackFrames(SBThread thread) {
        return this.execute(new LldbListStackFramesCommand(this, thread));
    }

    @Override
    public CompletableFuture<Map<String, SBValue>> listStackFrameRegisterBanks(SBFrame frame) {
        return this.execute(new LldbListStackFrameRegisterBanksCommand(this, frame));
    }

    @Override
    public CompletableFuture<Map<String, SBValue>> listStackFrameRegisters(SBValue bank) {
        return this.execute(new LldbListStackFrameRegistersCommand(this, bank));
    }

    @Override
    public CompletableFuture<Map<String, SBModule>> listModules(SBTarget session) {
        return this.execute(new LldbListModulesCommand(this, session));
    }

    @Override
    public CompletableFuture<Map<String, SBSection>> listModuleSections(SBModule module) {
        return this.execute(new LldbListModuleSectionsCommand(this, module));
    }

    @Override
    public CompletableFuture<Map<String, SBSymbol>> listModuleSymbols(SBModule module) {
        return this.execute(new LldbListModuleSymbolsCommand(this, module));
    }

    @Override
    public CompletableFuture<List<SBMemoryRegionInfo>> listMemory(SBProcess process) {
        return this.execute(new LldbListMemoryRegionsCommand(this, process));
    }

    @Override
    public CompletableFuture<Map<String, String>> listEnvironment(SBTarget session) {
        return this.execute(new LldbListEnvironmentCommand(this, session));
    }

    @Override
    public void sendInterruptNow() {
        Msg.info((Object)this, (Object)"Interrupting");
        this.currentSession.GetProcess().SendAsyncInterrupt();
    }

    @Override
    public CompletableFuture<SBProcess> addProcess() {
        return this.execute(new LldbAddProcessCommand(this));
    }

    @Override
    public CompletableFuture<Void> removeProcess(SBProcess process) {
        return this.execute(new LldbRemoveProcessCommand(this, process.GetTarget(), process.GetProcessID().toString()));
    }

    @Override
    public CompletableFuture<SBTarget> addSession() {
        return this.execute(new LldbAddSessionCommand(this));
    }

    @Override
    public CompletableFuture<?> attach(String pid) {
        return this.execute(new LldbAttachCommand(this, pid));
    }

    @Override
    public CompletableFuture<?> attach(String name, boolean wait) {
        return this.execute(new LldbAttachCommand(this, name, wait));
    }

    @Override
    public CompletableFuture<?> attach(String url, boolean wait, boolean async) {
        return this.execute(new LldbAttachCommand(this, url, wait));
    }

    @Override
    public CompletableFuture<?> launch(String fileName, List<String> args) {
        return this.execute(new LldbLaunchProcessCommand(this, fileName, args));
    }

    @Override
    public CompletableFuture<?> launch(Map<String, ?> args) {
        return this.execute(new LldbLaunchProcessWithOptionsCommand(this, args));
    }

    public CompletableFuture<?> openFile(Map<String, ?> args) {
        return this.execute(new LldbOpenDumpCommand(this, args));
    }

    public CompletableFuture<?> attachKernel(Map<String, ?> args) {
        this.setKernelMode(true);
        return this.execute(new LldbAttachKernelCommand(this, args));
    }

    public DebugClient getClient() {
        return this.executor.getClient();
    }

    public SBThread getCurrentThread() {
        if (this.currentThread != null && !this.currentThread.IsValid()) {
            this.currentProcess = this.currentSession.GetProcess();
            int i = 0;
            while ((long)i < this.currentProcess.GetNumThreads()) {
                SBThread sBThread = this.currentProcess.GetThreadAtIndex((long)i);
                ++i;
            }
            this.currentThread = SBThread.GetThreadFromEvent((SBEvent)this.currentEvent);
        }
        return this.currentThread != null ? this.currentThread : this.eventThread;
    }

    public void setCurrentThread(SBThread thread) {
        this.currentThread = thread;
    }

    public SBProcess getCurrentProcess() {
        return this.currentProcess != null ? this.currentProcess : this.eventProcess;
    }

    public SBTarget getCurrentSession() {
        return this.currentSession != null ? this.currentSession : this.eventSession;
    }

    public SBThread getEventThread() {
        return this.eventThread;
    }

    public SBProcess getEventProcess() {
        return this.eventProcess;
    }

    public SBTarget getEventSession() {
        return this.eventSession;
    }

    public CompletableFuture<Void> setActiveFrame(SBThread thread, int index) {
        this.currentThread = thread;
        return this.execute(new LldbSetActiveThreadCommand(this, thread, index));
    }

    public CompletableFuture<Void> setActiveThread(SBThread thread) {
        this.currentThread = thread;
        return this.execute(new LldbSetActiveThreadCommand(this, thread, -1L));
    }

    public CompletableFuture<Void> setActiveProcess(SBProcess process) {
        this.currentProcess = process;
        return this.execute(new LldbSetActiveProcessCommand(this, process));
    }

    public CompletableFuture<Void> setActiveSession(SBTarget session) {
        this.currentSession = session;
        return this.execute(new LldbSetActiveSessionCommand(this, session));
    }

    public CompletableFuture<Void> requestFocus(LldbModelTargetFocusScope scope, TargetObject obj) {
        return this.execute(new LldbRequestFocusCommand(this, scope, obj));
    }

    public CompletableFuture<Void> requestActivation(LldbModelTargetActiveScope activator, TargetObject obj) {
        return this.execute(new LldbRequestActivationCommand(this, activator, obj));
    }

    @Override
    public CompletableFuture<Void> console(String command) {
        if (this.continuation != null) {
            String prompt = command.equals("") ? "(lldb)" : ">>>";
            ((LldbEventsListener)this.getEventListeners().fire).promptChanged(prompt);
            this.continuation.complete(command);
            this.setContinuation(null);
            return AsyncUtils.NIL;
        }
        return this.execute(new LldbConsoleExecCommand(this, command, LldbConsoleExecCommand.Output.CONSOLE)).thenApply(e -> null);
    }

    @Override
    public CompletableFuture<String> consoleCapture(String command) {
        return this.execute(new LldbConsoleExecCommand(this, command, LldbConsoleExecCommand.Output.CAPTURE));
    }

    @Override
    public StateType getState() {
        if (this.currentProcess == null) {
            return null;
        }
        if (this.currentThread != null && !this.currentThread.IsValid()) {
            return StateType.eStateRunning;
        }
        return this.currentProcess.GetState();
    }

    @Override
    public SBProcess currentProcess() {
        return this.getCurrentProcess();
    }

    @Override
    public CompletableFuture<Void> waitForEventEx() {
        this.waiting = true;
        SBEvent event = this.getClient().waitForEvent();
        this.waiting = false;
        this.updateState(event);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<Void> waitForPrompt() {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<? extends Map<String, ?>> getRegisterMap(List<String> path) {
        return null;
    }

    public boolean isWaiting() {
        return this.waiting;
    }

    public boolean isKernelMode() {
        return this.kernelMode;
    }

    public void setKernelMode(boolean kernelMode) {
        this.kernelMode = kernelMode;
    }

    public void setContinuation(CompletableFuture<String> continuation) {
        this.continuation = continuation;
    }

    @Override
    public DebugClient.DebugStatus getStatus() {
        return this.status;
    }

    @Override
    public void setCurrentEvent(SBEvent evt) {
        this.currentEvent = evt;
    }

    static {
        String libPath = System.getProperty("java.library.path");
        try {
            Object lldb = "lldb";
            if (Platform.CURRENT_PLATFORM.getOperatingSystem() == OperatingSystem.WINDOWS) {
                lldb = "lib" + (String)lldb;
            }
            System.loadLibrary((String)lldb);
        }
        catch (UnsatisfiedLinkError ule) {
            Msg.error(LldbManagerImpl.class, (Object)("java.library.path => " + libPath));
            Msg.error(LldbManagerImpl.class, (Object)"liblldb not found - add relevant java.library.path to support/launch.properties");
        }
        try {
            System.loadLibrary("lldb-java");
        }
        catch (UnsatisfiedLinkError ule) {
            Msg.error(LldbManagerImpl.class, (Object)("java.library.path => " + libPath));
            Msg.error(LldbManagerImpl.class, (Object)"liblldb-java not found - add relevant java.library.path to support/launch.properties");
        }
    }

    class SavedFocus
    implements AutoCloseable {
        Integer tid = null;

        SavedFocus() {
        }

        @Override
        public void close() {
        }
    }

    static class BreakpointTag {
        long offset;

        public BreakpointTag(long offset) {
            this.offset = offset;
        }
    }

    static class BreakId {
        final Integer tid;
        final int bpid;

        public BreakId(Integer tid, int bpid) {
            this.tid = tid;
            this.bpid = bpid;
        }
    }

    static class ExitEvent {
        final Integer tid;
        final long exitCode;

        public ExitEvent(Integer tid, long exitCode) {
            this.tid = tid;
            this.exitCode = exitCode;
        }
    }
}

