/*
 * Decompiled with CFR 0.152.
 */
package agent.lldb.model.impl;

import SWIG.DescriptionLevel;
import SWIG.SBBreakpointLocation;
import SWIG.SBStream;
import SWIG.SBWatchpoint;
import agent.lldb.lldb.DebugClient;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocation;
import agent.lldb.model.iface2.LldbModelTargetBreakpointLocationContainer;
import agent.lldb.model.iface2.LldbModelTargetProcess;
import agent.lldb.model.iface2.LldbModelTargetSession;
import agent.lldb.model.impl.LldbModelTargetAbstractXpointSpec;
import agent.lldb.model.impl.LldbModelTargetObjectImpl;
import agent.lldb.model.impl.LldbModelTargetProcessImpl;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.Address;
import java.util.List;
import java.util.Map;

@TargetObjectSchemaInfo(name="BreakpointLocation", attributes={@TargetAttributeType(type=Void.class)})
public class LldbModelTargetBreakpointLocationImpl
extends LldbModelTargetObjectImpl
implements LldbModelTargetBreakpointLocation {
    protected LldbModelTargetAbstractXpointSpec spec;
    protected SBBreakpointLocation loc;
    protected Address address;
    protected Integer length;
    protected String display;

    protected static String keyLocation(SBBreakpointLocation loc) {
        return PathUtils.makeKey((String)DebugClient.getId(loc));
    }

    protected static String keyLocation(SBWatchpoint wpt) {
        return PathUtils.makeKey((String)(DebugClient.getId(wpt) + ".0"));
    }

    public LldbModelTargetBreakpointLocationImpl(LldbModelTargetAbstractXpointSpec spec, SBBreakpointLocation loc) {
        super(spec.getModel(), (TargetObject)spec, LldbModelTargetBreakpointLocationImpl.keyLocation(loc), loc, "BreakpointLocation");
        this.spec = spec;
        this.loc = loc;
        this.doChangeAttributes("Initialization");
    }

    public LldbModelTargetBreakpointLocationImpl(LldbModelTargetAbstractXpointSpec spec, SBWatchpoint wpt) {
        super(spec.getModel(), (TargetObject)spec, LldbModelTargetBreakpointLocationImpl.keyLocation(wpt), wpt, "BreakpointLocation");
        this.loc = null;
        this.address = this.getModel().getAddress("ram", wpt.GetWatchAddress().longValue());
        this.length = (int)wpt.GetWatchSize();
        this.display = this.getDescription(1);
        this.changeAttributes(List.of(), Map.of("_spec", this.parent, "_address", this.address, "_length", this.length, "_display", this.display), "Initialization");
        this.placeLocations();
    }

    @Override
    public String getDescription(int level) {
        Object modelObject = this.getModelObject();
        SBStream stream = new SBStream();
        DescriptionLevel detail = DescriptionLevel.swigToEnum((int)level);
        if (modelObject instanceof SBBreakpointLocation) {
            SBBreakpointLocation loc = (SBBreakpointLocation)this.getModelObject();
            loc.GetDescription(stream, detail);
        }
        if (modelObject instanceof SBWatchpoint) {
            SBWatchpoint wpt = (SBWatchpoint)this.getModelObject();
            wpt.GetDescription(stream, detail);
        }
        return stream.GetData();
    }

    protected void doChangeAttributes(String reason) {
        this.address = this.getModel().getAddress("ram", this.loc.GetLoadAddress().longValue());
        this.length = 1;
        this.display = this.getDescription(1);
        this.changeAttributes(List.of(), Map.of("_spec", this.parent, "_address", this.address, "_length", this.length, "_display", this.display), reason);
        this.placeLocations();
    }

    protected void placeLocations() {
        LldbModelTargetSession parentSession = this.getParentSession();
        Map cachedElements = parentSession.getProcesses().getCachedElements();
        for (TargetObject obj : cachedElements.values()) {
            if (!(obj instanceof LldbModelTargetProcess)) continue;
            LldbModelTargetProcessImpl process = (LldbModelTargetProcessImpl)obj;
            process.addBreakpointLocation(this);
        }
    }

    @Override
    protected void doInvalidate(TargetObject branch, String reason) {
        this.removeLocations();
        super.doInvalidate(branch, reason);
    }

    protected void removeLocations() {
        TargetObject modelObject = this.getModel().getModelObject(this.getManager().getCurrentProcess());
        if (modelObject instanceof LldbModelTargetProcess) {
            LldbModelTargetProcess targetProcess = (LldbModelTargetProcess)modelObject;
            LldbModelTargetBreakpointLocationContainer locs = (LldbModelTargetBreakpointLocationContainer)targetProcess.getCachedAttribute("Breakpoints");
            locs.removeBreakpointLocation(this);
        }
    }

    public Integer getLength() {
        return this.length;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    @Override
    public int getLocationId() {
        return this.loc.GetID();
    }
}

