/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.calltree;

import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.calltree.CallNode;
import ghidra.app.plugin.core.calltree.CallTreePlugin;
import ghidra.app.plugin.core.calltree.DeadEndNode;
import ghidra.app.plugin.core.calltree.ExternalCallNode;
import ghidra.app.plugin.core.calltree.OutgoingFunctionCallNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.program.util.FunctionSignatureFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.tree.TreePath;
import org.apache.commons.collections4.map.LazyMap;
import resources.Icons;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public abstract class OutgoingCallNode
extends CallNode {
    private static final Icon OUTGOING_ICON = Icons.ARROW_DOWN_RIGHT_ICON;
    private final Icon OUTGOING_FUNCTION_ICON;
    private Icon icon = null;
    protected final Program program;
    protected final Function function;
    protected String name;
    private final Address sourceAddress;
    protected final boolean filterDuplicates;
    private final Icon baseIcon;

    OutgoingCallNode(Program program, Function function, Address sourceAddress, Icon baseIcon, boolean filterDuplicates, AtomicInteger filterDepth) {
        super(filterDepth);
        this.program = program;
        this.function = function;
        this.name = function.getName();
        this.sourceAddress = sourceAddress;
        this.baseIcon = baseIcon;
        this.filterDuplicates = filterDuplicates;
        MultiIcon outgoingFunctionIcon = new MultiIcon(OUTGOING_ICON, false, 32, 16);
        TranslateIcon translateIcon = new TranslateIcon(baseIcon, 16, 0);
        outgoingFunctionIcon.addIcon((Icon)translateIcon);
        this.OUTGOING_FUNCTION_ICON = outgoingFunctionIcon;
        this.setAllowsDuplicates(!filterDuplicates);
    }

    @Override
    public Function getRemoteFunction() {
        return this.function;
    }

    public List<GTreeNode> generateChildren(TaskMonitor monitor) throws CancelledException {
        AddressSetView functionBody = this.function.getBody();
        Address entryPoint = this.function.getEntryPoint();
        Set<Reference> references = this.getReferencesFrom(this.program, functionBody, monitor);
        LazyMap nodesByFunction = LazyMap.lazyMap(new HashMap(), k -> new ArrayList());
        FunctionManager functionManager = this.program.getFunctionManager();
        for (Reference reference : references) {
            monitor.checkCanceled();
            Address toAddress = reference.getToAddress();
            if (toAddress.equals((Object)entryPoint)) continue;
            Function calledFunction = functionManager.getFunctionAt(toAddress);
            this.createNode((LazyMap<Function, List<GTreeNode>>)nodesByFunction, reference, calledFunction);
        }
        List<GTreeNode> children = nodesByFunction.values().stream().flatMap(list -> list.stream()).collect(Collectors.toList());
        Collections.sort(children, new CallNode.CallNodeComparator());
        return children;
    }

    private void createNode(LazyMap<Function, List<GTreeNode>> nodes, Reference reference, Function calledFunction) {
        if (calledFunction != null) {
            if (this.isExternalCall(calledFunction)) {
                ExternalCallNode node = new ExternalCallNode(calledFunction, reference.getFromAddress(), this.baseIcon);
                node.setAllowsDuplicates(!this.filterDuplicates);
                this.addNode(nodes, node);
            } else {
                this.addNode(nodes, new OutgoingFunctionCallNode(this.program, calledFunction, reference.getFromAddress(), this.filterDuplicates, this.filterDepth));
            }
        } else if (this.isCallReference(reference)) {
            Function externalFunction = this.getExternalFunctionTempHackWorkaround(reference);
            if (externalFunction != null) {
                ExternalCallNode node = new ExternalCallNode(externalFunction, reference.getFromAddress(), this.baseIcon);
                node.setAllowsDuplicates(!this.filterDuplicates);
                this.addNode(nodes, node);
            } else {
                DeadEndNode node = new DeadEndNode(this.program, reference);
                node.setAllowsDuplicates(!this.filterDuplicates);
                this.addNode(nodes, node);
            }
        }
    }

    private Function getExternalFunctionTempHackWorkaround(Reference reference) {
        Address toAddress = reference.getToAddress();
        Listing listing = this.program.getListing();
        Data data = listing.getDataAt(toAddress);
        if (data == null) {
            return null;
        }
        if (!data.isPointer()) {
            return null;
        }
        Reference primaryReference = data.getPrimaryReference(0);
        if (primaryReference.isExternalReference()) {
            FunctionManager functionManager = this.program.getFunctionManager();
            return functionManager.getFunctionAt(primaryReference.getToAddress());
        }
        return null;
    }

    private boolean isExternalCall(Function calledFunction) {
        return calledFunction.isExternal();
    }

    private boolean isCallReference(Reference reference) {
        RefType type = reference.getReferenceType();
        if (type.isCall()) {
            return true;
        }
        if (type.isWrite()) {
            return false;
        }
        Listing listing = this.program.getListing();
        Instruction instruction = listing.getInstructionAt(reference.getFromAddress());
        if (instruction == null || !instruction.getFlowType().isCall()) {
            return false;
        }
        if (listing.getFunctionAt(reference.getToAddress()) != null) {
            return true;
        }
        Data data = listing.getDataAt(reference.getToAddress());
        if (data == null) {
            return false;
        }
        Reference ref = data.getPrimaryReference(0);
        if (ref == null || !ref.isExternalReference()) {
            return false;
        }
        Symbol extSym = this.program.getSymbolTable().getPrimarySymbol(ref.getToAddress());
        SymbolType symbolType = extSym.getSymbolType();
        return symbolType == SymbolType.FUNCTION;
    }

    @Override
    public Address getSourceAddress() {
        return this.sourceAddress;
    }

    @Override
    public ProgramLocation getLocation() {
        return new FunctionSignatureFieldLocation(this.function.getProgram(), this.function.getEntryPoint());
    }

    public Icon getIcon(boolean expanded) {
        if (this.icon == null) {
            this.icon = this.OUTGOING_FUNCTION_ICON;
            if (this.functionIsInPath()) {
                this.icon = CallTreePlugin.RECURSIVE_ICON;
            }
        }
        return this.icon;
    }

    @Override
    boolean functionIsInPath() {
        Object[] pathComponents;
        TreePath path = this.getTreePath();
        for (Object pathComponent : pathComponents = path.getPath()) {
            OutgoingCallNode node = (OutgoingCallNode)((Object)pathComponent);
            if (node == this || !node.function.equals(this.function)) continue;
            return true;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getToolTip() {
        return "Called from " + this.sourceAddress;
    }

    public boolean isLeaf() {
        return false;
    }
}

