/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functioncompare.actions;

import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.fieldpanel.internal.FieldPanelCoordinator;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonPanel;
import ghidra.app.plugin.core.functioncompare.MultiFunctionComparisonProvider;
import ghidra.app.services.GoToService;
import ghidra.app.util.viewer.util.CodeComparisonPanel;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import resources.Icons;

public class NavigateToFunctionAction
extends ToggleDockingAction {
    private GoToService goToService;
    private static final ImageIcon NAV_FUNCTION_ICON = Icons.NAVIGATE_ON_INCOMING_EVENT_ICON;

    public NavigateToFunctionAction(MultiFunctionComparisonProvider provider) {
        super("Navigate To Selected Function", provider.getName());
        this.goToService = (GoToService)provider.getTool().getService(GoToService.class);
        this.setEnabled(true);
        this.setSelected(false);
        ToolBarData newToolBarData = new ToolBarData((Icon)NAV_FUNCTION_ICON);
        this.setToolBarData(newToolBarData);
        this.setDescription(HTMLUtilities.toHTML((String)"Toggle <b>On</b> means to navigate to whatever function is selected in the comparison panel, when focus changes ora new function is selected."));
        this.setHelpLocation(new HelpLocation("FunctionComparison", "Navigate_To_Function"));
        this.addFocusListeners(provider);
        this.addChangeListeners(provider);
    }

    private void addChangeListeners(MultiFunctionComparisonProvider provider) {
        final MultiFunctionComparisonPanel panel = (MultiFunctionComparisonPanel)provider.getComponent();
        panel.getSourceComponent().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (panel.getFocusedComponent() != panel.getSourceComponent()) {
                    return;
                }
                if (NavigateToFunctionAction.this.isSelected()) {
                    Function f = (Function)panel.getSourceComponent().getSelectedItem();
                    NavigateToFunctionAction.this.goToService.goTo(f.getEntryPoint(), f.getProgram());
                }
            }
        });
        panel.getTargetComponent().addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (panel.getFocusedComponent() != panel.getTargetComponent()) {
                    return;
                }
                if (NavigateToFunctionAction.this.isSelected()) {
                    Function f = (Function)panel.getTargetComponent().getSelectedItem();
                    NavigateToFunctionAction.this.goToService.goTo(f.getEntryPoint(), f.getProgram());
                }
            }
        });
    }

    private void addFocusListeners(MultiFunctionComparisonProvider provider) {
        FunctionComparisonPanel mainPanel = provider.getComponent();
        List<CodeComparisonPanel<? extends FieldPanelCoordinator>> panels = mainPanel.getComparisonPanels();
        for (final CodeComparisonPanel<? extends FieldPanelCoordinator> panel : panels) {
            panel.getRightFieldPanel().addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (NavigateToFunctionAction.this.isSelected()) {
                        Address addr = null;
                        if (panel.getRightFunction() != null) {
                            addr = panel.getRightFunction().getBody().getMinAddress();
                        } else if (panel.getRightData() != null) {
                            addr = panel.getRightData().getAddress();
                        } else if (panel.getRightAddresses() != null) {
                            addr = panel.getRightAddresses().getMinAddress();
                        }
                        NavigateToFunctionAction.this.goToService.goTo(addr, panel.getRightProgram());
                    }
                }
            });
            panel.getLeftFieldPanel().addFocusListener((FocusListener)new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    if (NavigateToFunctionAction.this.isSelected()) {
                        Address addr = null;
                        if (panel.getLeftFunction() != null) {
                            addr = panel.getLeftFunction().getBody().getMinAddress();
                        } else if (panel.getLeftData() != null) {
                            addr = panel.getLeftData().getAddress();
                        } else if (panel.getLeftAddresses() != null) {
                            addr = panel.getLeftAddresses().getMinAddress();
                        }
                        NavigateToFunctionAction.this.goToService.goTo(addr, panel.getLeftProgram());
                    }
                }
            });
        }
    }
}

