/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functionwindow;

import docking.ComponentProvider;
import docking.ComponentProviderActivationListener;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.plugin.ProgramPlugin;
import ghidra.app.plugin.core.functioncompare.FunctionComparisonProvider;
import ghidra.app.plugin.core.functioncompare.actions.CompareFunctionsFromFunctionTableAction;
import ghidra.app.plugin.core.functionwindow.FunctionWindowProvider;
import ghidra.app.services.FunctionComparisonService;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.util.ProgramChangeRecord;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Function Viewer", description="Provides a window that displays the list of functions in the program.", eventsConsumed={ProgramClosedPluginEvent.class})
public class FunctionWindowPlugin
extends ProgramPlugin
implements DomainObjectListener,
ComponentProviderActivationListener {
    private DockingAction selectAction;
    private DockingAction compareFunctionsAction;
    private FunctionWindowProvider provider;
    private SwingUpdateManager swingMgr = new SwingUpdateManager(1000, () -> this.provider.reload());
    private FunctionComparisonService functionComparisonService;

    public FunctionWindowPlugin(PluginTool tool) {
        super(tool, true, false);
    }

    public void init() {
        super.init();
        this.provider = new FunctionWindowProvider(this);
        this.createActions();
        this.provider.getTable().getSelectionModel().addListSelectionListener(x -> this.tool.contextChanged((ComponentProvider)this.provider));
    }

    public void dispose() {
        if (this.currentProgram != null) {
            this.currentProgram.removeListener((DomainObjectListener)this);
        }
        this.swingMgr.dispose();
        if (this.provider != null) {
            this.provider.dispose();
        }
        super.dispose();
    }

    public void serviceAdded(Class<?> interfaceClass, Object service) {
        if (interfaceClass == FunctionComparisonService.class) {
            this.functionComparisonService = (FunctionComparisonService)service;
            this.functionComparisonService.addFunctionComparisonProviderListener(this);
        }
    }

    public void serviceRemoved(Class<?> interfaceClass, Object service) {
        if (interfaceClass == FunctionComparisonService.class) {
            this.functionComparisonService.removeFunctionComparisonProviderListener(this);
            this.functionComparisonService = null;
        }
    }

    public void domainObjectChanged(DomainObjectChangedEvent ev) {
        if (!this.provider.isVisible()) {
            return;
        }
        if (ev.containsEvent(4) || ev.containsEvent(23) || ev.containsEvent(21)) {
            this.provider.reload();
            return;
        }
        block8: for (int i = 0; i < ev.numRecords(); ++i) {
            DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
            int eventType = doRecord.getEventType();
            switch (eventType) {
                case 30: 
                case 31: {
                    this.swingMgr.update();
                    continue block8;
                }
                case 150: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Function function = (Function)rec.getObject();
                    this.provider.functionAdded(function);
                    continue block8;
                }
                case 151: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Function function = (Function)rec.getObject();
                    if (function == null) continue block8;
                    this.provider.functionRemoved(function);
                    continue block8;
                }
                case 152: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Function function = (Function)rec.getObject();
                    this.provider.update(function);
                    continue block8;
                }
                case 40: 
                case 45: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Symbol sym = (Symbol)rec.getNewValue();
                    Address addr = sym.getAddress();
                    Function function = this.currentProgram.getListing().getFunctionAt(addr);
                    if (function == null) continue block8;
                    this.provider.update(function);
                    continue block8;
                }
                case 46: {
                    ProgramChangeRecord rec = (ProgramChangeRecord)ev.getChangeRecord(i);
                    Symbol sym = (Symbol)rec.getObject();
                    Address addr = sym.getAddress();
                    Function function = this.currentProgram.getListing().getFunctionAt(addr);
                    if (function == null) continue block8;
                    this.provider.update(function);
                }
            }
        }
    }

    @Override
    protected void programActivated(Program program) {
        program.addListener((DomainObjectListener)this);
        this.provider.programOpened(program);
    }

    @Override
    protected void programDeactivated(Program program) {
        program.removeListener((DomainObjectListener)this);
        this.provider.programClosed();
    }

    Program getProgram() {
        return this.currentProgram;
    }

    private void createActions() {
        SelectionNavigationAction action = new SelectionNavigationAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)action);
        this.selectAction = new MakeProgramSelectionAction(this, this.provider.getTable());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.selectAction);
        this.compareFunctionsAction = new CompareFunctionsFromFunctionTableAction(this.tool, this.getName());
        this.tool.addLocalAction((ComponentProvider)this.provider, (DockingActionIf)this.compareFunctionsAction);
    }

    void showFunctions() {
        this.provider.showFunctions();
    }

    public void componentProviderActivated(ComponentProvider componentProvider) {
        if (componentProvider instanceof FunctionComparisonProvider) {
            this.tool.contextChanged((ComponentProvider)this.provider);
        }
    }

    public void componentProviderDeactivated(ComponentProvider componentProvider) {
        if (componentProvider instanceof FunctionComparisonProvider) {
            this.tool.contextChanged((ComponentProvider)this.provider);
        }
    }
}

