/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import ghidra.app.context.ListingActionContext;
import ghidra.app.events.ProgramClosedPluginEvent;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.navigation.FindAppliedDataTypesService;
import ghidra.app.plugin.core.navigation.locationreferences.FindReferencesToAction;
import ghidra.app.plugin.core.navigation.locationreferences.FindReferencesToAddressAction;
import ghidra.app.plugin.core.navigation.locationreferences.GenericCompositeDataTypeProgramLocation;
import ghidra.app.plugin.core.navigation.locationreferences.GenericDataTypeProgramLocation;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesHighlighter;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesProvider;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesService;
import ghidra.app.plugin.core.navigation.locationreferences.ReferenceUtils;
import ghidra.app.services.GoToService;
import ghidra.app.services.ProgramManager;
import ghidra.app.util.XReferenceUtils;
import ghidra.app.util.query.TableService;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Reference;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.table.actions.DeleteTableRowAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Code Viewer", shortDescription="Displays references to a location", description="This plugin provides a component to show a list of references to the current item under the cursor.", servicesRequired={ProgramManager.class, GoToService.class}, servicesProvided={FindAppliedDataTypesService.class, LocationReferencesService.class}, eventsConsumed={ProgramClosedPluginEvent.class})
public class LocationReferencesPlugin
extends Plugin
implements FindAppliedDataTypesService,
LocationReferencesService {
    protected static final String SEARCH_OPTION_NAME = "Search";
    protected static final String DATA_TYPE_DISCOVERY_OPTION_NAME = "Dynamic Data Type Discovery";
    private DockingAction referencesToAction;
    private DockingAction referencesToAddressAction;
    private List<LocationReferencesProvider> providerList = new ArrayList<LocationReferencesProvider>();
    private LocationReferencesProvider lastHiddenProvider;
    private HelpLocation helpLocation = new HelpLocation(this.getName(), "Location_References_Plugin");

    public LocationReferencesPlugin(PluginTool tool) {
        super(tool);
        this.createActions();
    }

    protected void init() {
        this.initOptions();
        LocationReferencesHighlighter.registerHighlighterOptions(this);
    }

    private void initOptions() {
        ToolOptions options = this.tool.getOptions(SEARCH_OPTION_NAME);
        options.registerOption(DATA_TYPE_DISCOVERY_OPTION_NAME, (Object)true, new HelpLocation("LocationReferencesPlugin", "Data_Type_Discovery"), "True signals that Data Type searches should use data type discovery for types that are not applied in the Listing.  This option will slow the search.");
    }

    private void createActions() {
        int subGroupPosition = 0;
        this.referencesToAction = new FindReferencesToAction(this, subGroupPosition);
        this.referencesToAction.setHelpLocation(this.helpLocation);
        this.tool.addAction((DockingActionIf)this.referencesToAction);
        this.referencesToAddressAction = new FindReferencesToAddressAction(this, ++subGroupPosition);
        this.tool.addAction((DockingActionIf)this.referencesToAddressAction);
        DeleteTableRowAction.registerDummy(this.tool, this.getName());
        ((ActionBuilder)((ActionBuilder)((ActionBuilder)((ActionBuilder)new ActionBuilder("Show Xrefs", this.getName()).description("Show the Xrefs to the code unit containing the cursor")).validContextWhen(context -> context instanceof ListingActionContext)).helpLocation(new HelpLocation("CodeBrowserPlugin", "Show_Xrefs"))).onAction(context -> this.showXrefs((ActionContext)context))).buildAndInstall((Tool)this.tool);
    }

    private void showXrefs(ActionContext context) {
        TableService service = (TableService)this.tool.getService(TableService.class);
        if (service == null) {
            Msg.showWarn((Object)this, null, (String)"No Table Service", (Object)"Please add the TableServicePlugin.");
            return;
        }
        ListingActionContext lac = (ListingActionContext)context;
        ProgramLocation location = lac.getLocation();
        if (location == null) {
            return;
        }
        Set<Reference> refs = XReferenceUtils.getAllXrefs(location);
        XReferenceUtils.showXrefs(lac.getNavigatable(), (ServiceProvider)this.tool, service, location, refs);
    }

    void displayProvider(ListingActionContext context) {
        if (context.getLocation() == null) {
            return;
        }
        this.displayProviderForLocation(context.getLocation(), context.getNavigatable());
    }

    boolean useDynamicDataTypeSearching() {
        ToolOptions options = this.tool.getOptions(SEARCH_OPTION_NAME);
        boolean optionValue = options.getBoolean(DATA_TYPE_DISCOVERY_OPTION_NAME, true);
        return optionValue;
    }

    private void displayProviderForLocation(ProgramLocation location, Navigatable navigatable) {
        LocationDescriptor locationDescriptor = this.getLocationDescriptor(location);
        if (locationDescriptor == null) {
            throw new IllegalArgumentException("Unable to display provider - unknown location: " + location);
        }
        LocationReferencesProvider provider = this.findProvider(locationDescriptor, navigatable);
        if (provider == null) {
            provider = new LocationReferencesProvider(this, locationDescriptor, navigatable);
        } else {
            this.updateProvider(provider, locationDescriptor);
        }
        this.tool.showComponentProvider((ComponentProvider)provider, true);
        if (!this.providerList.contains(provider)) {
            this.providerList.add(provider);
        }
    }

    private LocationReferencesProvider findProvider(LocationDescriptor newLocationDescriptor, Navigatable navigatable) {
        for (int i = this.providerList.size() - 1; i >= 0; --i) {
            Navigatable providerNavigatable;
            LocationReferencesProvider provider = this.providerList.get(i);
            LocationDescriptor descriptor = provider.getLocationDescriptor();
            if (!descriptor.equals(newLocationDescriptor) || !(providerNavigatable = provider.getNavigatable()).equals(navigatable)) continue;
            return provider;
        }
        return null;
    }

    public void dispose() {
        this.tool.removeAction((DockingActionIf)this.referencesToAction);
        this.referencesToAction.dispose();
        this.disposeProviderList();
        super.dispose();
    }

    private void disposeProviderList() {
        for (int i = 0; i < this.providerList.size(); ++i) {
            LocationReferencesProvider provider = this.providerList.get(i);
            provider.dispose();
        }
        this.providerList.clear();
    }

    private void updateProvider(LocationReferencesProvider provider, LocationDescriptor locationDescriptor) {
        provider.update(locationDescriptor);
    }

    LocationDescriptor getLocationDescriptor(ProgramLocation programLocation) {
        return ReferenceUtils.getLocationDescriptor(programLocation);
    }

    void providerDismissed(LocationReferencesProvider provider) {
        this.providerList.remove(provider);
        if (provider == this.lastHiddenProvider) {
            this.lastHiddenProvider = null;
        }
        provider.dispose();
    }

    void providerDeactivated(LocationReferencesProvider provider) {
        this.lastHiddenProvider = provider;
    }

    void providerActivated(LocationReferencesProvider provider) {
        if (this.lastHiddenProvider != null && !this.lastHiddenProvider.equals(provider)) {
            this.lastHiddenProvider.clearHighlights();
        }
    }

    public void processEvent(PluginEvent event) {
        if (event instanceof ProgramClosedPluginEvent) {
            Program program = ((ProgramClosedPluginEvent)event).getProgram();
            this.programClosed(program);
            return;
        }
    }

    protected void programClosed(Program program) {
        Iterator<LocationReferencesProvider> iterator = this.providerList.iterator();
        while (iterator.hasNext()) {
            LocationReferencesProvider provider = iterator.next();
            if (provider.getProgram() != program) continue;
            provider.dispose();
            iterator.remove();
        }
    }

    private void showProvider(Program program, LocationReferencesProvider provider, LocationDescriptor locationDescriptor, Navigatable navigatable) {
        if (provider == null) {
            provider = new LocationReferencesProvider(this, locationDescriptor, navigatable);
        } else {
            this.updateProvider(provider, locationDescriptor);
        }
        this.tool.showComponentProvider((ComponentProvider)provider, true);
        if (!this.providerList.contains(provider)) {
            this.providerList.add(provider);
        }
    }

    @Override
    public void findAndDisplayAppliedDataTypeAddresses(DataType dataType) {
        ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        Program program = programManagerService.getCurrentProgram();
        if (program == null) {
            Msg.showInfo((Object)this, null, (String)"Find References To...", (Object)"You must have a program open in order to use the 'Find References To...' action");
            return;
        }
        GenericDataTypeProgramLocation genericLocation = new GenericDataTypeProgramLocation(program, dataType);
        LocationDescriptor locationDescriptor = this.getLocationDescriptor(genericLocation);
        Navigatable navigatable = goToService.getDefaultNavigatable();
        LocationReferencesProvider provider = this.findProvider(locationDescriptor, navigatable);
        this.showProvider(program, provider, locationDescriptor, navigatable);
    }

    @Override
    public void findAndDisplayAppliedDataTypeAddresses(Composite dataType, String fieldName) {
        ProgramManager programManagerService = (ProgramManager)this.tool.getService(ProgramManager.class);
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        Program program = programManagerService.getCurrentProgram();
        if (program == null) {
            Msg.showInfo((Object)this, null, (String)"Find References To...", (Object)"You must have a program open in order to use the 'Find References To...' action");
            return;
        }
        GenericCompositeDataTypeProgramLocation genericLocation = new GenericCompositeDataTypeProgramLocation(program, dataType, fieldName);
        LocationDescriptor locationDescriptor = this.getLocationDescriptor(genericLocation);
        Navigatable navigatable = goToService.getDefaultNavigatable();
        LocationReferencesProvider provider = this.findProvider(locationDescriptor, navigatable);
        this.showProvider(program, provider, locationDescriptor, navigatable);
    }

    @Override
    public void showReferencesToLocation(ProgramLocation location, Navigatable navigatable) {
        if (location == null) {
            throw new NullPointerException("Cannot show references to a null location");
        }
        this.displayProviderForLocation(location, navigatable);
    }

    @Override
    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    void fireContextChanged(LocationReferencesProvider provider) {
        this.tool.contextChanged((ComponentProvider)provider);
    }
}

