/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation.locationreferences;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.widgets.table.GTable;
import ghidra.app.nav.Navigatable;
import ghidra.app.nav.NavigatableRemovalListener;
import ghidra.app.plugin.core.navigation.locationreferences.DataTypeLocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationDescriptor;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesHighlighter;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesPanel;
import ghidra.app.plugin.core.navigation.locationreferences.LocationReferencesPlugin;
import ghidra.app.services.GoToService;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.SelectionNavigationAction;
import ghidra.util.table.actions.DeleteTableRowAction;
import ghidra.util.table.actions.MakeProgramSelectionAction;
import ghidra.util.task.SwingUpdateManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableModelEvent;
import resources.Icons;
import resources.ResourceManager;

public class LocationReferencesProvider
extends ComponentProviderAdapter
implements DomainObjectListener,
NavigatableRemovalListener {
    private static Icon HIGHLIGHT_ICON = ResourceManager.loadImage((String)"images/tag_yellow.png");
    private static Icon HOME_ICON = ResourceManager.loadImage((String)"images/go-home.png");
    private static Icon REFRESH_ICON = Icons.REFRESH_ICON;
    private static Icon REFRESH_NOT_NEEDED_ICON = ResourceManager.getDisabledIcon((Icon)Icons.REFRESH_ICON, (int)60);
    private static final String TITLE_PREFIX_REFERENCES = "References to ";
    private static final String TITLE_PREFIX_USAGE = "Uses of ";
    public static final String NAME = "Location References Provider";
    private LocationReferencesPlugin locationReferencesPlugin;
    private LocationReferencesHighlighter highlightManager;
    private LocationReferencesPanel referencesPanel;
    private JComponent providerComponent;
    private DockingAction homeAction;
    private DockingAction selectionAction;
    private ToggleDockingAction highlightAction;
    private DockingAction refreshAction;
    private AddressSet addressSetCache;
    private SwingUpdateManager updateManager;
    private LocationDescriptor currentLocationDescriptor;
    private ChangeListener modelFreshnessListener = e -> this.refreshAction.getToolBarData().setIcon(REFRESH_ICON);
    private final Navigatable navigatable;
    private Program program;

    LocationReferencesProvider(LocationReferencesPlugin locationReferencesPlugin, LocationDescriptor locationDescriptor, Navigatable navigatable) {
        super(locationReferencesPlugin.getTool(), NAME, locationReferencesPlugin.getName());
        this.locationReferencesPlugin = locationReferencesPlugin;
        this.currentLocationDescriptor = locationDescriptor;
        this.navigatable = navigatable;
        this.program = navigatable.getProgram();
        navigatable.addNavigatableListener(this);
        this.program.addListener((DomainObjectListener)this);
        this.setTitle(TITLE_PREFIX_REFERENCES);
        this.setHelpLocation(new HelpLocation(locationReferencesPlugin.getName(), "LocationReferencesPlugin"));
        this.setWindowMenuGroup("References");
        this.setTransient();
        this.createView();
        this.addToTool();
        this.createActions();
        this.addListeners();
        this.updateManager = new SwingUpdateManager(1000, 10000, () -> {
            boolean refresh;
            Icon refreshIcon = this.refreshAction.getToolBarData().getIcon();
            boolean bl = refresh = refreshIcon == REFRESH_ICON;
            if (refresh) {
                this.doUpdateAndReloadReferencesTable();
                this.refreshAction.getToolBarData().setIcon(REFRESH_NOT_NEEDED_ICON);
            } else {
                this.doUpdateReferencesTable();
            }
        });
        this.setLocationDescriptor(locationDescriptor, navigatable);
        this.referencesPanel.getTable().getSelectionModel().addListSelectionListener(e -> {
            if (e.getValueIsAdjusting()) {
                return;
            }
            locationReferencesPlugin.fireContextChanged(this);
        });
        this.setVisible(true);
    }

    public void domainObjectChanged(DomainObjectChangedEvent changeEvent) {
        this.currentLocationDescriptor.domainObjectChanged(changeEvent);
    }

    @Override
    public void navigatableRemoved(Navigatable theNavigatable) {
        this.locationReferencesPlugin.providerDismissed(this);
    }

    private void doUpdateReferencesTable() {
        this.referencesPanel.updateModel();
    }

    private void doUpdateAndReloadReferencesTable() {
        this.referencesPanel.reloadModel();
    }

    private void setLocationDescriptor(LocationDescriptor locationDescriptor, Navigatable navigatable) {
        if (this.highlightManager != null) {
            this.highlightManager.dispose();
        }
        this.highlightManager = new LocationReferencesHighlighter(this.locationReferencesPlugin, this, navigatable);
        this.clearHighlights();
        this.currentLocationDescriptor = locationDescriptor;
        this.currentLocationDescriptor.setModelFreshnessListener(this.modelFreshnessListener);
        this.updateHomeActionState();
        this.setTitle(this.generateTitle());
    }

    void update(LocationDescriptor locationDescriptor) {
        this.setLocationDescriptor(locationDescriptor, this.navigatable);
        this.updateManager.updateNow();
    }

    private void updateHighlights() {
        if (!this.referencesPanel.isInitialized()) {
            return;
        }
        if (this != this.highlightManager.getCurrentHighlightProvider()) {
            return;
        }
        this.highlightManager.setHighlightingEnabled(this.highlightAction.isSelected());
    }

    void clearHighlights() {
        this.highlightManager.setHighlightingEnabled(false);
    }

    void dispose() {
        this.updateManager.dispose();
        this.referencesPanel.dispose();
        this.highlightManager.dispose();
        this.navigatable.removeNavigatableListener(this);
        this.program.removeListener((DomainObjectListener)this);
        this.program = null;
        this.tool.removeComponentProvider((ComponentProvider)this);
        this.homeAction.dispose();
        this.refreshAction.dispose();
        this.highlightAction.dispose();
        this.selectionAction.dispose();
    }

    LocationDescriptor getLocationDescriptor() {
        return this.currentLocationDescriptor;
    }

    boolean useDynamicDataTypeSearching() {
        return this.locationReferencesPlugin.useDynamicDataTypeSearching();
    }

    private void createView() {
        this.providerComponent = new JPanel(new BorderLayout(10, 10));
        this.providerComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.referencesPanel = new LocationReferencesPanel(this);
        this.providerComponent.add((Component)this.referencesPanel, "Center");
    }

    private void createActions() {
        this.homeAction = new DockingAction("Home", this.locationReferencesPlugin.getName()){

            public void actionPerformed(ActionContext context) {
                LocationReferencesProvider.this.goTo(LocationReferencesProvider.this.currentLocationDescriptor.getHomeLocation(), LocationReferencesProvider.this.currentLocationDescriptor.getProgram());
            }
        };
        this.homeAction.setToolBarData(new ToolBarData(HOME_ICON));
        this.updateHomeActionState();
        this.selectionAction = new MakeProgramSelectionAction(this.locationReferencesPlugin, this.referencesPanel.getTable());
        this.highlightAction = new ToggleDockingAction("Highlight Matches", this.getName()){

            public void actionPerformed(ActionContext context) {
                LocationReferencesProvider.this.updateHighlights();
            }
        };
        this.highlightAction.setToolBarData(new ToolBarData(HIGHLIGHT_ICON));
        this.highlightAction.setSelected(true);
        this.highlightAction.setDescription("Highlight matches in tool");
        this.refreshAction = new DockingAction("Refresh", this.locationReferencesPlugin.getName()){

            public void actionPerformed(ActionContext context) {
                LocationReferencesProvider.this.updateManager.updateNow();
            }
        };
        this.refreshAction.setToolBarData(new ToolBarData(REFRESH_NOT_NEEDED_ICON));
        this.refreshAction.setDescription("<html>Push at any time to refresh the current table of references.<br>This button is highlighted when the data <i>may</i> be stale.<br>");
        SelectionNavigationAction selectionNavigationAction = new SelectionNavigationAction(this.locationReferencesPlugin, this.referencesPanel.getTable());
        GhidraTable table = this.referencesPanel.getTable();
        DeleteAction removeItemsAction = new DeleteAction(this.tool, table);
        removeItemsAction.setEnabled(false);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.homeAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.refreshAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.selectionAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)this.highlightAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)removeItemsAction);
        this.tool.addLocalAction((ComponentProvider)this, (DockingActionIf)selectionNavigationAction);
        this.setHelpLocation();
    }

    private void updateHomeActionState() {
        boolean hasHomeLocation = this.currentLocationDescriptor.getHomeLocation() != null;
        this.homeAction.setEnabled(hasHomeLocation);
        String description = hasHomeLocation ? "Go back to the location from where this dialog was generated" : "No home location";
        this.homeAction.setDescription(description);
    }

    private void setHelpLocation() {
        this.homeAction.setHelpLocation(new HelpLocation(this.locationReferencesPlugin.getName(), "Home"));
        this.refreshAction.setHelpLocation(new HelpLocation(this.locationReferencesPlugin.getName(), "Refresh"));
        this.selectionAction.setHelpLocation(new HelpLocation(this.locationReferencesPlugin.getName(), "Select"));
        this.highlightAction.setHelpLocation(new HelpLocation(this.locationReferencesPlugin.getName(), "Highlight"));
    }

    private void goTo(ProgramLocation loc, Program theProgram) {
        GoToService goToService = (GoToService)this.tool.getService(GoToService.class);
        goToService.goTo(loc, theProgram);
    }

    private void addListeners() {
        GhidraTable table = this.referencesPanel.getTable();
        ((JTable)((Object)table)).getSelectionModel().addListSelectionListener(arg_0 -> this.lambda$addListeners$3((JTable)((Object)table), arg_0));
        this.referencesPanel.addTableModelListener(arg_0 -> this.lambda$addListeners$4((JTable)((Object)table), arg_0));
    }

    private String generateTitle() {
        String suffix;
        String string = suffix = this.currentLocationDescriptor == null ? "" : this.currentLocationDescriptor.getLabel();
        if (this.currentLocationDescriptor instanceof DataTypeLocationDescriptor) {
            return TITLE_PREFIX_USAGE + suffix;
        }
        return TITLE_PREFIX_REFERENCES + suffix;
    }

    AddressSet getReferenceAddresses(Program theProgram) {
        if (this.addressSetCache == null) {
            this.addressSetCache = new AddressSet();
            Collection<Address> referenceAddresses = this.referencesPanel.getReferenceAddresses();
            for (Address address : referenceAddresses) {
                this.addressSetCache.addRange(address, address);
            }
        }
        return this.addressSetCache;
    }

    Navigatable getNavigatable() {
        return this.navigatable;
    }

    Program getProgram() {
        return this.program;
    }

    public void closeComponent() {
        this.locationReferencesPlugin.providerDismissed(this);
    }

    public void componentHidden() {
        this.clearHighlights();
        this.updateManager.dispose();
        this.referencesPanel.dispose();
    }

    public void componentActivated() {
        this.locationReferencesPlugin.providerActivated(this);
        this.updateHighlights();
    }

    public void componentDeactived() {
        this.locationReferencesPlugin.providerDeactivated(this);
    }

    public JComponent getComponent() {
        return this.referencesPanel;
    }

    public ActionContext getActionContext(MouseEvent event) {
        return new ActionContext((ComponentProvider)this, (Component)((Object)this.referencesPanel.getTable()));
    }

    private /* synthetic */ void lambda$addListeners$4(JTable table, TableModelEvent e) {
        this.addressSetCache = null;
        this.updateHighlights();
        this.setTitle(this.generateTitle() + " - " + table.getRowCount() + " locations");
    }

    private /* synthetic */ void lambda$addListeners$3(JTable table, ListSelectionEvent e) {
        if (!e.getValueIsAdjusting()) {
            this.selectionAction.setEnabled(table.getSelectedRowCount() > 0);
        }
    }

    private class DeleteAction
    extends DeleteTableRowAction {
        DeleteAction(PluginTool tool, GTable table) {
            super(table, LocationReferencesProvider.this.locationReferencesPlugin.getName());
        }

        @Override
        public void actionPerformed(ActionContext context) {
            super.actionPerformed(context);
            LocationReferencesProvider.this.refreshAction.getToolBarData().setIcon(REFRESH_ICON);
        }
    }
}

