/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.osgi;

import generic.io.NullPrintWriter;
import generic.jar.ResourceFile;
import ghidra.app.plugin.core.osgi.BundleHostListener;
import ghidra.app.plugin.core.osgi.BundleMap;
import ghidra.app.plugin.core.osgi.GhidraBundle;
import ghidra.app.plugin.core.osgi.GhidraBundleException;
import ghidra.app.plugin.core.osgi.GhidraJarBundle;
import ghidra.app.plugin.core.osgi.GhidraPlaceholderBundle;
import ghidra.app.plugin.core.osgi.GhidraSourceBundle;
import ghidra.app.plugin.core.osgi.OSGiException;
import ghidra.app.plugin.core.osgi.OSGiUtils;
import ghidra.framework.Application;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import org.apache.felix.framework.FrameworkFactory;
import org.apache.felix.framework.wiring.BundleRequirementImpl;
import org.jgrapht.Graph;
import org.jgrapht.graph.DirectedMultigraph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.launch.Framework;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.FrameworkWiring;

public class BundleHost {
    public static final String ACTIVATING_BUNDLE_ERROR_MSG = "activating bundle";
    protected static final boolean STDERR_DEBUGGING = false;
    private static final String SAVE_STATE_TAG_FILE = "BundleHost_FILE";
    private static final String SAVE_STATE_TAG_ENABLE = "BundleHost_ENABLE";
    private static final String SAVE_STATE_TAG_ACTIVE = "BundleHost_ACTIVE";
    private static final String SAVE_STATE_TAG_SYSTEM = "BundleHost_SYSTEM";
    private final BundleMap bundleMap = new BundleMap();
    BundleContext frameworkBundleContext;
    Framework felixFramework;
    List<BundleHostListener> listeners = new CopyOnWriteArrayList<BundleHostListener>();

    public void dispose() {
        this.stopFramework();
    }

    public boolean enable(ResourceFile bundleFile) {
        GhidraBundle bundle = this.bundleMap.get(bundleFile);
        if (bundle == null) {
            bundle = this.add(bundleFile, true, false);
            return true;
        }
        if (bundleFile.exists() && bundle instanceof GhidraPlaceholderBundle) {
            this.remove(bundle);
            this.add(bundleFile, true, false);
            return true;
        }
        return this.enable(bundle);
    }

    public boolean enable(GhidraBundle bundle) {
        if (!bundle.isEnabled()) {
            bundle.setEnabled(true);
            this.fireBundleEnablementChange(bundle, true);
            return true;
        }
        return false;
    }

    public boolean disable(GhidraBundle bundle) {
        if (bundle.isEnabled()) {
            bundle.setEnabled(false);
            this.fireBundleEnablementChange(bundle, false);
            return true;
        }
        return false;
    }

    public GhidraBundle getExistingGhidraBundle(ResourceFile bundleFile) {
        GhidraBundle bundle = this.bundleMap.get(bundleFile);
        if (bundle == null) {
            Msg.showError((Object)this, null, (String)"ghidra bundle cache", (Object)("getExistingGhidraBundle expected a GhidraBundle created at " + bundleFile + " but none was found"));
        }
        return bundle;
    }

    public GhidraBundle getGhidraBundle(ResourceFile bundleFile) {
        return this.bundleMap.get(bundleFile);
    }

    private static GhidraBundle createGhidraBundle(BundleHost bundleHost, ResourceFile bundleFile, boolean enabled, boolean systemBundle) {
        if (!bundleFile.exists()) {
            return new GhidraPlaceholderBundle(bundleHost, bundleFile, enabled, systemBundle, "file not found: " + generic.util.Path.toPathString((ResourceFile)bundleFile));
        }
        switch (GhidraBundle.getType(bundleFile)) {
            case SOURCE_DIR: {
                return new GhidraSourceBundle(bundleHost, bundleFile, enabled, systemBundle);
            }
            case JAR: {
                return new GhidraJarBundle(bundleHost, bundleFile, enabled, systemBundle);
            }
        }
        return new GhidraPlaceholderBundle(bundleHost, bundleFile, enabled, systemBundle, "no bundle type for " + generic.util.Path.toPathString((ResourceFile)bundleFile));
    }

    public GhidraBundle add(ResourceFile bundleFile, boolean enabled, boolean systemBundle) {
        GhidraBundle bundle = BundleHost.createGhidraBundle(this, bundleFile, enabled, systemBundle);
        this.bundleMap.add(bundle);
        this.fireBundleAdded(bundle);
        return bundle;
    }

    public Collection<GhidraBundle> add(List<ResourceFile> bundleFiles, boolean enabled, boolean systemBundle) {
        Collection<GhidraBundle> newBundles = this.bundleMap.computeAllIfAbsent(bundleFiles, bundleFile -> BundleHost.createGhidraBundle(this, bundleFile, enabled, systemBundle));
        this.fireBundlesAdded(newBundles);
        return newBundles;
    }

    private void add(List<GhidraBundle> bundles) {
        this.bundleMap.addAll(bundles);
        this.fireBundlesAdded(bundles);
    }

    public void remove(ResourceFile bundleFile) {
        GhidraBundle bundle = this.bundleMap.remove(bundleFile);
        this.fireBundleRemoved(bundle);
    }

    public void remove(String bundleLocation) {
        GhidraBundle bundle = this.bundleMap.remove(bundleLocation);
        this.fireBundleRemoved(bundle);
    }

    public void remove(GhidraBundle bundle) {
        this.bundleMap.remove(bundle);
        this.fireBundleRemoved(bundle);
    }

    public void remove(Collection<GhidraBundle> bundles) {
        this.bundleMap.removeAll(bundles);
        this.fireBundlesRemoved(bundles);
    }

    Bundle installFromPath(Path p) throws GhidraBundleException {
        return this.installFromLoc(p.toUri().toString());
    }

    public Bundle install(GhidraBundle bundle) throws GhidraBundleException {
        try {
            return this.frameworkBundleContext.installBundle(bundle.getLocationIdentifier());
        }
        catch (BundleException e) {
            throw new GhidraBundleException(bundle.getLocationIdentifier(), "installing from bundle location", e);
        }
    }

    Bundle installFromLoc(String bundleLocation) throws GhidraBundleException {
        try {
            return this.frameworkBundleContext.installBundle(bundleLocation);
        }
        catch (BundleException e) {
            throw new GhidraBundleException(bundleLocation, "installing from bundle location", e);
        }
    }

    Bundle installAsLoc(String bundleLocation, InputStream contents) throws GhidraBundleException {
        try {
            return this.frameworkBundleContext.installBundle(bundleLocation, contents);
        }
        catch (BundleException e) {
            throw new GhidraBundleException(bundleLocation, "installing as bundle location", e);
        }
    }

    public Collection<GhidraBundle> getGhidraBundles() {
        return this.bundleMap.getGhidraBundles();
    }

    public Collection<ResourceFile> getBundleFiles() {
        return this.bundleMap.getBundleFiles();
    }

    void dumpLoadedBundles() {
        System.err.printf("=== Bundles ===\n", new Object[0]);
        for (Bundle bundle : this.frameworkBundleContext.getBundles()) {
            System.err.printf("%s: %s: %s: %s\n", bundle.getBundleId(), bundle.getSymbolicName(), bundle.getState(), bundle.getVersion());
        }
    }

    public List<BundleWiring> resolve(List<BundleRequirement> requirements) {
        ArrayList<BundleWiring> bundleWirings = new ArrayList<BundleWiring>();
        for (Bundle bundle : this.frameworkBundleContext.getBundles()) {
            if (bundle.getState() != 32) continue;
            BundleWiring bundleWiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            boolean keeper = false;
            for (BundleCapability capability : bundleWiring.getCapabilities(null)) {
                Iterator<BundleRequirement> requirementsIterator = requirements.iterator();
                while (requirementsIterator.hasNext()) {
                    BundleRequirement requirement = requirementsIterator.next();
                    if (!requirement.matches(capability)) continue;
                    requirementsIterator.remove();
                    keeper = true;
                }
            }
            if (!keeper) continue;
            bundleWirings.add(bundleWiring);
        }
        return bundleWirings;
    }

    public boolean canResolveAll(Collection<BundleRequirement> requirements) {
        LinkedList<BundleRequirement> tmpRequirements = new LinkedList<BundleRequirement>(requirements);
        this.resolve(tmpRequirements);
        return tmpRequirements.isEmpty();
    }

    protected String buildExtraSystemPackages() {
        HashSet<String> packages = new HashSet<String>();
        OSGiUtils.getPackagesFromClasspath(packages);
        return packages.stream().collect(Collectors.joining(","));
    }

    public static Path getOsgiDir() {
        Path usersettings = Application.getUserSettingsDirectory().toPath();
        return usersettings.resolve("osgi");
    }

    protected static Path getCacheDir() {
        return BundleHost.getOsgiDir().resolve("felixcache");
    }

    private static String makeCacheDir() throws IOException {
        Path cacheDir = BundleHost.getCacheDir();
        Files.createDirectories(cacheDir, new FileAttribute[0]);
        return cacheDir.toAbsolutePath().toString();
    }

    protected void createAndConfigureFramework() throws IOException {
        Properties config = new Properties();
        config.setProperty("org.osgi.framework.bsnversion", "multiple");
        config.setProperty("org.osgi.framework.system.packages.extra", this.buildExtraSystemPackages());
        config.setProperty("org.osgi.framework.storage.clean", "onFirstInit");
        config.setProperty("org.osgi.framework.storage", BundleHost.makeCacheDir());
        config.put("felix.log.level", "1");
        FrameworkFactory factory = new FrameworkFactory();
        this.felixFramework = factory.newFramework((Map)config);
    }

    protected void addDebuggingListeners() {
        this.frameworkBundleContext.addFrameworkListener(new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                System.err.printf("%s %s\n", event.getBundle(), event);
            }
        });
        this.frameworkBundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                String type = "?";
                if (event.getType() == 1) {
                    type = "registered";
                } else if (event.getType() == 4) {
                    type = "unregistering";
                }
                System.err.printf("%s %s from %s\n", event.getSource(), type, event.getServiceReference().getBundle().getLocation());
            }
        });
    }

    public void startFramework() throws OSGiException, IOException {
        this.createAndConfigureFramework();
        try {
            this.felixFramework.init();
        }
        catch (BundleException e) {
            throw new OSGiException("initializing felix OSGi framework", e);
        }
        this.frameworkBundleContext = this.felixFramework.getBundleContext();
        this.frameworkBundleContext.addBundleListener((BundleListener)new MyBundleListener(this.frameworkBundleContext.getBundle()));
        try {
            this.felixFramework.start();
        }
        catch (BundleException e) {
            throw new OSGiException("starting felix OSGi framework", e);
        }
    }

    protected void stopFramework() {
        if (this.felixFramework != null) {
            try {
                this.felixFramework.stop();
                FrameworkEvent event = this.felixFramework.waitForStop(5000L);
                if (event.getType() == 512) {
                    Msg.error((Object)this, (Object)"Stopping OSGi framework timed out after 5 seconds.");
                }
                this.felixFramework = null;
            }
            catch (InterruptedException | BundleException e) {
                Msg.error((Object)this, (Object)"Failed to stop OSGi framework.");
                e.printStackTrace();
            }
        }
    }

    Framework getHostFramework() {
        return this.felixFramework;
    }

    Bundle getOSGiBundle(String bundleLocation) {
        return this.frameworkBundleContext.getBundle(bundleLocation);
    }

    public void activateSynchronously(Bundle bundle) throws GhidraBundleException {
        if (bundle.getState() == 32) {
            return;
        }
        try {
            bundle.start();
        }
        catch (BundleException e) {
            GhidraBundleException bundleException = new GhidraBundleException(bundle, ACTIVATING_BUNDLE_ERROR_MSG, e);
            this.fireBundleException(bundleException);
            throw bundleException;
        }
    }

    public void activateSynchronously(String bundleLocation) throws GhidraBundleException, InterruptedException {
        Bundle bundle = this.getOSGiBundle(bundleLocation);
        if (bundle == null) {
            bundle = this.installFromLoc(bundleLocation);
        }
        this.activateSynchronously(bundle);
    }

    public void deactivateSynchronously(Bundle bundle) throws GhidraBundleException {
        if (bundle.getState() == 1) {
            return;
        }
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.felixFramework.adapt(FrameworkWiring.class);
        LinkedList dependentBundles = new LinkedList(frameworkWiring.getDependencyClosure(Collections.singleton(bundle)));
        while (!dependentBundles.isEmpty()) {
            Bundle dependentBundle = (Bundle)dependentBundles.pop();
            try {
                dependentBundle.uninstall();
                if (dependentBundle.getState() != 1) {
                    Msg.error((Object)this, (Object)("Failed to uninstall bundle: " + dependentBundle.getLocation()));
                }
                this.refreshBundlesSynchronously(new ArrayList<Bundle>(dependentBundles));
            }
            catch (BundleException e) {
                GhidraBundleException exception = new GhidraBundleException(dependentBundle, "deactivating bundle", e);
                this.fireBundleException(exception);
                throw exception;
            }
        }
    }

    public void deactivateSynchronously(String bundleLocation) throws GhidraBundleException, InterruptedException {
        Bundle bundle = this.getOSGiBundle(bundleLocation);
        if (bundle != null) {
            this.deactivateSynchronously(bundle);
        }
    }

    protected void refreshBundlesSynchronously(Collection<Bundle> bundles) {
        FrameworkWiring frameworkWiring = (FrameworkWiring)this.felixFramework.adapt(FrameworkWiring.class);
        final CountDownLatch latch = new CountDownLatch(1);
        frameworkWiring.refreshBundles(bundles, new FrameworkListener[]{new FrameworkListener(){

            public void frameworkEvent(FrameworkEvent event) {
                if (event.getType() == 2) {
                    Bundle bundle = event.getBundle();
                    Msg.error((Object)BundleHost.this, (Object)String.format("OSGi error refreshing bundle: %s", bundle));
                }
                latch.countDown();
            }
        }});
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void removeListener(BundleHostListener bundleHostListener) {
        this.listeners.remove(bundleHostListener);
    }

    public void activateAll(Collection<GhidraBundle> bundles, TaskMonitor monitor, PrintWriter console) {
        BundleDependencyGraph dependencyGraph = new BundleDependencyGraph(bundles, monitor);
        monitor.setMaximum((long)dependencyGraph.vertexSet().size());
        for (GhidraBundle bundle : dependencyGraph.inTopologicalOrder()) {
            if (monitor.isCancelled()) break;
            try {
                bundle.build(console);
                this.activateSynchronously(bundle.getLocationIdentifier());
            }
            catch (GhidraBundleException e) {
                this.fireBundleException(e);
            }
            catch (Exception e) {
                e.printStackTrace(console);
            }
            monitor.incrementProgress(1L);
        }
    }

    public void activateInStages(Collection<GhidraBundle> bundles, TaskMonitor monitor, PrintWriter console) {
        HashMap<GhidraBundle, List<BundleRequirement>> requirementMap = new HashMap<GhidraBundle, List<BundleRequirement>>();
        for (GhidraBundle bundle2 : bundles) {
            try {
                List<BundleRequirement> requirements = bundle2.getAllRequirements();
                requirements.removeIf(r -> {
                    BundleRequirementImpl rimpl = (BundleRequirementImpl)r;
                    return rimpl.isOptional();
                });
                requirementMap.put(bundle2, requirements);
            }
            catch (GhidraBundleException e) {
                this.fireBundleException(e);
            }
        }
        List<Object> bundlesRemaining = new ArrayList(requirementMap.keySet());
        monitor.setMaximum((long)bundlesRemaining.size());
        block6: while (!bundlesRemaining.isEmpty() && !monitor.isCancelled()) {
            List resolvableBundles = bundlesRemaining.stream().filter(bundle -> this.canResolveAll((Collection)requirementMap.get(bundle))).collect(Collectors.toList());
            if (resolvableBundles.isEmpty()) {
                resolvableBundles = bundlesRemaining;
                bundlesRemaining = Collections.emptyList();
            } else {
                bundlesRemaining.removeAll(resolvableBundles);
            }
            for (GhidraBundle bundle3 : resolvableBundles) {
                if (monitor.isCancelled()) continue block6;
                try {
                    bundle3.build(console);
                    this.activateSynchronously(bundle3.getLocationIdentifier());
                }
                catch (GhidraBundleException e) {
                    this.fireBundleException(e);
                }
                catch (Exception e) {
                    e.printStackTrace(console);
                }
                monitor.incrementProgress(1L);
            }
        }
    }

    void notifyBundleBuilt(GhidraBundle bundle, String summary) {
        this.fireBundleBuilt(bundle, summary);
    }

    private void fireBundleBuilt(GhidraBundle bundle, String summary) {
        for (BundleHostListener l : this.listeners) {
            l.bundleBuilt(bundle, summary);
        }
    }

    private void fireBundleEnablementChange(GhidraBundle bundle, boolean newEnablement) {
        for (BundleHostListener l : this.listeners) {
            l.bundleEnablementChange(bundle, newEnablement);
        }
    }

    private void fireBundleActivationChange(GhidraBundle bundle, boolean newEnablement) {
        for (BundleHostListener l : this.listeners) {
            l.bundleActivationChange(bundle, newEnablement);
        }
    }

    private void fireBundleAdded(GhidraBundle bundle) {
        for (BundleHostListener l : this.listeners) {
            l.bundleAdded(bundle);
        }
    }

    private void fireBundleRemoved(GhidraBundle bundle) {
        for (BundleHostListener l : this.listeners) {
            l.bundleRemoved(bundle);
        }
    }

    private void fireBundlesAdded(Collection<GhidraBundle> gbundles) {
        for (BundleHostListener l : this.listeners) {
            l.bundlesAdded(gbundles);
        }
    }

    private void fireBundlesRemoved(Collection<GhidraBundle> gbundles) {
        for (BundleHostListener l : this.listeners) {
            l.bundlesRemoved(gbundles);
        }
    }

    private void fireBundleException(GhidraBundleException exception) {
        for (BundleHostListener l : this.listeners) {
            l.bundleException(exception);
        }
    }

    public void addListener(BundleHostListener bundleHostListener) {
        this.listeners.add(bundleHostListener);
    }

    public void restoreManagedBundleState(SaveState saveState, PluginTool tool) {
        String[] bundleFiles = saveState.getStrings(SAVE_STATE_TAG_FILE, new String[0]);
        boolean[] bundleIsEnabled = saveState.getBooleans(SAVE_STATE_TAG_ENABLE, new boolean[bundleFiles.length]);
        boolean[] bundleIsActive = saveState.getBooleans(SAVE_STATE_TAG_ACTIVE, new boolean[bundleFiles.length]);
        boolean[] bundleIsSystem = saveState.getBooleans(SAVE_STATE_TAG_SYSTEM, new boolean[bundleFiles.length]);
        ArrayList<GhidraBundle> newBundles = new ArrayList<GhidraBundle>();
        ArrayList<GhidraBundle> bundlesToActivate = new ArrayList<GhidraBundle>();
        for (int i = 0; i < bundleFiles.length; ++i) {
            ResourceFile bundleFile = generic.util.Path.fromPathString((String)bundleFiles[i]);
            boolean isEnabled = bundleIsEnabled[i];
            boolean isActive = bundleIsActive[i];
            boolean isSystem = bundleIsSystem[i];
            GhidraBundle bundle = this.bundleMap.get(bundleFile);
            if (bundle != null) {
                if (isEnabled != bundle.isEnabled()) {
                    bundle.setEnabled(isEnabled);
                    this.fireBundleEnablementChange(bundle, isEnabled);
                }
                if (isSystem != bundle.isSystemBundle()) {
                    bundle.systemBundle = isSystem;
                    Msg.error((Object)this, (Object)String.format("Error, bundle %s went from %ssystem to %ssystem", bundleFile, isSystem ? "not " : "", isSystem ? "" : "not "));
                }
            } else if (!isSystem) {
                bundle = BundleHost.createGhidraBundle(this, bundleFile, isEnabled, isSystem);
                newBundles.add(bundle);
            }
            if (bundle == null || !isActive) continue;
            bundlesToActivate.add(bundle);
        }
        if (!newBundles.isEmpty()) {
            this.add(newBundles);
        }
        if (!bundlesToActivate.isEmpty()) {
            TaskLauncher.launchNonModal((String)"restoring bundle state", monitor -> this.activateInStages(bundlesToActivate, monitor, (PrintWriter)new NullPrintWriter()));
        }
    }

    public void saveManagedBundleState(SaveState saveState) {
        Collection<GhidraBundle> bundles = this.bundleMap.getGhidraBundles();
        int numBundles = bundles.size();
        String[] bundleFiles = new String[numBundles];
        boolean[] bundleIsEnabled = new boolean[numBundles];
        boolean[] bundleIsActive = new boolean[numBundles];
        boolean[] bundleIsSystem = new boolean[numBundles];
        int index = 0;
        for (GhidraBundle bundle : bundles) {
            bundleFiles[index] = generic.util.Path.toPathString((ResourceFile)bundle.getFile());
            bundleIsEnabled[index] = bundle.isEnabled();
            bundleIsActive[index] = bundle.isActive();
            bundleIsSystem[index] = bundle.isSystemBundle();
            ++index;
        }
        saveState.putStrings(SAVE_STATE_TAG_FILE, bundleFiles);
        saveState.putBooleans(SAVE_STATE_TAG_ENABLE, bundleIsEnabled);
        saveState.putBooleans(SAVE_STATE_TAG_ACTIVE, bundleIsActive);
        saveState.putBooleans(SAVE_STATE_TAG_SYSTEM, bundleIsSystem);
    }

    private class MyBundleListener
    implements BundleListener {
        private final Bundle systemBundle;

        private MyBundleListener(Bundle systemBundle) {
            this.systemBundle = systemBundle;
        }

        public void bundleChanged(BundleEvent event) {
            Bundle osgiBundle = event.getBundle();
            if (osgiBundle == this.systemBundle) {
                return;
            }
            switch (event.getType()) {
                case 2: {
                    GhidraBundle bundle = BundleHost.this.bundleMap.getBundleAtLocation(osgiBundle.getLocation());
                    if (bundle != null) {
                        BundleHost.this.fireBundleActivationChange(bundle, true);
                        break;
                    }
                    Msg.error((Object)this, (Object)String.format("Error, bundle event for non-GhidraBundle: %s\n", osgiBundle.getLocation()));
                    break;
                }
                default: {
                    GhidraBundle bundle = BundleHost.this.bundleMap.getBundleAtLocation(osgiBundle.getLocation());
                    if (bundle != null) {
                        BundleHost.this.fireBundleActivationChange(bundle, false);
                        break;
                    }
                    Msg.error((Object)this, (Object)String.format("Error, bundle event for non-GhidraBundle: %s\n", osgiBundle.getLocation()));
                }
            }
        }
    }

    private class BundleDependencyGraph
    extends DirectedMultigraph<GhidraBundle, Dependency> {
        final Map<GhidraBundle, List<BundleCapability>> capabilityMap;
        final List<GhidraBundle> availableBundles;
        final TaskMonitor monitor;

        BundleDependencyGraph(Collection<GhidraBundle> startingBundles, TaskMonitor monitor) {
            super(null, null, false);
            this.capabilityMap = new HashMap<GhidraBundle, List<BundleCapability>>();
            this.monitor = monitor;
            this.availableBundles = new ArrayList<GhidraBundle>();
            for (GhidraBundle ghidraBundle : BundleHost.this.getGhidraBundles()) {
                if (!ghidraBundle.isEnabled()) continue;
                this.addToAvailable(ghidraBundle);
            }
            HashMap<GhidraBundle, Set<GhidraBundle>> front = new HashMap<GhidraBundle, Set<GhidraBundle>>();
            for (GhidraBundle bundle : startingBundles) {
                front.put(bundle, null);
            }
            while (!front.isEmpty() && !monitor.isCancelled()) {
                this.addFront(front);
                HashMap<GhidraBundle, Set<GhidraBundle>> hashMap = new HashMap<GhidraBundle, Set<GhidraBundle>>();
                for (GhidraBundle bundle : front.keySet()) {
                    this.resolve(bundle, hashMap);
                }
                this.handleBackEdges(hashMap);
                front = hashMap;
            }
        }

        Iterable<GhidraBundle> inTopologicalOrder() {
            return () -> new TopologicalOrderIterator((Graph)this);
        }

        void handleBackEdges(Map<GhidraBundle, Set<GhidraBundle>> newFront) {
            Iterator<Map.Entry<GhidraBundle, Set<GhidraBundle>>> newFrontIter = newFront.entrySet().iterator();
            while (newFrontIter.hasNext() && !this.monitor.isCancelled()) {
                Map.Entry<GhidraBundle, Set<GhidraBundle>> entry = newFrontIter.next();
                GhidraBundle source = entry.getKey();
                if (!this.containsVertex(source)) continue;
                for (GhidraBundle destination : entry.getValue()) {
                    if (source == destination) continue;
                    this.addEdge(source, destination, new Dependency());
                }
                newFrontIter.remove();
            }
        }

        void addFront(Map<GhidraBundle, Set<GhidraBundle>> front) {
            for (Map.Entry<GhidraBundle, Set<GhidraBundle>> e : front.entrySet()) {
                GhidraBundle source = e.getKey();
                if (!this.addToAvailable(source)) continue;
                this.addVertex(source);
                Set<GhidraBundle> destinations = e.getValue();
                if (destinations == null) continue;
                for (GhidraBundle destination : destinations) {
                    this.addEdge(source, destination, new Dependency());
                }
            }
        }

        boolean addToAvailable(GhidraBundle bundle) {
            try {
                this.capabilityMap.put(bundle, bundle.getAllCapabilities());
                this.availableBundles.add(bundle);
                return true;
            }
            catch (GhidraBundleException ex) {
                BundleHost.this.fireBundleException(ex);
                return false;
            }
        }

        void resolve(GhidraBundle bundle, Map<GhidraBundle, Set<GhidraBundle>> newFront) {
            ArrayList<BundleRequirement> requirements;
            try {
                requirements = new ArrayList<BundleRequirement>(bundle.getAllRequirements());
                if (requirements.isEmpty()) {
                    return;
                }
            }
            catch (GhidraBundleException e) {
                BundleHost.this.fireBundleException(e);
                this.removeVertex(bundle);
                return;
            }
            for (GhidraBundle depBundle : this.availableBundles) {
                for (BundleCapability capability : this.capabilityMap.get(depBundle)) {
                    if (this.monitor.isCancelled()) {
                        return;
                    }
                    Iterator reqIter = requirements.iterator();
                    while (reqIter.hasNext()) {
                        BundleRequirement req = (BundleRequirement)reqIter.next();
                        if (!req.matches(capability)) continue;
                        newFront.computeIfAbsent(depBundle, b -> new HashSet()).add(bundle);
                        reqIter.remove();
                    }
                    if (!requirements.isEmpty()) continue;
                    return;
                }
            }
        }
    }

    private static class Dependency {
        private Dependency() {
        }
    }
}

