/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.action.MenuData;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.SymbolGTree;
import ghidra.app.plugin.core.symboltree.SymbolTreeActionContext;
import ghidra.app.plugin.core.symboltree.SymbolTreePlugin;
import ghidra.app.plugin.core.symboltree.actions.SymbolTreeContextAction;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.util.NamespaceUtils;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.InvalidInputException;
import javax.swing.tree.TreePath;

public class ConvertToClassAction
extends SymbolTreeContextAction {
    private static final String NAME = "Convert to Class";

    public ConvertToClassAction(SymbolTreePlugin plugin, String group, String subGroup) {
        super(NAME, plugin.getName());
        MenuData menuData = new MenuData(new String[]{NAME}, group);
        menuData.setMenuSubGroup(subGroup);
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
    }

    @Override
    public boolean isEnabledForContext(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        if (selectionPaths.length != 1) {
            return false;
        }
        Object object = selectionPaths[0].getLastPathComponent();
        if (object instanceof SymbolNode) {
            SymbolNode symbolNode = (SymbolNode)((Object)object);
            Symbol symbol = symbolNode.getSymbol();
            return symbol.getSymbolType() == SymbolType.NAMESPACE;
        }
        return false;
    }

    @Override
    protected void actionPerformed(SymbolTreeActionContext context) {
        TreePath[] selectionPaths = context.getSelectedSymbolTreePaths();
        Program program = context.getProgram();
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        SymbolGTree tree = context.getSymbolTree();
        GTreeNode root = tree.getViewRoot();
        GTreeNode classesNode = root.getChild(SymbolCategory.CLASS_CATEGORY.getName());
        Symbol symbol = ((SymbolNode)node).getSymbol();
        Namespace namespace = (Namespace)symbol.getObject();
        if (namespace != null) {
            String name = namespace.getName();
            ConvertToClassAction.convertToClass(program, namespace);
            program.flushEvents();
            context.getSymbolTree().startEditing(classesNode, name);
        }
    }

    private static void convertToClass(Program program, Namespace ns) {
        int id = program.startTransaction(NAME);
        boolean success = false;
        try {
            NamespaceUtils.convertNamespaceToClass((Namespace)ns);
            success = true;
        }
        catch (InvalidInputException e) {
            throw new AssertException((Throwable)e);
        }
        finally {
            program.endTransaction(id, success);
        }
    }
}

