/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.totd;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import ghidra.app.plugin.core.totd.TipOfTheDayDialog;
import ghidra.framework.main.FrontEndOnly;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.framework.preferences.Preferences;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import utilities.util.FileUtilities;

@PluginInfo(status=PluginStatus.RELEASED, packageName="Ghidra Core", category="Common", shortDescription="Tip Of The Day", description="Display a dialog containing 'Tips of the Day'.")
public class TipOfTheDayPlugin
extends Plugin
implements FrontEndOnly {
    private static final String TIP_INDEX = "TIP_INDEX";
    private static final String SHOW_TIPS = "SHOW_TIPS";
    private TipOfTheDayDialog dialog;
    private DockingAction action;

    public TipOfTheDayPlugin(PluginTool tool) {
        super(tool);
    }

    protected void init() {
        this.action = new DockingAction("Tips of the day", this.getName()){

            public void actionPerformed(ActionContext context) {
                TipOfTheDayPlugin.this.dialog.doShow(TipOfTheDayPlugin.this.tool.getToolFrame());
            }
        };
        this.action.setMenuBarData(new MenuData(new String[]{"Help", "Tip of the Day"}, "AAAHelpContents"));
        this.action.setEnabled(true);
        this.action.setHelpLocation(new HelpLocation("Tool", "Tip_of_the_day"));
        this.tool.addAction((DockingActionIf)this.action);
        List<String> tips = null;
        try {
            tips = this.loadTips();
        }
        catch (IOException e) {
            tips = new ArrayList<String>();
        }
        this.dialog = new TipOfTheDayDialog(this, tips);
        this.readPreferences();
    }

    private List<String> loadTips() throws IOException {
        try (InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream("tips.txt");){
            List tips = in == null ? Collections.emptyList() : FileUtilities.getLines((InputStream)in);
            List<String> list = tips.stream().filter(s -> s.length() > 0).collect(Collectors.toList());
            return list;
        }
    }

    protected void dispose() {
        this.writePreferences();
        this.action.dispose();
        this.dialog.close();
    }

    private void readPreferences() {
        String tipIndexStr = Preferences.getProperty((String)TIP_INDEX, (String)"0", (boolean)true);
        String showTipsStr = Preferences.getProperty((String)SHOW_TIPS, (String)"true", (boolean)true);
        int tipIndex = Integer.parseInt(tipIndexStr);
        boolean showTips = Boolean.parseBoolean(showTipsStr);
        if (showTips) {
            ++tipIndex;
            this.writePreferences(tipIndex %= this.dialog.getNumberOfTips(), showTips);
        }
        this.dialog.setTipIndex(tipIndex);
        this.dialog.setShowTips(showTips);
        SystemUtilities.runSwingLater(() -> {
            if (showTips && !SystemUtilities.isInTestingMode()) {
                this.dialog.show(this.tool.getToolFrame());
            } else {
                this.dialog.close();
            }
        });
    }

    void writePreferences() {
        if (this.dialog != null) {
            this.writePreferences(this.dialog.getTipIndex(), this.dialog.showTips());
        }
    }

    private void writePreferences(int tipIndex, boolean showTips) {
        Preferences.setProperty((String)TIP_INDEX, (String)("" + tipIndex));
        Preferences.setProperty((String)SHOW_TIPS, (String)("" + showTips));
        Preferences.store();
    }
}

