/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.datatype;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.PaddingSettingsDefinition;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.scalar.Scalar;

public abstract class AbstractLeb128DataType
extends BuiltIn
implements Dynamic {
    public static final int MAX_LEB128_ENCODED_VALUE_LEN = 8;
    private static final FormatSettingsDefinition FORMAT = FormatSettingsDefinition.DEF_HEX;
    private static final PaddingSettingsDefinition PADDING = PaddingSettingsDefinition.DEF;
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[]{FORMAT, PADDING};
    private final boolean signed;

    public AbstractLeb128DataType(String name, boolean signed, DataTypeManager dtm) {
        super(null, name, dtm);
        this.signed = signed;
    }

    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    public String getDescription() {
        return "Dwarf LEB128-Encoded Number";
    }

    public int getLength() {
        return -1;
    }

    public int getLength(MemBuffer buf, int maxLength) {
        int numRead;
        if (maxLength < 1 || maxLength > 8) {
            maxLength = 8;
        }
        byte[] data = new byte[maxLength];
        int availBytes = buf.getBytes(data, 0);
        byte curByte = 0;
        for (numRead = 0; numRead < availBytes && numRead < data.length; ++numRead) {
            curByte = data[numRead];
            if ((curByte & 0x80) != 0) continue;
            break;
        }
        return numRead;
    }

    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            return null;
        }
        int numRead = 0;
        int shift = 0;
        byte curByte = 0;
        long val = 0L;
        if (data.length >= 1) {
            do {
                curByte = data[numRead];
                val |= (long)((curByte & 0x7F) << shift);
                shift += 7;
            } while ((curByte & 0x80) != 0 && ++numRead < data.length);
            if (this.signed && (curByte & 0x40) != 0) {
                val |= (long)(-1 << shift);
            }
        }
        return new Scalar(numRead * 8, val, this.signed);
    }

    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        int radix;
        int format = FORMAT.getFormat(settings);
        boolean padded = PADDING.isPadded(settings);
        int size = this.getLength(buf, length);
        if (size <= 0 && length <= 0) {
            return "??";
        }
        Scalar val = (Scalar)this.getValue(buf, settings, length);
        if (val == null) {
            return "??";
        }
        String prefix = "";
        String postfix = "";
        switch (format) {
            default: {
                radix = 16;
                postfix = "h";
                break;
            }
            case 1: {
                radix = 10;
                break;
            }
            case 2: {
                radix = 2;
                postfix = "b";
                break;
            }
            case 3: {
                radix = 8;
                postfix = "o";
            }
        }
        String valStr = val.toString(radix, padded, true, prefix, "");
        return valStr.toUpperCase() + postfix;
    }

    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }

    public boolean canSpecifyLength() {
        return false;
    }
}

