/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.exceptionhandlers.gcc.structures.ehFrame;

import ghidra.app.cmd.comments.SetCommentCmd;
import ghidra.app.cmd.data.CreateStructureCmd;
import ghidra.app.plugin.exceptionhandlers.gcc.datatype.DwarfEncodingModeDataType;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.task.TaskMonitor;

public class ExceptionHandlerFrameHeader {
    private TaskMonitor monitor;
    private Program prog;
    private StructureDataType ehFrameHdrStruct;
    private int eh_version;
    private int eh_FramePtrEncoding;
    private int eh_FrameDescEntryCntEncoding;
    private int eh_FrameTableEncoding;

    public ExceptionHandlerFrameHeader(TaskMonitor monitor, Program curProg) {
        this.monitor = monitor;
        this.prog = curProg;
        this.ehFrameHdrStruct = new StructureDataType("eh_frame_hdr", 0);
        this.ehFrameHdrStruct.add((DataType)new ByteDataType(), "eh_frame_hdr_version", "Exception Handler Frame Header Version");
        this.ehFrameHdrStruct.add((DataType)new DwarfEncodingModeDataType(), "eh_frame_pointer_encoding", "Exception Handler Frame Pointer Encoding");
        this.ehFrameHdrStruct.add((DataType)new DwarfEncodingModeDataType(), "eh_frame_desc_entry_count_encoding", "Encoding of # of Exception Handler FDEs");
        this.ehFrameHdrStruct.add((DataType)new DwarfEncodingModeDataType(), "eh_frame_table_encoding", "Exception Handler Table Encoding");
    }

    public void addToDataTypeManager() {
        ProgramBasedDataTypeManager dtManager = this.prog.getDataTypeManager();
        dtManager.addDataType((DataType)this.ehFrameHdrStruct, DataTypeConflictHandler.REPLACE_HANDLER);
    }

    public void create(Address addr) throws MemoryAccessException, AddressOutOfBoundsException {
        CreateStructureCmd dataCmd = null;
        if (addr == null || this.monitor.isCancelled()) {
            return;
        }
        dataCmd = new CreateStructureCmd((Structure)this.ehFrameHdrStruct, addr);
        dataCmd.applyTo((DomainObject)this.prog);
        SetCommentCmd commentCmd = new SetCommentCmd(addr, 3, "Exception Handler Frame Header");
        commentCmd.applyTo((DomainObject)this.prog);
        this.eh_version = this.prog.getMemory().getByte(addr) & 0xFF;
        this.eh_FramePtrEncoding = this.prog.getMemory().getByte(addr.add(1L)) & 0xFF;
        this.eh_FrameDescEntryCntEncoding = this.prog.getMemory().getByte(addr.add(2L)) & 0xFF;
        this.eh_FrameTableEncoding = this.prog.getMemory().getByte(addr.add(3L)) & 0xFF;
    }

    public int getLength() {
        return this.ehFrameHdrStruct.getLength();
    }

    public int getEh_FrameVersion() {
        return this.eh_version;
    }

    public int getEh_FrameDescEntryCntEncoding() {
        return this.eh_FrameDescEntryCntEncoding;
    }

    public int getEh_FramePtrEncoding() {
        return this.eh_FramePtrEncoding;
    }

    public int getEh_FrameTableEncoding() {
        return this.eh_FrameTableEncoding;
    }
}

