/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.script;

import ghidra.app.events.ProgramHighlightPluginEvent;
import ghidra.app.events.ProgramLocationPluginEvent;
import ghidra.app.events.ProgramSelectionPluginEvent;
import ghidra.app.script.GatherParamPanel;
import ghidra.framework.model.Project;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;
import ghidra.util.Swing;
import ghidra.util.SystemUtilities;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JOptionPane;

public class GhidraState {
    private PluginTool tool;
    private Program currentProgram;
    private ProgramLocation currentLocation;
    private ProgramSelection currentSelection;
    private ProgramSelection currentHighlight;
    private HashMap<String, Object> envmap = new HashMap();
    private GatherParamPanel gatherParamPanel;
    private Project project;
    private final boolean isGlobalState;

    public GhidraState(PluginTool tool, Project project, Program program, ProgramLocation location, ProgramSelection selection, ProgramSelection highlight) {
        this.tool = tool;
        this.project = project;
        this.currentProgram = program;
        this.currentLocation = location;
        this.currentSelection = selection;
        this.currentHighlight = highlight;
        this.isGlobalState = true;
        if (!SystemUtilities.isInHeadlessMode()) {
            Swing.runNow(() -> {
                this.gatherParamPanel = new GatherParamPanel(this);
            });
        }
    }

    public GhidraState(GhidraState state) {
        this.tool = state.tool;
        this.currentProgram = state.currentProgram;
        this.currentLocation = state.currentLocation;
        this.currentSelection = state.currentSelection;
        this.currentHighlight = state.currentHighlight;
        this.envmap = new HashMap<String, Object>(state.envmap);
        this.project = state.project;
        this.isGlobalState = false;
    }

    public PluginTool getTool() {
        return this.tool;
    }

    public Project getProject() {
        return this.project;
    }

    public Program getCurrentProgram() {
        return this.currentProgram;
    }

    public void setCurrentProgram(Program program) {
        if (program == this.currentProgram) {
            return;
        }
        this.currentProgram = program;
        if (this.gatherParamPanel == null) {
            return;
        }
        this.gatherParamPanel.currentProgramChanged();
    }

    public Address getCurrentAddress() {
        return this.currentLocation != null ? this.currentLocation.getAddress() : null;
    }

    public void setCurrentAddress(Address address) {
        if (SystemUtilities.isEqual((Object)address, (Object)this.getCurrentAddress())) {
            return;
        }
        this.setCurrentLocation(new ProgramLocation(this.currentProgram, address));
    }

    public ProgramLocation getCurrentLocation() {
        return this.currentLocation;
    }

    public void setCurrentLocation(ProgramLocation location) {
        if (SystemUtilities.isEqual((Object)this.currentLocation, (Object)location)) {
            return;
        }
        this.currentLocation = location;
        if (this.isGlobalState && this.tool != null) {
            ProgramLocationPluginEvent ev = new ProgramLocationPluginEvent(null, location, this.currentProgram);
            this.tool.firePluginEvent((PluginEvent)ev);
        }
    }

    public ProgramSelection getCurrentHighlight() {
        return this.currentHighlight;
    }

    public void setCurrentHighlight(ProgramSelection highlight) {
        if (SystemUtilities.isEqual((Object)this.currentHighlight, (Object)highlight)) {
            return;
        }
        this.currentHighlight = highlight;
        if (this.isGlobalState && this.tool != null) {
            ProgramSelection sel = this.currentHighlight != null ? this.currentHighlight : new ProgramSelection((AddressSetView)new AddressSet());
            ProgramHighlightPluginEvent evt = new ProgramHighlightPluginEvent(this.getClass().getName(), sel, this.currentProgram);
            this.tool.firePluginEvent((PluginEvent)evt);
        }
    }

    public ProgramSelection getCurrentSelection() {
        return this.currentSelection;
    }

    public void setCurrentSelection(ProgramSelection selection) {
        if (SystemUtilities.isEqual((Object)this.currentSelection, (Object)selection)) {
            return;
        }
        this.currentSelection = selection;
        if (this.isGlobalState && this.tool != null) {
            ProgramSelection sel = this.currentSelection != null ? this.currentSelection : new ProgramSelection((AddressSetView)new AddressSet());
            ProgramSelectionPluginEvent evt = new ProgramSelectionPluginEvent(this.getClass().getName(), sel, this.currentProgram);
            this.tool.firePluginEvent((PluginEvent)evt);
        }
    }

    public void addEnvironmentVar(String name, byte value) {
        this.envmap.put(name, value);
    }

    public void addEnvironmentVar(String name, short value) {
        this.envmap.put(name, value);
    }

    public void addEnvironmentVar(String name, int value) {
        this.envmap.put(name, value);
    }

    public void addEnvironmentVar(String name, long value) {
        this.envmap.put(name, value);
    }

    public void addEnvironmentVar(String name, float value) {
        this.envmap.put(name, Float.valueOf(value));
    }

    public void addEnvironmentVar(String name, double value) {
        this.envmap.put(name, value);
    }

    public void addEnvironmentVar(String name, Object value) {
        this.envmap.put(name, value);
    }

    public void removeEnvironmentVar(String name) {
        this.envmap.remove(name);
    }

    public Object getEnvironmentVar(String name) {
        return this.envmap.get(name);
    }

    public void addParameter(String key, String label, int type, Object defaultValue) {
        if (this.gatherParamPanel == null) {
            return;
        }
        this.gatherParamPanel.addParameter(key, label, type, defaultValue);
    }

    public boolean displayParameterGatherer(String title) {
        if (this.gatherParamPanel == null) {
            return false;
        }
        if (!this.gatherParamPanel.panelShown()) {
            int ans = JOptionPane.showConfirmDialog(null, this.gatherParamPanel, title, 2);
            if (ans == 2) {
                this.gatherParamPanel.setShown(false);
                return false;
            }
            this.gatherParamPanel.setShown(true);
            this.gatherParamPanel.setParamsInState();
        }
        return true;
    }

    public GatherParamPanel getParamPanel() {
        return this.gatherParamPanel;
    }

    public Set<String> getEnvironmentNames() {
        return this.envmap.keySet();
    }
}

