/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.ne.Resource;
import ghidra.app.util.bin.format.ne.ResourceStringTable;
import ghidra.app.util.bin.format.ne.ResourceTable;
import ghidra.util.Conv;
import java.io.IOException;
import java.util.ArrayList;

public class ResourceType {
    public static final short RT_CURSOR = 1;
    public static final short RT_BITMAP = 2;
    public static final short RT_ICON = 3;
    public static final short RT_MENU = 4;
    public static final short RT_DIALOG = 5;
    public static final short RT_STRING = 6;
    public static final short RT_FONTDIR = 7;
    public static final short RT_FONT = 8;
    public static final short RT_ACCELERATOR = 9;
    public static final short RT_RCDATA = 10;
    public static final short RT_MESSAGETABLE = 11;
    public static final short RT_GROUP_CURSOR = 12;
    public static final short RT_GROUP_ICON = 14;
    public static final byte RT_VERSION = 16;
    private short typeID;
    private short count;
    private int reserved;
    private Resource[] resources;

    ResourceType(FactoryBundledWithBinaryReader reader, ResourceTable rt) throws IOException {
        this.typeID = reader.readNextShort();
        if (this.typeID == 0) {
            return;
        }
        this.count = reader.readNextShort();
        this.reserved = reader.readNextInt();
        ArrayList<Resource> list = new ArrayList<Resource>();
        int count_int = Conv.shortToInt((short)this.count);
        for (int i = 0; i < count_int; ++i) {
            if ((short)(this.typeID & Short.MAX_VALUE) == 6) {
                list.add(new ResourceStringTable(reader, rt));
                continue;
            }
            list.add(new Resource(reader, rt));
        }
        this.resources = new Resource[list.size()];
        list.toArray(this.resources);
    }

    public short getTypeID() {
        return this.typeID;
    }

    public short getCount() {
        return this.count;
    }

    public int getReserved() {
        return this.reserved;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public String toString() {
        if ((this.typeID & 0x8000) == 0) {
            return "UnknownResourceType_" + this.typeID;
        }
        int idx = this.typeID & Short.MAX_VALUE;
        switch (idx) {
            case 1: {
                return "Cursor";
            }
            case 2: {
                return "Bitmap";
            }
            case 3: {
                return "Icon";
            }
            case 4: {
                return "Menu";
            }
            case 5: {
                return "Dialog Box";
            }
            case 6: {
                return "String Table";
            }
            case 7: {
                return "Font Directory";
            }
            case 8: {
                return "Font";
            }
            case 9: {
                return "Accelerator Table";
            }
            case 10: {
                return "Resource Data";
            }
            case 11: {
                return "Message Table";
            }
            case 12: {
                return "Cursor Directory";
            }
            case 14: {
                return "Icon Directory";
            }
            case 16: {
                return "Version Information";
            }
        }
        return "Unknown_" + idx;
    }
}

