/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.FileHeader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.PEx64UnwindInfo;
import ghidra.app.util.bin.format.pe.SectionHeader;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataUtilities;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ImageRuntimeFunctionEntries {
    private static final int UNWIND_INFO_SIZE = 12;
    List<_IMAGE_RUNTIME_FUNCTION_ENTRY> functionEntries = new ArrayList<_IMAGE_RUNTIME_FUNCTION_ENTRY>();

    static ImageRuntimeFunctionEntries createImageRuntimeFunctionEntries(FactoryBundledWithBinaryReader reader, long index, NTHeader ntHeader) throws IOException {
        ImageRuntimeFunctionEntries imageRuntimeFunctionEntriesSection = (ImageRuntimeFunctionEntries)reader.getFactory().create(ImageRuntimeFunctionEntries.class, new Object[0]);
        imageRuntimeFunctionEntriesSection.initImageRuntimeFunctionEntries(reader, index, ntHeader);
        return imageRuntimeFunctionEntriesSection;
    }

    private void initImageRuntimeFunctionEntries(FactoryBundledWithBinaryReader reader, long index, NTHeader ntHeader) throws IOException {
        int entryCount = 0;
        FileHeader fh = ntHeader.getFileHeader();
        for (SectionHeader section : fh.getSectionHeaders()) {
            if (!section.getName().contentEquals(".pdata")) continue;
            entryCount = section.getSizeOfRawData() / 12;
            break;
        }
        if (entryCount == 0) {
            return;
        }
        long origIndex = reader.getPointerIndex();
        reader.setPointerIndex(index);
        for (int i = 0; i < entryCount; ++i) {
            _IMAGE_RUNTIME_FUNCTION_ENTRY entry = new _IMAGE_RUNTIME_FUNCTION_ENTRY();
            entry.beginAddress = reader.readNextUnsignedInt();
            entry.endAddress = reader.readNextUnsignedInt();
            entry.unwindInfoAddressOrData = reader.readNextUnsignedInt();
            if (entry.beginAddress == 0L && entry.endAddress == 0L && entry.unwindInfoAddressOrData == 0L) break;
            entry.unwindInfo = PEx64UnwindInfo.readUnwindInfo(reader, entry.unwindInfoAddressOrData, ntHeader);
            this.functionEntries.add(entry);
        }
        reader.setPointerIndex(origIndex);
    }

    public List<_IMAGE_RUNTIME_FUNCTION_ENTRY> getRuntimeFunctionEntries() {
        return this.functionEntries;
    }

    public static void createData(Program program, Address headerStart, List<_IMAGE_RUNTIME_FUNCTION_ENTRY> irfes) {
        StructureDataType dt = new StructureDataType(".PDATA", 0);
        dt.setCategoryPath(new CategoryPath("/PE"));
        StructureDataType irfeStruct = new StructureDataType("_IMAGE_RUNTIME_FUNCTION_ENTRY", 0);
        irfeStruct.add(StructConverter.IBO32, "BeginAddress", null);
        irfeStruct.add(StructConverter.IBO32, "EndAddress", null);
        irfeStruct.add(StructConverter.IBO32, "UnwindInfoAddressOrData", null);
        ArrayDataType irfeArray = new ArrayDataType((DataType)irfeStruct, irfes.size(), irfeStruct.getLength());
        try {
            DataUtilities.createData((Program)program, (Address)headerStart, (DataType)irfeArray, (int)irfeArray.getLength(), (boolean)true, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
        }
        catch (CodeUnitInsertionException e) {
            return;
        }
    }

    public static class _IMAGE_RUNTIME_FUNCTION_ENTRY {
        long beginAddress;
        long endAddress;
        long unwindInfoAddressOrData;
        PEx64UnwindInfo unwindInfo;

        public void createData(Program program) {
            if (this.unwindInfoAddressOrData > 0L) {
                try {
                    DataType dt = this.unwindInfo.toDataType();
                    Address start = program.getImageBase().add(this.unwindInfoAddressOrData);
                    DataUtilities.createData((Program)program, (Address)start, (DataType)dt, (int)dt.getLength(), (boolean)true, (DataUtilities.ClearDataMode)DataUtilities.ClearDataMode.CHECK_FOR_SPACE);
                }
                catch (CodeUnitInsertionException | DuplicateNameException | IOException throwable) {
                    // empty catch block
                }
            }
        }
    }
}

